  @section('title','CRFC - POS')
  @extends('layouts.master')
  @section('style')
  {{-- {{Html::style('assets/public_css/index.css')}} --}}
  {{Html::style('assets/css/jquery-ui.css')}}
  {{Html::style('assets/css/select2.min.css')}}

  <style>
  td form {
      display: inline-block;
  }
  body {
      counter-reset: serial-number;
  }
  table#example23 tr td:first-child:before {
      counter-increment: serial-number;
      content: counter(serial-number);
  }
  .card-body {
    -webkit-box-shadow: 0 1px 15px 0px #999;
    -moz-box-shadow: 0 1px 15px 0px #999;
    box-shadow: 0 1px 15px 0px #999;
  }

  /* customise select2 start */
  .select2-container--default .select2-selection--single {
      border: 1px solid #ccc;
      border-radius: 0;
  }
  .select2-container .select2-selection--single {
      height: 35px;
  }
  .select2-container--default .select2-selection--single .select2-selection__rendered {
      line-height: 34px;
  }
  .select2-container .select2-selection--single .select2-selection__rendered {
      padding-left: 15px;
  }
  .select2-container--default .select2-selection--single .select2-selection__arrow {
      height: 33px;
  }
  .select2-container--default .select2-selection--single .select2-selection__arrow b {
      border-color: #444 transparent transparent transparent;
  }
  /* customise select2 end */
  </style>
  @endsection


  @section('content')

  <div class="page-wrapper">

      <div class="container-fluid">
          <div class="row page-titles">
          <div class="col-md-6">
            <h5>{{trans('label.Payment Receive Transection ')}}</h5>
          </div>
          <div class="col-md-6" style="text-align: right;">
            
             <a class="btn btn-success"  href="{{url('receive-transection-list')}}">  {{trans('label.receive_transection_list')}} </a>
            <button onclick="goBack()" class="btn btn-transparent-border"><i class="fa fa-chevron-left" aria-hidden="true"></i> {{trans('label.Back')}}</button>
          </div>
        </div>

        <div class="row">
          <div class="col-md-12">
            <div class="card">
               @if (Session::has('message'))
                         <h6 style="background: #20c997; color: #fff; text-align: center; padding: 5px; border-radius: 5px;">{{ Session::get('message') }}</h6>
                      @endif
              @if (Session::has('errormessage'))
                         <h6 style="background: red; color: #fff; text-align: center; padding: 5px; border-radius: 5px;">{{ Session::get('errormessage') }}</h6>
                      @endif
              <div class="card-body">
                <div class="container-fluid">
                  <form action="{{url('amount-received')}}" method="post" >
                    {{csrf_field()}}
                    @if($errors->any())
                    <h4 class="alert alert-warning" >{{$errors->first()}}</h4>
                    @endif

                    <div class="form-group row mt-3">
                      <label for="receiveableAccount" class="col-sm-3 col-form-label">{{trans('label.Receive To')}}</label>
                      <div class="col-sm-9">
                            <select name="store_place" class="form-control" id="receive_account_type">
                                <option value="cash">{{trans('label.Cash')}}</option>
                                <option value="bank">{{trans('label.Bank')}}</option>
                                <option value="mobile_bank">{{trans('label.Mobile Bank')}}</option>
                            </select>
                      </div>

                    </div>
                    <div  id="account_wise_referance">
                      <div class="form-group row">
                          <label for="receiveableAccount" class="col-sm-3 col-form-label">{{trans('label.Receive To')}}</label>
                          <div class="col-sm-9">
                                <select name="stored_cash_account" class="form-control" id="receive_bank_account">
                                  @forelse($accounts as $cash)
                                  <option value="{{ $cash->id ?? ''}}">{{ $cash->name ?? '' }}</option>
                                  @empty
                                  @endforelse
                                </select>
                          </div>
                      </div>
                      
                    </div>

                    <div class="form-group row">
                      <label for="ref_no" class="col-sm-3 col-form-label">{{trans('label.Account Type (Receive)')}}</label>
                          <div class="col-sm-9" id="receive_type_from">
                            <select name="receive_account_type" class="form-control" id="account_type_received">
                                 <option value="cash">{{trans('label.Cash')}}</option>
                                <option value="account_receivable">{{trans('label.Customer')}}</option>
                                <option value="bank">{{trans('label.Bank')}}</option>
                                <option value="mobile_bank">{{trans('label.Mobile Bank')}}</option>
                                <option value="account_payable">{{trans('label.Supplier')}}</option>
                                <!-- <option value="loan_receive_account">{{trans('label.Loan')}} </option>
                                <option value="investment_account">{{trans('label.Investment')}}</option> -->
                                <option value="expenses">{{trans('label.Expenses')}}</option>
                                <option value="capital">{{trans('label.Capital')}}</option>
                            </select>
                      </div>
                    </div>
                    <div class="form-group row">
                      <label for="account_no" class="col-sm-3 col-form-label">{{trans('label.Account')}} </label>
                      <div class="col-sm-9">
                         <select class="form-control js-example-responsive" id="receivedAccount" name="receive_from_account">
                              <!--Data will show after select Account Type (Receive)-->
                         </select>
                      </div>
                    </div>
                    <div class="form-group row">
                        <label for="amount" class="col-sm-3 col-form-label">{{trans('label.Amount')}} </label>
                        <div class="col-sm-9">
                           <input type="number" name="amount" step="any" autocomplete="off" required="required" class="form-control">
                      </div>
                    </div>
                    <div class="form-group row">
                        <label for="note" class="col-sm-3 col-form-label">{{trans('label.Note')}} </label>
                        <div class="col-sm-9">
                           <input type="text" name="note"  autocomplete="off" required="required" class="form-control">
                      </div>
                    </div>

                    <div class="row">
                      <div class="col-md-12">
                        <div class="pull-right">
                          <input type="submit" class="btn btn-success" value="{{trans('label.Received')}}" >
                        </div>
                      </div>
                    </div>

                  </form>
                </div>
              </div>
            </div>
          </div>

        </div>
  </div>

  @endsection


  @section('script')
  {{Html::script('assets/js/select2.min.js')}}

  <script>
    $(document).ready(function($) {
      $(".js-example-responsive").select2({
        width: '100%'
      });

      $.ajax({
        url: '{!! URL::to('receive-account')!!}',
          type: 'GET',
          dataType: 'html',
          data: {actype_receive: 'account_receivable'},
        })
        .done(function(data) {
          $('#receivedAccount').html(data);
        })



    //if selected bank then it will run for which bank account to receive
    $(document).on('change','#receive_account_type',function(){
        var  actype =  $(this).val();
        if(actype =='bank' || actype =='mobile_bank'){
          var actypeHtml = '<select name="receive_account_type" class="form-control" id="account_type_received"><option value="cash">Cash</option><option value="bank">Bank</option><option value="mobile_bank">Mobile Bank</option><option value="account_receivable">Customer</option><option value="account_payable">Supplier</option><option value="loan_receive_account">Loan </option><option value="investment_account">Investment</option><option value="expenses">Expenses</option><option value="capital">Capital</option>';
           $('#receivedAccount').html("<option value='1'>Cash Book</option>");

        }else if(actype =='cash'){
            var actypeHtml = '<select name="receive_account_type" class="form-control" id="account_type_received"><option value="bank">Bank</option><option value="mobile_bank">Mobile Bank</option><option value="account_receivable">Customer</option><option value="account_payable">Supplier</option><option value="loan_receive_account">Loan </option><option value="investment_account">Investment</option><option value="expenses">Expenses</option><option value="capital">Capital</option>';
             $('#receivedAccount').html("<option value=''>No Account Selected</option>");
        }
        $("#receive_type_from").html(actypeHtml);
        $.ajax({
        url: '{!! URL::to('find-referance-account')!!}',
          type: 'GET',
          dataType: 'html',
          data: {actype: actype},
        })
        .done(function(data) {
          console.log(data)
          $('#account_wise_referance').html(data);
        })
    });

    $(document).on('change','#account_type_received',function(){
          var bank_account = '';
          var mobile_bank = '';
          var receiveTo = '';
          var  actype_receive =  $(this).val();
          var receiveTo = $("#receive_account_type").val();
          if(receiveTo =='bank'){
             bank_account = $("#receive_bank_account").val();
           }else if(receiveTo =='mobile_bank'){
               mobile_bank = $("#mobile_bank_account").val();
           }
          $.ajax({
            url: '{!! URL::to('receive-account')!!}',
              type: 'GET',
              dataType: 'html',
              data: {actype_receive:actype_receive,bank_account:bank_account,mobile_bank:mobile_bank},
          })
          .done(function(data) {
            $('#receivedAccount').html(data);
          })
      });

    });

  </script>

  @endsection