@section('title','Supplier - POS')
@extends('layouts.master')
@section('style')
{{-- {{Html::style('assets/public_css/index.css')}} --}}
<style>
td form {
    display: inline-block;
}
body {
    counter-reset: serial-number;
}
table#example23 tr td:first-child:before {
    counter-increment: serial-number;
    content: counter(serial-number);
}
</style>
@endsection


@section('content')

<!-- ============================================================== -->
<!-- Page wrapper  -->
<!-- ============================================================== -->
<div class="page-wrapper">
    <!-- ============================================================== -->
    <!-- Container fluid  -->
    <!-- ============================================================== -->
    <div class="container-fluid">
        <!-- ============================================================== -->
        <!-- Bread crumb and right sidebar toggle -->
        <!-- ============================================================== -->
        <div class="row page-titles">
            <div class="col-md-5 align-self-center">
                <h4 class="text-themecolor"><span id="heading_field"></span> {{trans('label.Suppliers')}}</h4>
            </div>
            <div class="col-md-7 align-self-center text-right">
                <div class="d-flex justify-content-end align-items-center">
                    <div class="add_form_btn" style="text-align: right"><button class="btn btn-primary add"><i class="fa fa-plus-circle" aria-hidden="true"></i> {{trans('label.Create New')}}</button><button class="btn btn-danger remove" style="display: none;"><i class="fa fa-times" aria-hidden="true"></i> {{trans('label.Back')}}</button></div>
                </div>
            </div>
        </div>

        <!-- ============================================================== -->
        <!-- Start Page Content -->
        <!-- ============================================================== -->
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">

                        <div id="add_form" style="display: none;">
                            <div class="row">
                                <div class="col-md-12">
                                    <form class=""  method="post" action="{{url('supplier/store')}}" >
                                        {{csrf_field()}}
                                        <div class="row">
                                             <div class="col-md-4">
                                                <div class="form-group">
                                                    <label for="account_no">{{trans('label.Account Number')}} <span class="text-danger">*</span></label>
                                                    <div class="controls">
                                                        <input type="text" name="account_no" id="account_no" class="form-control"  value="{{old('account_no')}}" required="required">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label for="cname">{{trans('label.Name')}} <span class="text-danger">*</span></label>
                                                    <div class="controls">
                                                        <input type="text" name="name" id="name" class="form-control"  value="{{old('name')}}" required="required">
                                                    </div>
                                                </div>
                                            </div>
                                             <div class="col-md-4">
                                                <div class="form-group">
                                                    <label for="transection_term_id">{{trans('label.Supplier Type')}} <span class="text-danger">*</span></label>
                                                    <div class="controls">
                                                        <select class="form-control" name="transection_term_id" id="transection_term_id">
                                                            <option value="">{{trans('label.Supplier Type')}}</option>
                                                            @if($TransactionTerm)
                                                                @foreach($TransactionTerm as $item)
                                                                    <option value="{{ $item->id}}">{{ $item->name}}</option>
                                                                @endforeach
                                                            @endif
                                                        </select>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label for="category_id">{{trans('label.Supplier Category')}} <span class="text-danger">*</span></label>
                                                    <div class="controls">
                                                        <select class="form-control" name="category_id" id="category_id">
                                                            <option value="">{{trans('label.Supplier Catgory')}}</option>
                                                            @if($supplier_category)
                                                                @foreach($supplier_category as $category)
                                                                    <option value="{{ $category->id}}">{{ $category->name}}</option>
                                                                @endforeach
                                                            @endif
                                                        </select>

                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label for="phone">{{trans('label.Contact Number')}} <span class="text-danger">*</span></label>
                                                    <div class="controls">
                                                        <input type="text" name="phone" id="phone" class="form-control"  value="{{old('phone')}}" required="required">
                                                    </div>
                                                </div>
                                            </div>
                                             <div class="col-md-4">
                                                <div class="form-group">
                                                  <label for="credit">{{trans('label.Payable Amount')}}</label>
                                                    <input type="number" name="credit" id="credit" class="form-control"  value="0" required="required">
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                  <label for="debit">{{trans('label.Advance Paid')}}</label>
                                                    <input type="number" name="debit" id="debit" class="form-control"  value="0" required="required">
                                                </div>
                                            </div>

                                            <div class="col-md-8">
                                                <div class="form-group">
                                                  <label for="address">{{trans('label.Address')}}</label>
                                                    <input type="text" name="address" id="address" class="form-control"  value="{{old('address')}}" >
                                                </div>
                                            </div>

                                        </div>
                                        <div class="text-xs-right" style="text-align: right">
                                            <button type="submit" class="btn btn-info">{{trans('label.Submit')}}</button>
                                            <button type="reset" class="btn btn-inverse reset_button">{{trans('label.Cancel')}}</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <div class="table-responsive">
                                    <table id="example23" class="display nowrap table table-hover table-striped table-bordered" cellspacing="0" width="100%">
                                        <thead>
                                            <tr>
                                                <th>{{trans('label.SL')}}</th>
                                                <th>{{trans('label.Account No')}}</th>
                                                <th>{{trans('label.Name')}}</th>
                                                <th>{{trans('label.Address')}}</th>
                                                <th>{{trans('label.Contact')}}</th>
                                                <th>{{trans('label.Category')}}</th>
                                                <th>{{trans('label.Transection Type')}}</th>
                                                <th>{{trans('label.Balance')}}</th>
                                                <th>{{trans('label.Action')}}</th>
                                            </tr>
                                        </thead>

                                        <tbody>
                                            @if($supplier_info)
                                            @foreach($supplier_info as $supplier)
                                            <tr>
                                                <td></td>
                                                <td>{{ $supplier->account_no }}</td>
                                                <td>{{ $supplier->name }}</td>
                                                <td>{{ $supplier->address }}</td>
                                                <td>{{ $supplier->phone }}</td>
                                                <td>{{ $supplier->supplierCategory->name ?? null }} </td>
                                                <td>{{ $supplier->TransactionTerm->name ?? null }}</td>
                                                <td>

                                                    <?php
$suppliersum = 0;
foreach ($supplier->supplierAccount as $key => $value) {
	$suppliersum += $value->credit - $value->debit;
}
if ($suppliersum >= 0) {
	echo "Cr " . $suppliersum;
} else {
	echo "Dr " . $suppliersum;
}

?>
                                                </td>
                                                <td><a href="" class="btn btn-primary btn-sm" data-toggle="modal" data-target="#productEditModal"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></a>

                                                    {{ Form::open(array('url' => 'product-profile/')) }}
                                                    {{ Form::hidden('_method', 'DELETE') }}
                                                    {{ Form::button('<i class="fa fa-trash"></i>', ['type' => 'submit', 'class' => 'btn btn-danger btn-sm'] )  }}
                                                    {{ Form::button('<i class="fa fa-eye"></i>', ['type' => 'submit', 'class' => 'btn btn-primary btn-sm'] )  }}
                                                    {{ Form::close() }}
                                                </td>

                                            </tr>
                                        @endforeach
                                        @endif
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
        <!-- ============================================================== -->
        <!-- End PAge Content -->
        <!-- ============================================================== -->

        <!-- ============================================================== -->
        <!-- Right sidebar -->
        <!-- ============================================================== -->
        <!-- .right-sidebar -->
        <!-- ============================================================== -->
        <!-- End Right sidebar -->
        <!-- ============================================================== -->

    </div>
    <!-- ============================================================== -->
    <!-- End Container fluid  -->
    <!-- ============================================================== -->
</div>
<!-- ============================================================== -->
<!-- End Page wrapper  -->
<!-- ============================================================== -->

@endsection


@section('script')

<!--stickey kit -->
{{Html::script('assets/js/sticky-kit.min.js')}}
{{Html::script('assets/js/jquery.sparkline.min.js')}}
<!-- This is data table -->
{{Html::script('assets/js/jquery.dataTables.min.js')}}
<!-- start - This is for export functionality only -->
{{Html::script('assets/js/dataTables.buttons.min.js')}}
{{Html::script('assets/js/buttons.flash.min.js')}}
{{Html::script('assets/js/jszip.min.js')}}
{{Html::script('assets/js/pdfmake.min.js')}}
{{Html::script('assets/js/vfs_fonts.js')}}
{{Html::script('assets/js/buttons.html5.min.js')}}
{{Html::script('assets/js/buttons.print.min.js')}}
{{Html::script('assets/custom_js/crud.js')}}
{{Html::script('assets/custom_js/datatable.js')}}

<!-- end - This is for export functionality only -->
{{-- {{Html::script('assets/public_js/index.js')}} --}}
<script>
</script>



@endsection