<div class="row">
    <div class="col-12">
        @if ($errors->any())
            <div class="alert alert-danger">
                <ul>
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
        @if(!empty($info))
        <form class="" method="post" action="{{url('store-house-location',$info->id)}}">
            {{csrf_field()}}
            <input type="hidden" name="_method" value="PUT">
            <input type="hidden" name="id" value="{{$info->id}}">
            <div class="row">
                <div class="col-md-5">
                    <div class="form-group">
                        <h5>{{trans('label.S.House Location Name')}} <span class="text-danger">*</span></h5>
                        <div class="controls">
                            <input type="text" name="name" id="name" class="form-control prventSubmit" value="{{$info->name}}" required="required" tabindex="1">
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <h5>{{trans('label.Employee')}} <span class="text-danger">*</span></h5>
                        <div class="controls">
                            <select name="employee_id" class="form-control">
                                <option value="">{{trans('label.Select')}}</option>
                                @forelse($employee as $eminfo)
                                <option value="{{$eminfo->id}}" @if($eminfo->id==$info->employee_id) selected="selected" @endif>{{$eminfo->name}}</option>
                                @empty
                                @endforelse
                            </select>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="text-xs-right w-100" style="margin-top: 27px;float: left;">
                        <button type="submit"  class="btn btn-success btnSubmit w-48">{{trans('label.Update')}}</button>
                    </div>
                </div>
            </div>
        </form>
        @endif
    </div>
</div>