<div class="row">
    <div class="col-12">
        @if ($errors->any())
            <div class="alert alert-danger">
                <ul>
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
        <form class="" method="post" action="{{url('store-house-location')}}" id="crud_form">
            {{csrf_field()}}
            <div class="row">
                <div class="col-md-5">
                    <div class="form-group">
                        <h5>{{trans('label.S.House Location Name')}} <span class="text-danger">*</span></h5>
                        <div class="controls"><input type="hidden" name="id" id="id"  class="form-control prventSubmit">
                            <input type="text" name="name" id="name" class="form-control prventSubmit" value="{{ old('name') }}" required="required" tabindex="1">
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <h5>{{trans('label.Employee')}} <span class="text-danger">*</span></h5>
                        <div class="controls">
                            <select name="employee_id" class="form-control">
                                <option value="">{{trans('label.Select')}}</option>
                                @forelse($employee as $eminfo)
                                <option value="{{$eminfo->id}}">{{$eminfo->name}}</option>
                                @empty
                                @endforelse
                            </select>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="text-xs-right w-100" style="margin-top: 26px;float: left;">
                        <button type="submit" id="submit_button" class="btn btn-success w-48 btnSubmit">{{trans('label.Submit')}}</button>
                        <button type="reset" class="btn btn-inverse w-48">{{trans('label.Cancel')}}</button>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>