@section('title','Shop configuration - POS')
@extends('layouts.master')
@section('style')
{{-- {{Html::style('assets/public_css/index.css')}} --}}
<style>
td form {
    display: inline-block;
}
body {
    counter-reset: serial-number;
}
table#example23 tr td:first-child:before {
    counter-increment: serial-number;
    content: counter(serial-number);
}
</style>
@endsection


@section('content')

<div class="page-wrapper">

    <div class="container-fluid">
        <div class="row page-titles">
            <div class="col-md-12 align-self-center">
                <h4 class="text-themecolor title"><span id="heading_field"></span> {{trans('label.Action')}}Shop Configuration</h4>


            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
            <div class="text-center mb-2">
             @if($info->image !=null)
            <div id="image_preview">{{ Html::image('storage/image/shop_logo/'.$info->image, 'logo', array('class'=>'img-resposive', 'id'=>'previewing','width'=>'80px','height'=>'80px'))}}</div>
            @else
            <div id="image_preview">{{ Html::image('assets/images/leftjoin_logo.png', 'logo', array('class'=>'img-resposive', 'id'=>'previewing','width'=>'80px','height'=>'80px'))}}</div>
            @endif
            </div>
        </div>
        </div>




        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div>
                            <div class="row">
                                <div class="col-12">
                                    @if ($errors->any())
                                        <div class="alert alert-danger">
                                            <ul>
                                                @foreach ($errors->all() as $error)
                                                    <li>{{ $error }}</li>
                                                @endforeach
                                            </ul>
                                        </div>
                                    @endif
                                    @if(!empty($info))
                                    <form  method="post" action="{{url('shop')}}" enctype="multipart/form-data">
                                        {{csrf_field()}}
                                        <div class="row">
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label for="shop_name">{{trans('label.Shop Name')}}<span class="text-danger">*</span></label>
                                                    <div class="controls">
                                                        <input type="hidden" name="id" value="{{$info->id}}">
                                                        <input type="text" name="shop_name" id="shop_name" class="form-control prventSubmit" value="{{$info->shop_name}}" placeholder="{{trans('label.Enter shop name')}}"  required="required" tabindex="1">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label for="shop_email">{{trans('label.Email')}} <span class="text-danger">*</span></label>
                                                    <div class="controls">
                                                        <input type="email" name="shop_email" id="shop_email" class="form-control prventSubmit" value="{{$info->shop_email}}" placeholder="{{trans('label.Enter email address')}}" required="required" tabindex="2">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label for="shop_phone">{{trans('label.Contact Number')}} <span class="text-danger">*</span></label>
                                                    <div class="controls">
                                                        <input type="text" name="shop_phone" id="shop_phone" class="form-control prventSubmit" value="{{$info->shop_phone}}" placeholder="{{trans('label.Enter contact number')}}" required="required" tabindex="3">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label for="shop_address">{{trans('label.Address')}} <span class="text-danger">*</span></label>
                                                    <div class="controls">
                                                        <input type="text" name="shop_address" id="shop_address" class="form-control prventSubmit" value="{{$info->shop_address}}" placeholder="{{trans('label.Enter shop address')}}" required="required" tabindex="4">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label>{{trans('label.Invoice layout')}} <span class="text-danger">*</span></label>
                                                    <div class="controls">
                                                        <select name='invoice_layout' class="form-control prventSubmit">
                                                            <option value="1" @if($info->invoice_layout==1) selected="selected" @endif>Default(A4)</option>
                                                            <option value="2" @if($info->invoice_layout==2) selected="selected" @endif>A5</option>
                                                            <option value="3" @if($info->invoice_layout==3) selected="selected" @endif>A6</option>
                                                            <option value="4" @if($info->invoice_layout==4) selected="selected" @endif>A7</option>
                                                            <option value="5" @if($info->invoice_layout==4) selected="selected" @endif>A8</option>
                                                            <option value="6" @if($info->invoice_layout==4) selected="selected" @endif>A9</option>

                                                        </select>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-md-4">
                                                <div class="form-group">
                                                <div class="form-group">
                                                    <label for="image">{{trans('label.Shop logo')}} @if($info->image ==null)<span class="text-danger">*</span> @endif</label>
                                                    <div class="controls">
                                                        <input type="file" @if($info->image ==null) required @endif class="form-control prventSubmit" name="image"  id="image">
                                                    </div>
                                                </div>
                                            </div>

                                        </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-12">
                                                <div class="text-xs-right pull-right" style="margin-top: 26px;">
                                                    <button type="submit"  class="btn btn-success btnSubmit">{{trans('label.Update')}}</button>
                                                </div>
                                                </div>

                                        </div>
                                    </form>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>

@endsection


@section('script')

<!--stickey kit -->
{{Html::script('assets/js/sticky-kit.min.js')}}
{{Html::script('assets/js/jquery.sparkline.min.js')}}
<!-- This is data table -->
{{Html::script('assets/js/jquery.dataTables.min.js')}}
<!-- start - This is for export functionality only -->
{{Html::script('assets/js/dataTables.buttons.min.js')}}
{{Html::script('assets/js/buttons.flash.min.js')}}
{{Html::script('assets/js/jszip.min.js')}}
{{Html::script('assets/js/pdfmake.min.js')}}
{{Html::script('assets/js/vfs_fonts.js')}}
{{Html::script('assets/js/buttons.html5.min.js')}}
{{Html::script('assets/js/buttons.print.min.js')}}
{{Html::script('assets/custom_js/crud.js')}}

<!-- end - This is for export functionality only -->
{{-- {{Html::script('assets/public_js/index.js')}} --}}
<script>
$(document).ready(function() {
$("#image").change(function() {
var file = this.files[0];
var imagefile = file.type;
var imageSize=file.size/1024;
console.log(imageSize);
var match= ["image/jpeg","image/png","image/jpg"];
if(!((imagefile==match[0]) || (imagefile==match[1]) || (imagefile==match[2])))
{

$('#previewing').attr('src','/assets/images/leftjoin_logo.png');
alert("Only jpeg, jpg and png Images type allowed");
$("#image").val('');
return false;
}
else
{
  if(imageSize>2000){
    $('#previewing').attr('src','/assets/images/leftjoin_logo.png');
  alert("Image size should be less than 2 mb .");
  $("#image").val('');
return false;
  }
var reader = new FileReader();
reader.onload = imageIsLoaded;
reader.readAsDataURL(this.files[0]);
}
});
});
function imageIsLoaded(e) {
$("#file").css("color","green");
$('#image_preview').css("display", "block");
$('#previewing').attr('src', e.target.result);
$('#previewing').attr('width', '80px');
$('#previewing').attr('height', '80px');
};
</script>

@endsection