

<div class="table-responsive">
    <table id="example23" class="display nowrap table table-hover table-striped table-bordered" cellspacing="0" width="100%">
        <thead>
            <tr>

                <th>{{trans('label.Order Id')}}</th>
                <th>{{trans('label.Customer')}}</th>
                <th>{{trans('label.Phone')}}</th>
                <th>{{trans('label.Sales')}}</th>
                <th>{{trans('label.Received')}}</th>
                <th>{{trans('label.Due Amount')}}</th>
                <th>{{trans('label.Created at')}}</th>
                <th>{{trans('label.Action')}}</th>
            </tr>
        </thead>

        <tbody>

            @forelse($info as $invoice)

            <tr>

                <td class="text-right">{{$invoice->order_number}}</td>
                <td>{{$invoice->customerName}}</td>
                <td>{{$invoice->customer->phone ?? null}}</td>
                <td class="text-right">{{number_format(($invoice->payment_amount ?? 0),2)}}</td>
                <td class="text-right">{{number_format(($invoice->receive_amount_from_custome ?? 0),2)}}</td>
                <td class="text-right">{{number_format(($invoice->due_amount - $invoice->return_amount ?? 0),2)}}</td>
                <td>{{$invoice->created_at}}</td>
                <td>
                <a href="{{url('sales-invoices',$invoice->order_number)}}"> {{trans('label.view')}}</a> | <a href="{{url('sales-invoices',$invoice->order_number)}}" class="print_sales_invoice">{{trans('label.Print')}}</a></td>
            </tr>

            @empty
            @endforelse
            @if(count($saleWithReturn) > 0)
             @forelse($saleWithReturn as $returnInvoice)
            <tr>
                <td class="text-right">{{$returnInvoice->order_number }}</td>
                <td>{{$returnInvoice->customerName }}</td>
                <td>{{$returnInvoice->phone ?? null}}</td>
                <td class="text-right">{{$returnInvoice->payment_amount - $returnInvoice->return_return_amount}}</td>
                <td class="text-right">{{$returnInvoice->receive_amount_from_custome }}</td>
                <td class="text-right">{{($returnInvoice->due_amount) }}</td>
                <td>{{$returnInvoice->created_at}}</td>
                <td><a href="{{url('sales-invoices',$returnInvoice->order_number)}}">{{trans('label.view')}}</a> | <a href="{{url('sales-invoices',$returnInvoice->order_number)}}" class="print_sales_invoice">{{trans('label.Print')}}</a></td>
            </tr>

            @empty
            @endforelse
            @endif



        </tbody>
    </table>
</div>
