@section('title','Sales Invoice report')
@extends('layouts.master')
@section('style')
{{Html::style('assets/css/daterangepicker.css')}}
<style>
td form {
    display: inline-block;
}
</style>
@endsection


@section('content')
 <script>
</script>

<div class="page-wrapper">
    <div class="container-fluid">
        <div class="row page-titles">
          <div class="col-md-6">
            <h5>{{trans('label.Sales Report')}}</h5>
          </div>
          <div class="col-md-6" style="text-align: right;">
            <a href="{{ url('sales') }}" class="btn btn-success">{{trans('label.Make sales')}}</a>
            <button onclick="goBack()" class="btn btn-transparent-border"><i class="fa fa-chevron-left" aria-hidden="true"></i> {{trans('label.Back')}}</button>
          </div>
        </div>
        <div class="row">
            <div class="col-md-3">
               <div id="reportrange" style="background: #fff; cursor: pointer; padding: 5px 10px; border: 1px solid #ccc; width: 100%">
                <i class="fa fa-calendar"></i>&nbsp;
                <span></span> <i class="fa fa-caret-down"></i>

               </div>
            </div>
            <div class="col-md-1 pl-0">
                <form>
                    <input type="hidden" name="date_range" class="date_range">
                    <input type="submit" value="Change" class="btn btn-success" style="padding: 7px 10px;border-radius: 0;">
                </form>

            </div>
            <div class="col-md-3">
              
            </div>
            <div class="col-12">
                <div class="card-body-wrapper">
                    <div id='table_position'>
                      

                    <div class="table-responsive">
                        <table id="example23" class="display nowrap table table-hover table-striped table-bordered" cellspacing="0" width="100%">
                            <thead>
                                <tr>
                                    <th>{{trans('label.SL')}}</th>
                                    <th>{{trans('label.Order Id')}}</th>
                                    <th>{{trans('label.Customer')}}</th>
                                    <th>{{trans('label.Phone')}}</th>
                                    <th>{{trans('label.Gross Amount')}}</th>
                                    <th>{{trans('label.Discount')}}</th>
                                    <th>{{trans('label.Vat')}}</th>
                                    <th>{{trans('label.Net Amount')}}</th>
                                    <th>{{trans('label.Created at')}}</th>
                                    <th>{{trans('label.Action')}}</th>
                                </tr>
                            </thead>

                            <tbody>

                                @forelse($info as $key=>$invoice)

                                <tr>

                                    <td class="text-right">{{ ($key+1) }}</td>
                                    <td>{{ $invoice->id ?? '' }}</td>
                                    <td>{{$invoice->account_details->name ?? null}}</td>
                                    <td>{{$invoice->account_details->phone ?? null}}</td>
                                    <td>{{$invoice->gross_amount ?? 0}}</td>
                                    <td>{{$invoice->gross_discount ?? null}}</td>
                                    <td>{{$invoice->gross_vat_amount ?? null}}</td>
                                    <td>{{number_format(((($invoice->gross_amount ?? 0) + ($invoice->gross_vat_amount ?? 0)) - ($invoice->gross_discount ?? 0) ),2)}}</td>
                                    <td>{{$invoice->created_at}}</td>
                                    <td>
                                    <a href="{{url('sales-invoices',$invoice->id)}}"> {{trans('label.view')}}</a> | <a href="{{url('sales-invoices',$invoice->id)}}" class="print_sales_invoice">{{trans('label.Print')}}</a></td>
                                </tr>

                                @empty
                                @endforelse
                                



                            </tbody>
                        </table>
                    </div>

                    </div>
                    <div style="display:none" class="dynamic_print">

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection
@section('script')

<!--stickey kit -->
{{Html::script('assets/js/sticky-kit.min.js')}}
{{Html::script('assets/js/jquery.sparkline.min.js')}}
<!-- This is data table -->
{{Html::script('assets/js/jquery.dataTables.min.js')}}
<!-- start - This is for export functionality only -->
{{Html::script('assets/js/dataTables.buttons.min.js')}}
{{Html::script('assets/js/buttons.flash.min.js')}}
{{Html::script('assets/js/jszip.min.js')}}
{{Html::script('assets/js/pdfmake.min.js')}}
{{Html::script('assets/js/vfs_fonts.js')}}
{{Html::script('assets/js/buttons.html5.min.js')}}
{{Html::script('assets/js/buttons.print.min.js')}}
{{Html::script('assets/custom_js/crud.js')}}
{{Html::script('assets/custom_js/datatable.js')}}

{{Html::script('assets/js/moment.min.js')}}
{{Html::script('assets/js/daterangepicker.min.js')}}
@if($request->all()==null)
<script>

    $(function() {

      $('.print_sales_invoice').click(function(e){
          e.preventDefault();
          var url=$(this).attr('href');
          $.ajax({
            url:url,
            type: 'GET',
            dataType: 'html',
          })
          .done(function(success) {
            console.log(success);
            $('.dynamic_print').html(success);
            var restorepage = document.body.innerHTML;
            var printcontent = document.getElementById('invoice_details').innerHTML;
            document.body.innerHTML = printcontent;
            window.print();
            document.body.innerHTML = restorepage;
          })
          .fail(function() {
            console.log("error");
          })
          .always(function() {
            console.log("complete");
          });
        })

    var start = moment().subtract(29, 'days');
    var end = moment();

    function cb(start, end) {
        $('#reportrange span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
        $('input.date_range').val(start.format('Y-MM-DD')+' '+ end.format('Y-MM-DD'));
    }

    $('#reportrange').daterangepicker({
        startDate: start,
        endDate: end,
        ranges: {
           'Today': [moment(), moment()],
           'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
           'Last 7 Days': [moment().subtract(6, 'days'), moment()],
           'Last 30 Days': [moment().subtract(29, 'days'), moment()],
           'This Month': [moment().startOf('month'), moment().endOf('month')],
           'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
        }
    }, cb);

    cb(start, end);

});
</script>
@else
@php
$time = explode(' ', $_GET['date_range']);
@endphp
@if(array_key_exists(0, $time) && array_key_exists(1, $time))
@php
$start_date = $time[0];
$end_date = $time[1];
@endphp
<input type="hidden" id="start_date" value="{{$start_date }}">
<input type="hidden" id="end_date" value="{{$end_date }}">
<script>

    $(function() {
    var start_date=$('#start_date').val();
    var end_date=$('#end_date').val();
    var start = moment(start_date);
    var end = moment(end_date);

    function cb(start, end) {
        $('#reportrange span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
        $('input.date_range').val(start.format('Y-MM-DD')+' '+ end.format('Y-MM-DD'));
    }

    $('#reportrange').daterangepicker({
        startDate: start,
        endDate: end,
        ranges: {
           'Today': [moment(), moment()],
           'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
           'Last 7 Days': [moment().subtract(6, 'days'), moment()],
           'Last 30 Days': [moment().subtract(29, 'days'), moment()],
           'This Month': [moment().startOf('month'), moment().endOf('month')],
           'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
        }
    }, cb);

    cb(start, end);

});
</script>
@endif
@endif

@endsection