@section('title','return  Order - POS')
@extends('layouts.master')
@section('style')
{{-- {{Html::style('assets/public_css/index.css')}} --}}
<style>
td form {
  display: inline-block;
}
.right_side_panel {
  background: #999;
  padding: 15px 7px;
  color: #fff;
}


.btn-transparent.active {
  border-color: #6692B0;
  background-color: #6692B0;
  color: #FFF;
}
td form {
  display: inline-block;
}
.right_side_panel {
  background: #999;
  padding: 15px 7px;
  color: #fff;
}
.product-name {
  font-size: 17px;
  font-weight: bold;
}
.single-product .media {
  position: relative;
}
.single-product .media[aria-expanded='false'] .arrow:before {
  content: "\f105";
  font-family: 'FontAwesome';
  position: absolute;
  left: 0px;
  top: 0px;
  color: #555;
  font-size: 16px;
}
.single-product .media[aria-expanded='true'] .arrow:before {
  content: "\f107";
  font-family: 'FontAwesome';
  position: absolute;
  left: -3px;
  top: 0px;
  color: #555;
  font-size: 16px;
}
#selected_customer {
  padding: 10px;
}
#selected_customer .customer_link {
  font-size: 16px;
  font-weight: bold;
  cursor: pointer;
}

/* table style start */
.table td {
  padding: 0;
}
.table td input {
  width: 100%;
}
/* table style end */
.table td input {
  width: 100%;
  border: 0;
  text-align: center;
  padding: 0 6px;
}

/* modal style start */
.modal-header {
  border-bottom: 0;
  padding-bottom: 0;
}
.info-heading .title {
  border-bottom: 1px solid #ddd;
}
.info-heading .info .lebel {
  color: #6692B0;
}
/* modal style end */
.card.shadow {
  box-shadow: 0 .5rem 1rem rgba(0,0,0,.15)!important;
}
.modal-content {
    border: 1px solid rgba(27, 142, 19, 0.94);
}
.modal-header {
    border-bottom: 1px solid rgba(27, 142, 19, 0.94);
}
.modal-footer {
    border-top: 1px solid rgba(27, 142, 19, 0.94);
}
</style>
@endsection


@section('content')


<div class="page-wrapper">
  <div class="container-fluid">
    <div class="row">
      <div class="col-md-6">
        {{trans('label.Sales Return')}}
      </div>
      <div class="col-md-6">
        <a href="{{ url('sales-invoices')}}" class="btn btn-success pull-right">{{trans('label.Sales Invoice List')}}</a>
      </div>


      <div class="col-md-12">
        @if (Session::has('message'))
                       <h6 style="background: #20c997; color: red; text-align: center; padding: 5px; border-radius: 5px;">{{ Session::get('message') }}</h6>
                    @endif
        <div class="card shadow">
          <div class="card-body">
            <form action="{{ url('sales-return-confirm')}}"  method="post">
              {{csrf_field()}}
              <div class="row">
                <div class="col-md-3">
                    <div class="form-group">
                      <label for="customer_field">{{trans('label.Customer')}} <span class="text-danger">*</span></label>
                      <div>

                      <input type="text" attr_url="" name="custoerDeails" id="custoerDeails" class="form-control" required="required" value="{{ $customerInfo->id ? : 0 }} - {{ $customerInfo->name ? : "Walking Customer" }}" readonly="readonly">
                      <input type="hidden" name="customer" id="customer_field" class="form-control" value="{{ $customerInfo->id ? : 0 }}" readonly="readonly" required="required">
                      </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="ref_no">{{trans('label.Supplier Ref')}} : <span class="text-danger">*</span></label>
                        <div class="controls">
                          <input type="text" name="ref_no" id="ref_no" class="form-control text-right">
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group text-center">
                        <label for="preorder_ref">{{trans('label.Order Ref')}} : </label>
                        <div class="controls">
                          <input type="text" name="preorder_ref" id="preorder_ref" class="form-control" value="{{$sales_orders->id }}" readonly="readonly" required="required">
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                  <div class="form-group">
                      <label for="transection_type">{{trans('label.Sales Date')}} <span class="text-danger">*</span></label>
                      <input class="form-control text-right" name="transection_term_id" id="transection_type" type="text" required="required" readonly="readonly" value="{{ $sales_orders->order_date}}">



                  </div>
                </div>

              </div>

              <div class="searching-items">
                <div class="table-responsive">
                  <table id="example23" class="tem_product display nowrap table table-hover table-striped table-bordered view_data_table" cellspacing="0" width="100%">
                    <thead>
                      <tr>
                        <th>{{trans('label.Barcode')}}</th>
                        <th>{{trans('label.Product Name')}}</th>
                        <th>{{trans('label.Quantity')}}</th>
                        <th>{{trans('label.Sales Price (unit)')}}</th>
                        <th>{{trans('label.VAT')}} %</th>
                        <th>{{trans('label.Discount')}} %</th>
                        <th>{{trans('label.Line Total')}}</th>
                        <th>{{trans('label.Action')}}</th>
                      </tr>
                    </thead>
                    <tbody>
@foreach($sales_details as $sales)
                      <tr class="single_return">
                        <td>
                          <input type='text'  name='barcode[]' value='{{ $sales->unique_barcode }}' class='text-right' readonly="readonly">
                        </td>
                        <td>
                          <input  type='hidden' class='product_id' id='{{$sales->product_id}}' value='{{ $sales->product_id }}' name='product_id[]' readonly="readonly">
                          @foreach($product_profiles as $product)
                          @if($product->id == $sales->product_id)
                          <input type='text'  name='product_details[]' value='{{ $sales->product_id }} {{ $product->name }}' class='text-right' readonly="readonly" required="required">
                          @endif
                          @endforeach
                        </td>
                        <td>
                          <input type='number' step='any' min='1' class='form-control qty text-right'   value='{{$sales->qty}}' name='qty[]' autocomplete="off">
                          <input type='hidden' class='form-control qty_default text-right'   value='{{$sales->qty}}'  autocomplete="off">
                        </td>
                         <td>


                          <input type='number'  step='any' class='form-control sales_price text-right'  value='{{ $sales->sales_price }}'  name='sales_price[]' readonly="readonly">

                        </td>
                         <td>
                          <input type='number' step='any' name='vat_rate[]' value='{{ $sales->vat_rate }}' class='vat_rate text-right' required="required" min="0" readonly="readonly">
                        </td>
                        <td>
                          <input type='number' step='any' class='form-control discount_rate text-right'  name='discount_rate[]' value='{{$sales->discount_rate }}' min="0" autocomplete="off" readonly="readonly">
                        </td>
                         <td>
                          <input type='hidden' step='any' name='line_total[]' value='{{ $sales->line_total }}' class=' text-right' required="required" min="0" readonly="readonly">

                          <input  type='hidden' class='discount_line_total' id='discount_line_total{{$sales->id}}' value='{{ (($sales->qty * $sales->sales_price) * $sales->discount_rate)/100 }}' name='discount_line_total[]'>

                           @php
                              $totalSales = $sales->qty * $sales->sales_price;
                              $discount = ($totalSales * $sales->discount_rate)/100;
                              $salesAfterDiscount = $totalSales - ($totalSales * $sales->discount_rate)/100;
                              $vatAmount = ($salesAfterDiscount * $sales->vat_rate)/100;

                              @endphp
                            <input  type='hidden' class='sales_price_line_total' id='sales_price_line_total{{$sales->id}}' value='{{$sales->qty * $sales->sales_price}}' name='sales_price_line_total[]' readonly="readonly">
                            <input  type='number' class='sales_price_afterVD' id='sales_price_line_total{{$sales->id}}' value='{{($totalSales -$discount)+ $vatAmount}}' name='sales_price_line_total[]' readonly="readonly">
                            <input  type='hidden' id='vat_line_total{{$sales->id}}' class='vat_line_total' value='{{$vatAmount}}' name='vat_line_total[]'>
                          @foreach($costPriceD as $cost)
                          @if($cost->product_id  == $sales->product_id && $cost->order_id == $sales->lot_no)
                          <input  type='hidden' class='cost_price' id='cost_price{{$cost->id}}' value='{{ $cost->cost_price }}' name='cost_price[]'>
                          <input  type='hidden' class='cost_price_line_total' id='cost_price_line_total{{$cost->id}}' value='{{$sales->qty * $cost->cost_price}}' name='cost_price_line_total[]'>
                          <input  type='hidden' class="product_lot_no"  value='{{$sales->lot_no}}' name='product_lot_no[]'>
                          @endif
                          @endforeach

                        </td>

                        <td class="text-center">
                          <a class="delpurchaseTemp" href="">
                            <i class='fa fa-trash' aria-hidden='true'></i>
                          </a>
                        </td>
                      </tr>

    @endforeach

                    </tbody>
                  </table>
                </div>

                <div class="row grand_total_field text-center">
                    <div class="col-md-2">
                      <div class="form-group">
                        <label for="gross_amount">{{trans('label.Gross total')}} <span class="text-danger"></span></label>
                        <input type="text" name="gross_amount"  class="form-control gross_total_input text-right " value="{{ $sales_orders->gross_amount }}" readonly="readonly" required="required">
                      </div>
                    </div>
                    <div class="col-md-2">
                      <div class="form-group">
                        <label for="discount_total">{{trans('label.Discount total')}} <span class="text-danger"></span></label>
                        <input type="number" step="any" name="gross_discount"  class="form-control gross_discount_input text-right " value="{{$sales_orders->gross_discount}}" required="required" readonly="readonly">
                      </div>
                    </div>
                    <div class="col-md-2">
                      <div class="form-group">
                        <label for="vat_total">{{trans('label.Vat Total')}} <span class="text-danger"></span></label>
                        <input type="number" step="any" name="gross_vat_amount"  class="form-control gross_tax_input text-right" value="{{$sales_orders->gross_vat_amount}}" required="required" readonly="readonly">
                      </div>
                    </div>

                    <div class="col-md-2">
                      <div class="form-group">
                        <label for="net_amount">{{trans('label.Net Amount')}} <span class="text-danger"></span></label>
                        <input type="number" step="any" name="net_amount"  class="form-control net_total_input text-right" value="{{$sales_orders->payment_amount}}" required="required" readonly="readonly">

                        <input type="hidden" step="any" name="default_net_sales"  class="form-control default_net_sales text-right" value="{{$sales_orders->payment_amount}}" required="required" readonly="readonly">
                      </div>
                    </div>
                   <div class="col-md-2" style="color:red;">
                    <div class="form-group">
                      <label for="paid_amount">{{trans('label.Refund From Cash Account')}} <span class="text-danger"></span></label>
                      <input type="number" step="any" name="payment_amount"  class="form-control text-right refund" value="<?php if ($sales_orders->due_amount == 0.00) {echo 0;} else {echo $sales_orders->receive_amount_from_custome;}?>" >
                    </div>
                   </div>
                   <div class="col-md-2">
                      <div class="form-group">
                        <label for="due_amount">{{trans('label.Due Amount')}} <span class="text-danger"></span></label>
                        <input type="number" step="any" name="previousDue_amount"  class="form-control text-right Due_amount " value="{{$sales_orders->due_amount}}" required="required" readonly="readonly">

                        <input type="hidden" step="any" name="default_Due_amount"  class="form-control text-right default_Due_amount " value="{{$sales_orders->due_amount}}" required="required" readonly="readonly">

                         <input type="hidden" step="any" name="receive_amount_from_custome"  class="form-control text-right receive_amount_from_custome " value="{{$sales_orders->receive_amount_from_custome ?? 0 }}" required="required" readonly="readonly">
                      </div>
                   </div>
                    <div class="col-md-12">
                  <div class="form-group">

                        <input type="text" name="note"  class="form-control"  required="required" autocomplete="off" style="border-radius:  5px; min-height: 50px; " placeholder="{{trans('label.Write Reson of Return')}} ">

                </div>
                    <div class="col-md-12">
                      <button type="submit" id="sales_return_confirm" class="btn btn-success btn-lg pull-right" style="width: 100%">
                            {{trans('label.Return')}} <span class="inner-badge">F2</span>
                          </button>
                    </div>
                </div>

              </div>
            </form>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>



@endsection


@section('script')

<!--stickey kit -->
{{Html::script('assets/js/sticky-kit.min.js')}}
{{Html::script('assets/js/jquery.sparkline.min.js')}}
<!-- This is data table -->
{{Html::script('assets/js/jquery.dataTables.min.js')}}
<!-- start - This is for export functionality only -->
{{Html::script('assets/js/dataTables.buttons.min.js')}}
{{Html::script('assets/js/buttons.flash.min.js')}}
{{Html::script('assets/js/jszip.min.js')}}
{{Html::script('assets/js/pdfmake.min.js')}}
{{Html::script('assets/js/vfs_fonts.js')}}
{{Html::script('assets/js/buttons.html5.min.js')}}
{{Html::script('assets/js/buttons.print.min.js')}}
{{Html::script('assets/custom_js/crud.js')}}
{{Html::script('assets/custom_js/add_more.js')}}

<link rel="stylesheet" href="//code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">


<script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
{{Html::script('assets/custom_js/salesReturn.js')}}

@endsection