@section('title','Credit Invoice Report')
@extends('layouts.master')
@section('style')
<style>
.table td, .table th {
  max-width: 30px;
}
.table td input {
  max-width: 100%;
  text-overflow: ellipsis;
  white-space: nowrap;
  overflow: hidden;
}
</style>
@endsection

@section('content')
<div class="page-wrapper">
  <div class="container-fluid">
    <div class="row page-titles">
        <div class="col-md-5 align-self-center">
            <h4 class="text-themecolor title"><span id="heading_field"></span> {{trans('label.Pre Order Sales Confirm')}}</h4>
        </div>
        <div class="col-md-7 align-self-center text-right">
            <div class="d-flex justify-content-end align-items-center">
                <div class="" style="text-align: right"><button class="btn btn-primary add"> <a href="{{ url('sales-preorder-invoice') }}" style="color: #fff"><i class="fa fa-chevron-circle-left" aria-hidden="true"></i> {{trans('label.Back')}}</a></button></div>
            </div>
        </div>
    </div>
    <section class="card shadow content">
      <div class="card-body">
          @if (Session::has('message'))
                       <h6 style="background: #20c997; color: red; text-align: center; padding: 5px; border-radius: 5px;">{{ Session::get('message') }}</h6>
                       <a href="{{ url('sales-preorder-invoice')}}" class="btn btn-success">{{trans('label.Pre Order Invoice List')}}</a>
                    @endif
      <!-- /.box-header -->
      <form action="{{ url('preorder-sales')}}" method="post">
        {{csrf_field()}}
      <div class="panel-body" id="invoice_details">
        <div class="row">
          <div class="col-md-6 col-sm-6 col-lg-6 text-left">
          <?php
if (isset($customerInfo)) {?>
                <p><strong>{{trans('label.Customer')}} : {{$customerInfo->id}} - {{$customerInfo->name}}
                </strong>
                <input type="hidden" name="customer_id" readonly="readonly" value="{{$customerInfo->id}}">
                <input type="hidden" name="customer_name" readonly="readonly" value="{{$customerInfo->name}}"></p>
                <p><strong>{{trans('label.Phone')}} : {{$customerInfo->phone}}</strong>
                  <input type="hidden" name="phone" readonly="readonly" value="{{$customerInfo->phone }}">
                </p>
                <p><strong>{{trans('label.Address')}} : {{$customerInfo->address}}</strong>
                  <input type="hidden" name="address" readonly="readonly" value="{{$customerInfo->address }}">
                </p>
       <?php }?>

          </div>
          <div class="col-md-6 col-sm-6 col-lg-6 text-right">
            <?php
if (isset($sales_orders)) {?>
            <p><strong{{trans('label.Date')}}> :  <input type="text" name="order_date" value="{{ $sales_orders->order_date}}" readonly="readonly"></strong></p>
            <p><strong>{{trans('label.Invoice No')}}: <input type="text" name="order_id" readonly="readonly" value="{{ $sales_orders->id}}"></strong></p>
            <p> <strong>{{trans('label.Transaction Type')}}: <input type="text" name="transection_type" readonly="readonly" value="{{ $sales_orders->transection_type}}"></strong></p>

          </div>
        </div><!-- End of Row -->
        <!-- product add part start -->
        <div class="table-responsive">
          <table class="table table-bordered" width="100%">
            <tbody>
              <tr>
                <th>{{trans('label.Product Id')}}</th>
                <th>{{trans('label.Product Name')}}</th>
                <th>{{trans('label.SKU')}}</th>
                <th>{{trans('label.QTY')}}</th>
                <!-- <th width="10%">Cost</th> -->
                <th>{{trans('label.Price')}}</th>
                <th>{{trans('label.VAT')}} %</th>
                <th>{{trans('label.Discount')}} %</th>
                <th>{{trans('label.Total')}} </th>
              </tr>
            </tbody>
 <?php }?>
            <tbody class="details">
<?php
if (isset($sales_details)) {
	foreach ($sales_details as $key => $value) {
		?>
            <tr>
                <td class="text-right"><input type="text" name="product_id[]" readonly="readonly" value="{{$value->product_id}}"></td>
                <td>
                  @foreach($product_profiles as $product)
                    @if($product->id == $value->product_id)

                      <input type="text" name="name" readonly="readonly" value="{{ $product->name}}" >
                    @endif
                  @endforeach

                </td>
                <td class="text-right"><input type="text" name="unique_barcode[]" readonly="readonly" value="{{ $value->unique_barcode}}"></td>
                <td class="text-right"><input type="text" name="qty[]" readonly="readonly" value="{{ $value->qty}}"></td>
                <td class="text-right"><input type="text" name="sales_price[]" readonly="readonly" value="{{ $value->sales_price}}"></td>
                <td class="text-right">
                  <input type="text" name="vat_rate[]" readonly="readonly" value="{{ $value->vat_rate}}">
                </td>
                <td class="text-right">
                  <input type="text" name="discount_rate[]" readonly="readonly" value="{{ $value->discount_rate}}">
                </td>
                <td class="singline_total text-right">
                  <input type="text" name="line_total[]" readonly="readonly" value="{{ $value->line_total}}">
                  <input type="hidden" name="lot_no[]" readonly="readonly" value="{{ $value->lot_no}}">
                  <?php
$discount_line_total = ($value->line_total * $value->discount_rate) / 100;
		$salesAfterDiscount = $value->line_total - $discount_line_total;
		$vat_line_total = ($salesAfterDiscount * $value->vat_rate) / 100;

		?>
                  <input type="hidden" name="discount_line_total[]" readonly="readonly" value="{{ $discount_line_total }}">
                  <input type="hidden" name="vat_line_total[]" readonly="readonly" value="{{ $vat_line_total }}">
                </td>
              </tr>
<?php }}?>
            </tbody>
          </table>

          <table class="table table-bordered" width="100%">
            <tbody>
<?php
if (isset($sales_orders)) {?>
              <tr>
                <th>{{trans('label.Gross Total')}}</th>
                <th>{{trans('label.Discount Amount')}}</th>
                <th>{{trans('label.VAT Amount')}}</th>
                <th>{{trans('label.Net Total')}}</th>
                <th>{{trans('label.Received')}}</th>
                <th>{{trans('label.Due Amount')}}</th>
              </tr>
              <tr>
                <td class="grossTotal_amount">
                  <input type="text" name="gross_amount" readonly="readonly" value="{{ $sales_orders->gross_amount}}">
                </td>
                <td class="totalDiscountAmount"><input type="text" name="gross_discount" readonly="readonly" value="{{$sales_orders->gross_discount  }}"></td>
                <td class="taxTotal"><input type="text" name="gross_vat_amount" readonly="readonly" value="{{ $sales_orders->gross_vat_amount}}"></td>
                <td class="netAmount"><input type="text" name="payment_amount" readonly="readonly" value="{{ $sales_orders->payment_amount}}" ></td>
                <td class="receive_amount_from_custome">
                  <input type="text" name="receive_amount_from_custome"  value="0" id="receivedAmount">
                  <input type="hidden" name="dueFixed_amount"  value="{{$sales_orders->payment_amount -$sales_orders->receive_amount_from_custome }}" class="dueFixed_amount">
                  <td class="due_amount"><input type="text" name="due_amount" value="{{$sales_orders->payment_amount -$sales_orders->receive_amount_from_custome }}" readonly="readonly" class="changeDueAmount"></td>
              </tr>





            </tbody>
          </table>
        </div>
      </div>
      <div class="row">
        <div class="col-md-12">
          <input type="submit" class="btn btn-success" name="preordersale" value="{{trans('label.Sale Confirm')}}" style="width: 100%">
        </div>
      </div>
    </form>
    <?php }?>
    </div>
     </div>
    </section>
  </div>
</div>

@endsection
