@section('title','Sales Order - POS')
@extends('layouts.master')
@section('style')
{{-- {{Html::style('assets/public_css/index.css')}} --}}
<style>
.btn-transparent.active {
    border-color: #6692B0;
    background-color: #6692B0;
    color: #FFF;
}
td form {
    display: inline-block;
}
.right_side_panel {
    background: #999;
    padding: 15px 7px;
    color: #fff;
}
.table thead th {
    border-bottom: 2px solid transparent;
}
.table td, .table th {
    border-top: 1px solid transparent;
}
.product-name {
  font-size: 17px;
  font-weight: bold;
}
.single-product .media {
  position: relative;
}
.single-product .media[aria-expanded='false'] .arrow:before {
  content: "\f105";
  font-family: 'FontAwesome';
  position: absolute;
  left: 0px;
  top: 0px;
  color: #555;
  font-size: 16px;
}
.single-product .media[aria-expanded='true'] .arrow:before {
  content: "\f107";
  font-family: 'FontAwesome';
  position: absolute;
  left: -3px;
  top: 0px;
  color: #555;
  font-size: 16px;
}
#selected_customer {
  padding: 10px;
}
#selected_customer .customer_link {
  font-size: 16px;
  font-weight: bold;
  cursor: pointer;
}
.net_total_input {
  font-size: 22px;
  font-weight: bold;
  text-align: right;
}

/* modal style start */
.info-heading .title {
  border-bottom: 1px solid #ddd;
}
.info-heading .info .lebel {
  color: #6692B0;
}
/* modal style end */

/* salse print start */
.sales-print {
  width: 300px;
  padding: 15px;
}
.sales-print p {
  margin: 0;
}
.print-value {
  float: right;
}
.sales-print a {
  text-decoration: underline !important;
}
.sales-print .bg-primary {
  padding: 9px;
  color: #fff;
}
.subtotal-area .print-label {
    margin-right: 50px;
}
/* salse print end */
.addonadd:before {
  color: #339c6a;
}
.addonadd.user:before {
  content:"\f234" !important;
}
.modal-content {
    border: 1px solid rgba(27, 142, 19, 0.94);
}
.modal-header {
    border-bottom: 1px solid rgba(27, 142, 19, 0.94);
}
.modal-footer {
    border-top: 1px solid rgba(27, 142, 19, 0.94);
}
@media print {
 .page_size1{

  margin: 0;
  box-shadow: 0;
  background: white;
  width: 100%;
  height: 100%;
  /*width: 210mm;
  height: 297mm;*/
  display: block;
  margin: 0 auto;
  padding:0 1cm 0 1cm;
  margin-bottom: 0.5cm;
  box-shadow: 0 0 0.5cm rgba(0,0,0,0.5);
  }
  .page_size2{
  background: white;
  width: 100%;
  height: 100%;
  /* width: 21cm;
  height: 29.7cm; */
  display: block;
  margin: 0 auto;
  margin-bottom: 0.5cm;
  box-shadow: 0 0 0.5cm rgba(0,0,0,0.5);
  }
  .sales-print{
    margin-left: 35%;
    margin-right: 35%;
  }
  .printcenter{

    text-align: center !important;
  }

}
footer.footer-top {
  text-align: right;
  position: fixed;
  bottom: 10px;
  z-index: 999;
  right: 0;
  color: #fff;
}

</style>
@endsection


@section('content')
@include('sales.add_customer')

<div class="page-wrapper">
  <div class="container-fluid">
    <div class="row">
        <div class="col-md-6">
          <button  type="button" class="btn btn-transparent default_btn active" style="margin-right: 5px;"><i class="fa fa-check-circle" aria-hidden="true"></i> {{trans('label.Default')}} <span class="inner-badge transparent-btn">Alt+N</span></button>
          <button type="button" class="btn btn-transparent barcode_btn"><i class="fa fa-barcode"></i> {{trans('label.Barcode')}} <span class="inner-badge transparent-btn">Alt+b</span></button>
        </div>
        <div class="col-md-6">
        <a href="{{ url('sales-invoices')}}" class="btn btn-success pull-right" id="invoice_list">{{trans('label.Invoice List')}}</a>
      </div>

    </div>
    <div class="row">
      <div class="col-md-6">
        <form action="" id="top_form">
          <div class="product-search">
            <div class="form-group product_search">
              <label for=""><strong>{{trans('label.Search for products')}} <span class="text-danger"></span></strong></label>
              <div class="addon">
                <span class="addonadd search"></span>
                <input class="form-control mr-sm-2" type="search" placeholder="{{trans('label.Start typing')}} ....." aria-label="Search" id="product" search_url="{{url('sales-search')}}">
              </div>
            </div>
            <div class="form-group" id="bq_section" style="display: none">
              <label for="bq_id"><strong>{{trans('label.Barcode')}} <span class="text-danger"></span></strong></label>
              <div class="addon">
                <span class="addonadd search"></span>
                <input type="text" name="bq_id" id="bq_id" class="form-control" placeholder="{{trans('label.Scanning With Barcode')}}..." attr_url="{{url('fetch_product_with_barcode')}}">
              </div>
            </div>
            <div class="form-group product_qty_wrapper" style="display: none">
              <label for="product_qty"><strong>{{trans('label.Product Quantiry')}}</strong></label>
              <input class="form-control mr-sm-2 text-right" type="number" id="product_qty"  product_find_url="{{url('product_find')}}" attr_url="{{url('fetch_product')}}">
            </div>
          </div>

          <div class="searching-items">
            <div class="row">
              @forelse($available_items as $avi)
              <div class="col-md-6">
                <div class="product-list">
                  <div class="overlay"></div>
                  <p class="card-text productAddToSearch" >{{$avi->id}} <> {{$avi->name}} <> {{$avi->available}}</p>
                </div>
              </div>
              @empty
              {{trans('label.No available product')}}
              @endforelse
            </div>
          </div>

        </form>
      </div>
      <div class="col-md-6">
        <form action="{{url('sales-process')}}" method="get" class="mt-2" id="main_sales_form">
          {{csrf_field()}}
          <div class="row">
            <div class="col-md-12">
                <div class="" style="text-align: right;">
                  
                  @if(!empty($reprint_no))
                  <button  style="display: none;" type="button" class="btn btn-transparent print_sales_invoice" style="margin-right: 5px;"  href="{{url('sales-invoices',$reprint_no->id)}}"><i class="fa fa-print" aria-hidden="true" ></i> {{trans('label.Reprint Invoice')}} <span class="inner-badge transparent-btn">10</span></button>
                  @endif
                    <button type="button" class="btn btn-transparent" style="margin-right: 5px;" id="park_sales_action" attr_url="{{url('park_sales_process')}}"><i class="fa fa-undo" aria-hidden="true" ></i> {{trans('label.Park Sale')}} <span class="inner-badge transparent-btn">F4</span></button>
                    <button type="button" class="btn btn-transparent" id="discard_all_items" attr_url="{{url('empty_temp_table')}}"><i class="fa fa-trash"></i> {{trans('label.Discard Sale')}} <span class="inner-badge transparent-btn">F7</span></button>
                    <input  type="date" name="transection_date" class="form-control transection_date" required>
                </div>
            </div>
          </div>
          <div class="right-side-wrapper" id='right-side-wrapper'>
            <div class="pd-10">
              <div class="row">
                  <div class="col-md-12">
                    <div class="addon badge-wrapper">
                        <span class="addonadd user"  data-toggle="modal" data-target="#addNewCustomer" title="Add New Customer" style="cursor: pointer; color: green;"></span>
                        <input class="form-control mr-sm-2" type="search" placeholder="Add a customer" aria-label="Search" id="addCustomer" name="addCustomer" attr_url="{{url('customer_for_sales')}}">
                        <span class="inner-badge default right">F9</span>
                    </div>

                    <input type="hidden" id="get_cus_id" name="customer_id" value="12">

                    <div id="selected_customer" style="display: none">
                      <a class="customer_link" {{-- data-toggle="modal" data-target=".customer_info_modal" --}}></a>
                      <button class="btn btn-outline-danger btn-sm unselect_customer pull-right"><i class="fa fa-trash"></i></button>
                    </div>
                  </div>
              </div>
            </div>
            <div class="scrollable product_information" attr_url_iu="{{url('update_inventory')}}">

              <div class="dynamic_append">
                @forelse($sales_temtable as $value)
                <div class='single-product'>
                  <div class='media' data-toggle='collapse' data-target='#product{{$value->order_id}}' aria-expanded='false' aria-controls='collapseExample'>

                      <div class='mr-2 arrow'>

                      </div>
                      <div class='media-body'> <span class='ml-2 mb-1 product-name'><span class='mr-2 view_able_qty'>{{ $value->qty }}</span>{{ $value->name }}</span>
                      </div>
                      <div class='ml-3 gross_price_view'>
                        {{ $value->qty * $value->sales_price }}
                      </div>
                      <div class='ml-3'>
                        <button  class='btn btn-outline-danger btn-sm delete_product'>
                          <i class='fa fa-trash'></i>
                        </button>
                      </div>
                    </div>
                    <div class='collapse' id='product{{$value->order_id}}'>
                      <div class='row'>
                        <div class='col-md-4'>
                          <div class='form-group mrg-0'>
                            <label for='qty' class='mrg-0'>{{trans('label.Qantity')}}</label> <input type='number' step='any' min='0' class='form-control qty text-right' readonly="readonly"  value='{{$value->qty}}' name='qty[]'>
                          </div>
                        </div>
                        <div class='col-md-4'>
                          <div class='form-group mrg-0'>
                            <label for='price {{$value->qty}} ' class='mrg-0'>{{trans('label.Price')}}</label>
                            <input type='number'  step='any' class='form-control sales_price change_sale_price text-right' id='price{{$value->qty}}' value='{{$value->sales_price}}'  name='sales_price[]'>
                          </div>
                        </div>
                        <div class='col-md-4'>
                          <div class='form-group mrg-0'>
                            <label for='discount{{$value->qty}}' class='mrg-0'>{{trans('label.Discount')}} %</label>
                            <input type='number' step='any' class='form-control discount_rate text-right' id='discount{{$value->discount_rate}}' name='discount_rate[]' value='{{$value->discount_rate }}' min="0" autocomplete="off">
                          </div>
                        </div>
                        <div class='col-md-12'>
                          <div class='form-group mrg-0'>
                            <label for='notes' class='mrg-0'>{{trans('label.Notes')}}</label>
                            <textarea class='form-control' id='notes' name='notes[]'></textarea>
                            <input  type='hidden' class='product_id' id='{{$value->product_id}}' value='{{ $value->product_id }}' name='product_id[]'>
                            <input  type='hidden' class='cost_price' id='cost_price{{$value->id}}' value='{{ $value->cost_price }}' name='cost_price[]'>
                            <input  type='hidden' class='vat_rate' id='vat_rate{{$value->id}}' value='{{ $value->vat_rate }}' name='vat_rate[]'>
                            <input  type='hidden' class='cost_price_line_total' id='cost_price_line_total{{$value->id}}' value='{{$value->qty * $value->cost_price}}' name='cost_price_line_total[]'>
                            <input  type='hidden' class='sales_price_line_total' id='sales_price_line_total{{$value->id}}' value='{{$value->qty * $value->sales_price}}' name='sales_price_line_total[]'>
                            <input  type='hidden' class='discount_line_total' id='discount_line_total{{$value->id}}' value='{{ (($value->qty * $value->sales_price) * $value->discount_rate)/100 }}' name='discount_line_total[]'>
                              @php
                              $totalSales = $value->qty * $value->sales_price;
                              $salesAfterDiscount = $totalSales - ($totalSales * $value->discount_rate)/100;
                              $vatAmount = ($salesAfterDiscount * $value->vat_rate)/100;

                              @endphp
                             <input  type='hidden'  class='barcode_id' value='{{$value->barcode}}' name='barcode[]'>
                            <input  type='hidden' id='vat_line_total{{$value->id}}' class='vat_line_total' value='{{$vatAmount}}' name='vat_line_total[]'>
                            <input  type='hidden' class="product_lot_no"  value='{{$value->order_id}}' name='product_lot_no[]'>
                            <input  type='hidden' class='product_name_hidden'  value='{{ $value->name }}' name='product_name[]'>
                          </div>
                        </div>
                      </div>
                    </div>
                </div>
                @empty
                @endforelse

              </div>

              <div class="col-md-12 grand_total_field">
                  <div class="form-group mrg-0 mrg-t-5">
                    <textarea class="form-control" id="common_notes" name="common_notes"></textarea>
                  </div>
                  
                  <div class="form-group row mb-2 mt-2">
                  <label for="commont_discount"  class="col-sm-6 col-form-label">{{trans('label.Common discount')}} <span class="inner-badge default">F8</span></label>
                  <div class="col-sm-6">
                    <div class="badge-wrapper">
                        <input type="number" min="0" step="any" name="commont_discount" class="form-control text-right" id="commont_discount">
                    </div>

                  </div>
                </div>

                  <div class="media">
                    <div class="media-body">
                      <span class="mt-0 mb-1">{{trans('label.Sub-total')}}</span>
                        <input type="hidden" name="gross_total" class="gross_total_input text-right" value="">
                    </div>
                    <div class="ml-3 gross_total"> 0.00</div>
                  </div>
                  <div class="media">
                    <div class="media-body">
                      <span class="mt-0 mb-1">{{trans('label.Discount')}}</span>
                      <input type="hidden" name="discount_total" class="gross_discount_input text-right" value="">
                    </div>
                    <div class="ml-3 gross_discount">0.00</div>
                  </div>
                  <div class="media">
                    <div class="media-body">
                      <span class="mt-0 mb-1">{{trans('label.Vat')}}</span>
                      <input type="hidden" name="vat_total" class="gross_tax_input text-right" value="">
                    </div>
                    <div class="ml-3 gross_tax">0.00</div>
                  </div>

                  <div class="media">
                    <div class="media-body">
                      <span class="mt-0 mb-1"> {{trans('label.Net Total')}} (<small><span class="total_quantity text-right">0</span> > {{trans('label.items')}}</small>)</span>
                      <input type="hidden" name="net_total" class="net_total_input" value="">

                    </div>
                    <div class="ml-3 net_total text-right">0.00</div>
                  </div>
              </div>
            </div>
              <div class="sales-footer" id="amount_section">
                <div class="form-group row mb-2 mt-2">
                  <label for="received_amount"  class="col-sm-6 col-form-label">{{trans('label.Pay amount')}} <span class="inner-badge default">F8</span></label>
                  <div class="col-sm-6">
                    <div class="badge-wrapper">
                      <input type="text" autocomplete="off" class="form-control text-right form-control-sm received_amount text-right" step="any" min="0" name="receive_amount_from_custome" value="0">
                      <span class="inner-badge default left" style="padding: 2px 5px;">Alt+a</span>
                    </div>

                  </div>
                </div>
                <div class="form-group row mb-1" id="due_amount_section">
                  <label for="due_amount" class="col-sm-6 col-form-label" min='0'>{{trans('label.Due amount')}}</label>
                  <div class="col-sm-6">
                    <input type="text" class="form-control form-control-sm due_amount text-right" id="due_amount" value="0.00" step="any" min="0" name="due_amount" readonly="readonly">
                  </div>
                </div>
                <div class="form-group row mb-1" id="return_amount_section" style="display: none;">
                  <label for="return_amount" class="col-sm-6 col-form-label">{{trans('label.Return amount')}}</label>
                  <div class="col-sm-6">
                    <input type="text" class="form-control text-right form-control-sm text-right" id="return_amount" value="0.00" step="any" min="0" name="return_amount" readonly="readonly">
                  </div>
                </div>
              </div>
              <div class="sales-footer" id="pay_area">
                <button type="button" class="btn btn-success mrg-t-10 mrg-b-10 submit_sale"  style="width: 100%">
                  <div class="pay-amount">

                    <div class="ml-3"><span class="pull-left" style="margin-top: 5px">{{trans('label.Submit')}} <span class="inner-badge">F2</span></span><span class="net_total_input pull-right">0.00</span> </div>
                  </div>
                </button>
              </div>
          </div>
        </form>
      </div>
    </div>
    {{-- reprint --}}
    <div class="text-center">
    <div class="reprint printcenter" style="display: block;">

    </div>
    {{-- reprint --}}
    </div>
    <div style="display: none;">

      <div id='print_page' class="page_size{{$shopinfo->invoice_layout}} text-center printcenter">
        <div class="row" >
          <div class="col-md-12">
            <div class="sales-print">
            <div class="text-center">
              @if($shopinfo->shop_name!=null)<h4>{{$shopinfo->shop_name}}</h4>
              <p>{{$shopinfo->shop_address}}</p>
              <p>{{$shopinfo->shop_email}} , {{$shopinfo->shop_phone}}</p>
              @else
              <h4>Leftjoin</h4>
              <p>Mirpur ,Dhaka</p>
              <p>leftjoin@gmail.com , 01738088325</p>
              @endif
              <p>Sales Invoice</p>
            </div>
              <p><span>Prepared by:</span>{{Auth::user()->name}}<span class="print-value"></span></p>
              <p><span>Prepared date:</span>{{now()}}<span class="print-value"></span></p>
              <p><span>order Id:</span><span id='Print_order_id'></span></span><span class="print-value"></span></p>
              <a>Items & Description</a>
              <div id='dynamic_print'>

              </div>
              <hr>
              <div class="subtotal-area mb-2">
                <p><span class="print-label">Subtotal</span> <span class="print-value net_print_subtotal"></span></p>
                <p><span class="print-label">Discount</span> <span></span> <span class="print-value net_print_distotal"></span></p>
                <p><span class="print-label">Tax</span> <span></span> <span class="print-value net_print_taxtotal"></span></p>
                <p></p>
              </div>
              <h3 class="total">Total: <span class='net_print_total'>()</span></h3>
              <p><span class="print-label"></span> <span>Cash Received</span> <span class="print-value received_print_total"></span></p>
              <p id='due_section'><span class="print-label"></span> <span>Due Amount</span> <span class="print-value due_print_total"></span></p>
              <p id='return_section'><span class="print-label"></span> <span>Return  Amount</span> <span class="print-value return_print_total"></span></p>
              <hr>
              <p>Signature: .............................................</p>
            </div>
          </div>
        </div>
        </div>
      </div>
    </div>
</div>

<!-- Customer info modal start -->
<!-- <div class="modal fade customer_info_modal" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <div class="text-center">
          <h3 class="modal-title" id="">Macrosoft</h3>
          <small><a href="" style="color: #6692B0;">All Customers</a></small> -
          <small style="color: #6692B0;">Last shopped 15 days ago</small>
          <div class="small-divider"></div>
        </div>
        <div class="info-heading">
          <div class="title"><h5 class="mb-2"><strong>Customer info</strong></h5></div>
          <div class="info mt-2">
            <div class="row">
              <div class="col-md-4">
                <div class="lebel">Customer code</div>
              </div>
              <div class="col-md-8">
                1207798
              </div>
              <div class="col-md-4">
                <div class="lebel">Sex</div>
              </div>
              <div class="col-md-8">
                Male
              </div>
              <div class="col-md-4">
                <div class="lebel">Date of birth</div>
              </div>
              <div class="col-md-8">
                11-06-2018
              </div>

            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div> -->
<!-- Customer info modal end -->

<!-- ============================================================== -->
<!-- footer -->
<!-- ============================================================== -->
<footer class="footer-top">
  <div class="container-fluid pb-0">
    <span>Re-print <span class="inner-badge">F10</span></span>
  </div>
</footer>
<!-- ============================================================== -->
<!-- End footer -->
<!-- ============================================================== -->
@endsection


@section('script')

<!--stickey kit -->
{{Html::script('assets/js/sticky-kit.min.js')}}
{{Html::script('assets/js/jquery.sparkline.min.js')}}
<!-- This is data table -->
{{Html::script('assets/js/jquery.dataTables.min.js')}}
<!-- start - This is for export functionality only -->
{{Html::script('assets/js/dataTables.buttons.min.js')}}
{{Html::script('assets/js/buttons.flash.min.js')}}
{{Html::script('assets/js/jszip.min.js')}}
{{Html::script('assets/js/pdfmake.min.js')}}
{{Html::script('assets/js/vfs_fonts.js')}}
{{Html::script('assets/js/buttons.html5.min.js')}}
{{Html::script('assets/custom_js/crud.js')}}

<link rel="stylesheet" href="//code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">


<script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
{{Html::script('assets/custom_js/print.js')}}

{{Html::script('assets/custom_js/sales.js')}}
{{Html::script('assets/custom_js/add_more.js')}}

<!-- end - This is for export functionality only -->
{{-- {{Html::script('assets/public_js/index.js')}} --}}


<script>
  $('#bq_id').on('keydown', function(event) {
    if(event.which == 17 || event.which == 74 )
      event.preventDefault();
     //setTimeout(function(){ $('#bq_id').unbind() }, 100);
  });
</script>

@endsection