@section('title','Sales Invoice report')
@extends('layouts.master')
@section('style')
{{-- {{Html::style('assets/public_css/index.css')}} --}}
<style>
td form {
    display: inline-block;
}
/* .page-wrapper {
     padding-top: 40px !important;
} */
tr input {
    display: none;
}
tr.input_show input {
    display: block;
}
tr.input_show span, tr.input_show .pay {
    display: none;
}
tr.input_show input.submit {
    display: inline-block !important;
}
</style>
@endsection


@section('content')
<div class="page-wrapper">
    <div class="container-fluid">
        <div class="row page-titles">
          <div class="col-md-12">
            <h5>{{trans('label.Due Sales Invoice')}}</h5>
          </div>
        </div>
        <div class="row page-titles">
            <div class="col-md-4 text-center">
                <h3>{{trans('label.Total Sales')}}</h3>
                <?php $totalSales = 0;
if (isset($info)) {
	foreach ($info as $invoice) {
		$totalSales += $invoice->payment_amount;
	}
}

?>
                <h4><?php echo number_format($totalSales, 2); ?></h4>
            </div>
            <div class="col-md-4 text-center">
                <h3>{{trans('label.Total Received')}}</h3>
                <?php $receive_amount_from_custome = 0;
if (isset($info)) {
	foreach ($info as $invoice) {
		$receive_amount_from_custome += $invoice->receive_amount_from_custome;
	}
}

?>
                <h4><?php echo number_format($receive_amount_from_custome, 2); ?></h4>
            </div>
             <div class="col-md-4 text-center">
                <h3>{{trans('label.Total Due Amount')}}</h3>
                <?php $due_amount = 0;
if (isset($info)) {
	foreach ($info as $invoice) {
		$due_amount += $invoice->payment_amount - $invoice->receive_amount_from_custome;
	}
}

?>
                <h4><?php echo number_format($due_amount, 2); ?></h4>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card-body-wrapper">
                    <div id='table_position'>
                    <div class="table-responsive">
                        <table id="example23" class="display nowrap table table-hover table-striped table-bordered" cellspacing="0" width="100%">
                            <thead>
                                <tr>
                                    <th>{{trans('label.SL')}}</th>
                                    <th>{{trans('label.Order Id')}}</th>
                                    <th>{{trans('label.Gross Amount')}}</th>
                                    <th>{{trans('label.Payment Amount')}}</th>
                                    <th>{{trans('label.Due Amount')}}</th>
                                    <th>{{trans('label.Action')}}</th>
                                </tr>
                            </thead>

                            <tbody>

                                @forelse($info as $invoice)

                                <tr>
                                    <td class="text-right">
                                        <span>{{$loop->iteration}}</span>
                                        <input type="text" value="{{$loop->iteration}}" disabled="">
                                    </td>
                                    <td class="text-right">
                                        <span>{{$invoice->id}}</span>
                                        <input type="number" name="invoice_id" value="{{$invoice->id}}" disabled="">
                                    </td>
                                    <td class="text-right">
                                        <span>{{number_format(($invoice->payment_amount ?? 0),2)}}</span>
                                        <input type="number" name="payment_amount" value="{{$invoice->payment_amount ?? 0}}" disabled="">
                                    </td>
                                    <td class="text-right">
                                        <span>{{number_format(($invoice->receive_amount_from_custome ?? 0),2)}}</span>
                                        <input type="number" name="payment_amount" value="{{$invoice->receive_amount_from_custome ?? 0}}" disabled="">
                                    </td>
                                    <td class="text-right">
                                        <span>{{number_format(($invoice->due_amount ?? 0),2)}}</span>
                                        <input type="text" name="due_amount" value="{{$invoice->due_amount ?? 0}}">
                                    </td>
                                    <td>
                                        <!-- <a href="" class="pay">{{trans('label.Pay')}}</a>
                                        <input type="button" class="btn btn-success btn-sm submit" value="Receive" style="display: none">
                                        | -->
                                        <a href="{{url('sales-invoices',$invoice->id)}}">{{trans('label.view')}}</a>
                                    </td>
                                </tr>

                                @empty
                                @endforelse



                            </tbody>
                        </table>
                    </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>
@endsection
@section('script')

<!--stickey kit -->
{{Html::script('assets/js/sticky-kit.min.js')}}
{{Html::script('assets/js/jquery.sparkline.min.js')}}
<!-- This is data table -->
{{Html::script('assets/js/jquery.dataTables.min.js')}}
<!-- start - This is for export functionality only -->
{{Html::script('assets/js/dataTables.buttons.min.js')}}
{{Html::script('assets/js/buttons.flash.min.js')}}
{{Html::script('assets/js/jszip.min.js')}}
{{Html::script('assets/js/pdfmake.min.js')}}
{{Html::script('assets/js/vfs_fonts.js')}}
{{Html::script('assets/js/buttons.html5.min.js')}}
{{Html::script('assets/js/buttons.print.min.js')}}
{{Html::script('assets/custom_js/crud.js')}}
{{Html::script('assets/custom_js/datatable.js')}}

<!-- end - This is for export functionality only -->
{{-- {{Html::script('assets/public_js/index.js')}} --}}
<script>
    $(document).ready(function(){
        $('.pay').click(function(e){
            e.preventDefault();
            $(this).parents('tr').addClass('input_show');
        });
        $('.submit').click(function(){
            $(this).parents('tr').removeClass('input_show');
        });
    });
</script>

@endsection