@section('title','Reorder invoice')
@extends('layouts.master')
@section('style')
{{-- {{Html::style('assets/public_css/index.css')}} --}}
<style>
td form {
    display: inline-block;
}
</style>
@endsection


@section('content')
<div class="page-wrapper">

    <div class="container-fluid">
        <div class="row page-titles">
          <div class="col-md-12">
            <h5>{{trans('label.Sales Preorder Invoice')}}</h5>
            @if (Session::has('message'))
      <h6 style="background: #20c997; color: #fff; text-align: center; padding: 5px; border-radius: 5px;">{{ Session::get('message') }}</h6>
      @endif
        </div>
    </div>
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div id='table_position'>
                    <div class="table-responsive">
                        <table id="example23" class="display nowrap table table-hover table-striped table-bordered" cellspacing="0" width="100%">
                            <thead>
                                <tr>
                                    <th>{{trans('label.SL')}}</th>
                                    <th>{{trans('label.Order No')}}</th>
                                    <th>{{trans('label.Customer Name')}}</th>
                                    <th>{{trans('label.Order Date')}}</th>
                                    <th>{{trans('label.Total Amount')}}</th>
                                    <th>{{trans('label.Discount')}}</th>
                                    <th>{{trans('label.Vat')}}</th>
                                    <th>{{trans('label.Created By')}}</th>
                                    <th>{{trans('label.Action')}}</th>
                                </tr>
                            </thead>

                            <tbody>
                              @if(isset($info))
                              @foreach($info as $park_invoice)
                              <tr>
                                <td>{{ $park_invoice->id }}</td>
                                <td>{{ $park_invoice->order_date }}</td>
                                <td>
                                    @if(isset($customer_profiles))
                                    @foreach($customer_profiles as $customer)

                                    @if($customer->id == $park_invoice->customer_Id)
                                    {{ $customer->id  }} -
                                    {{   $customer->name }}
                                    @endif
                                    @endforeach
                                    @endif
                                </td>
                                <td>{{ $park_invoice->order_date }}</td>
                                <td>{{ number_format($park_invoice->gross_amount,2)}}</td>
                                <td>{{ number_format($park_invoice->gross_discount ,2)}}</td>
                                <td>{{ number_format($park_invoice->gross_vat_amount,2) }}</td>
                                <td>
                                    @if(isset($user))
                                    @foreach($user as $users)

                                    @if($users->id == $park_invoice->employee_id)
                                    {{   $users->name }}
                                    @endif
                                    @endforeach
                                    @endif
                                </td>
                                <td>
                                    <a  class="btn btn-sm " href="{{url('preorder-details',$park_invoice->id) }}">{{trans('label.Process')}}</a>|
                                    <a href="{{url('delete-park-sales',$park_invoice->id) }}" class="btn btn-sm danger" onclick="return confirm('Are you sure you want to delete this item?');">{{trans('label.Delete')}}</a>
                                </td>
                            </tr>
                            @endforeach
                            @endif

                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

</div>

</div>

@endsection


@section('script')

<!--stickey kit -->
{{Html::script('assets/js/sticky-kit.min.js')}}
{{Html::script('assets/js/jquery.sparkline.min.js')}}
<!-- This is data table -->
{{Html::script('assets/js/jquery.dataTables.min.js')}}
<!-- start - This is for export functionality only -->
{{Html::script('assets/js/dataTables.buttons.min.js')}}
{{Html::script('assets/js/buttons.flash.min.js')}}
{{Html::script('assets/js/jszip.min.js')}}
{{Html::script('assets/js/pdfmake.min.js')}}
{{Html::script('assets/js/vfs_fonts.js')}}
{{Html::script('assets/js/buttons.html5.min.js')}}
{{Html::script('assets/js/buttons.print.min.js')}}
{{Html::script('assets/custom_js/crud.js')}}
{{Html::script('assets/custom_js/datatable.js')}}

<!-- end - This is for export functionality only -->
{{-- {{Html::script('assets/public_js/index.js')}} --}}
<script>
</script>

@endsection