@section('title','Role - POS')
@extends('layouts.master')
@section('style')
{{-- {{Html::style('assets/public_css/index.css')}} --}}
<style>
td form {
display: inline-block;
}
input[type="radio"][disabled], input[type="checkbox"][disabled], .radio[disabled], .radio-inline[disabled], .checkbox[disabled], .checkbox-inline[disabled], fieldset[disabled] input[type="radio"], fieldset[disabled] input[type="checkbox"], fieldset[disabled] .radio, fieldset[disabled] .radio-inline, fieldset[disabled] .checkbox, fieldset[disabled] .checkbox-inline {
cursor: not-allowed;
}
</style>
@endsection


@section('content')

<div class="page-wrapper">

<div class="container-fluid">
  <div class="row page-titles">
      <div class="col-md-12 align-self-center">
          <h4 class="text-themecolor title"><span id="heading_field"></span>{{trans('label.Update Role')}}</h4>
      </div>
  </div>
@if(!empty($info))
@php
$module_array=[];
$json_data=(json_decode($info->permissions));
foreach ($json_data as $key => $value) {
  array_push($module_array, $key);
}
@endphp
  <div class="row">
      <div class="col-12">
          <div class="card">
              <div class="card-body">
                  <div class="">
                      <form  method="post" action="{{url('role',$info->id)}}">
                      {{csrf_field()}}
                      <input type="hidden" name="_method" value="PUT">
                      <input type="hidden" name="id" value="{{$info->id}}">
                          <div class="form-group row">
                              <label for="role" class="col-sm-2 col-form-label" style="font-weight: bold;">{{trans('label.Role')}}</label>
                              <div class="col-sm-10">
                                  <div class="form-group">
                                      <input type="text" class="form-control" name="name" id="role" value='{{$info->name}}' required="required">
                                  </div>
                              </div>
                          </div>
                          <div class="form-group row">
                              <div class="col-sm-2">
                                  <label for="role" class="col-form-label" style="font-weight: bold;">{{trans('label.Permission')}}</label>
                              </div>
                              <div class="col-sm-10">
                                  <div class="table-responsive">
                                      <table class="table table-sm table-bordered table-striped">
                                        <thead>
                                          <tr>
                                            <th scope="col">#</th>
                                            <th scope="col">{{trans('label.Module Name')}}</th>
                                            <th scope="col">{{trans('label.Add')}}</th>
                                            <th scope="col">{{trans('label.Edit')}}</th>
                                            <th scope="col">{{trans('label.Delete')}}</th>
                                            <th scope="col">{{trans('label.View')}}</th>
                                          </tr>
                                        </thead>
                                        <tbody>
                                          @forelse($module as $mod)
                                          <tr>
                                            <th scope="row">
                                              <div class="form-check">
                                                <input class="form-check-input checkall" type="checkbox" name="permissions[]"" value="{{$mod}}_menu" id="module_name_{{$loop->iteration}}" @if(in_array($mod.'_menu', $module_array)) checked="checked" @endif>
                                                <label class="form-check-label" for="module_name_{{$loop->iteration}}"></label>
                                              </div>
                                            </th>
                                            <td>{{$mod}}</td>
                                            <td>
                                                <div class="form-check">
                                                  <input class="form-check-input other_checkbox" type="checkbox" name="permissions[]" value="{{$mod}}_add" id="add_{{$loop->iteration}}" @if(in_array($mod."_add", $module_array)) checked="checked" @endif>
                                                  <label class="form-check-label" for="add_{{$loop->iteration}}"></label>
                                                </div>
                                            </td>
                                            <td>
                                                <div class="form-check">
                                                  <input class="form-check-input other_checkbox" type="checkbox" name="permissions[]" value="{{$mod}}_edit" id="edit_{{$loop->iteration}}" @if(in_array($mod."_edit", $module_array)) checked="checked" @endif>
                                                  <label class="form-check-label" for="edit_{{$loop->iteration}}"></label>
                                                </div>
                                            </td>
                                            <td>
                                                <div class="form-check">
                                                  <input class="form-check-input other_checkbox" name="permissions[]" type="checkbox" value="{{$mod}}_delete" id="delete_{{$loop->iteration}}" @if(in_array($mod."_delete", $module_array)) checked="checked" @endif>
                                                  <label class="form-check-label" for="delete_{{$loop->iteration}}"></label>
                                                </div>
                                            </td>
                                            <td>
                                                <div class="form-check">
                                                  <input class="form-check-input other_checkbox" name="permissions[]" type="checkbox" value="{{$mod}}_view" id="view_{{$loop->iteration}}" @if(in_array($mod."_view", $module_array)) checked="checked" @endif>
                                                  <label class="form-check-label" for="view_{{$loop->iteration}}"></label>
                                                </div>
                                            </td>
                                          </tr>
                                          @empty
                                          @endforelse
                                        </tbody>
                                      </table>
                                  </div>
                              </div>
                          </div>
                          <div class="row">
                              <div class="col-sm-12" style="text-align: right;">
                                  <button type="submit" class="btn btn-success" style="width: 150px;">{{trans('label.Update')}}</button>
                              </div>
                          </div>
                      </form>
                  </div>
              </div>
          </div>
      </div>
  </div>
  @endif

</div>
</div>

@endsection


@section('script')

<!--stickey kit -->
{{Html::script('assets/js/sticky-kit.min.js')}}
{{Html::script('assets/js/jquery.sparkline.min.js')}}
<!-- This is data table -->
{{Html::script('assets/js/jquery.dataTables.min.js')}}
<!-- start - This is for export functionality only -->
{{Html::script('assets/js/dataTables.buttons.min.js')}}
{{Html::script('assets/js/buttons.flash.min.js')}}
{{Html::script('assets/js/jszip.min.js')}}
{{Html::script('assets/js/pdfmake.min.js')}}
{{Html::script('assets/js/vfs_fonts.js')}}
{{Html::script('assets/js/buttons.html5.min.js')}}
{{Html::script('assets/js/buttons.print.min.js')}}
{{Html::script('assets/custom_js/crud.js')}}
{{Html::script('assets/custom_js/datatable.js')}}

<!-- end - This is for export functionality only -->
{{-- {{Html::script('assets/public_js/index.js')}} --}}
<script>
$(document).ready(function(){
  if($('.checkall').is(':checked')){
      $(".other_checkbox").each(function(){
        $(this).removeAttr("disabled");
      });
  }else{
      $(".other_checkbox").each(function(){
        $(this).attr("disabled", true);
      });
  }
 // Check or Uncheck All checkboxes
 $(".checkall").change(function(){
   var checked = $(this).is(':checked');
   if(checked){
     $(this).parents('tr').find(".other_checkbox").each(function(){
       $(this).prop("checked",true);
       $(this).removeAttr("disabled");
     });
   }else{
     $(this).parents('tr').find(".other_checkbox").each(function(){
       $(this).prop("checked",false);
       $(this).attr("disabled", true);
     });
   }
 });
});
</script>

@endsection