@section('title','Reorder')
@extends('layouts.master')
@section('style')
{{-- {{Html::style('assets/public_css/index.css')}} --}}
<style>
td form {
    display: inline-block;
}
</style>
@endsection


@section('content')
<div class="page-wrapper">

    <div class="container-fluid">
        <div class="row page-titles">
            <h3 class="text-center">{{trans('label.Set re-order label and target label')}}</h3>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card-body">
                    <div class="container shadow" style="background: #ffffff; padding: 20px;">
                        <form action="{{url('reorder/update',$findProducts->product_id)}}" method="post" >
                      {{csrf_field()}}
                      @if($errors->any())
                      <h4 class="alert alert-warning" >{{$errors->first()}}</h4>
                      @endif

                      <div class="form-group row mt-3">
                        <label for="product_id" class="col-sm-2 col-form-label">{{trans('label.Product Id')}}</label>
                        <div class="col-sm-10">
                          <input type="text" name="product_id" id="product_id" class="form-control" value="{{ $findProducts->product_id}}" readonly="readonly">

                        </div>
                      </div>
                      <div class="form-group row">
                        <label for="name" class="col-sm-2 col-form-label">{{trans('label.Product Name')}} </label>
                        <div class="col-sm-10">
                          <input type="text" name="name" id="name" class="form-control" value="{{$findProducts->name}}" readonly="readonly" >
                        </div>
                      </div>
                      <div class="form-group row">
                        <label for="reorder_label" class="col-sm-2 col-form-label">{{trans('label.Re order Lavel')}}</label>
                        <div class="col-sm-10">
                          <input type="text" name="reorder_label" id="reorder_label" class="form-control" value="{{$findProducts->reorder_label}}" >
                        </div>
                      </div>

                      <div class="form-group row">
                        <label for="target_label" class="col-sm-2 col-form-label">{{trans('label.Target Lavel')}}</label>
                        <div class="col-sm-10">
                          <input type="text" name="target_label" id="target_label" class="form-control" placeholder="target label" required="required" value="{{$findProducts->target_label}}">
                        </div>
                      </div>
                      <div class="form-group row">
                        <label for="min_reorder_qty" class="col-sm-2 col-form-label">{{trans('label.Re order Qty')}}</label>
                        <div class="col-sm-10">
                          <input type="text" name="min_reorder_qty" id="min_reorder_qty" class="form-control" value="{{$findProducts->min_reorder_qty}}"  required="required" placeholder="{{trans('label.Re Order Qty')}}">
                        </div>
                      </div>
                      <div class="row">
                        <div class="col-md-12">
                          <div class="pull-right">
                            <input type="submit" class="btn btn-success" value="{{trans('label.Update')}}" >
                          </div>
                        </div>
                      </div>
                    </form>
                    </div>

                </div>
            </div>
        </div>

    </div>

</div>

@endsection


@section('script')

<!--stickey kit -->
{{Html::script('assets/js/sticky-kit.min.js')}}
{{Html::script('assets/js/jquery.sparkline.min.js')}}
<!-- This is data table -->
{{Html::script('assets/js/jquery.dataTables.min.js')}}
<!-- start - This is for export functionality only -->
{{Html::script('assets/js/dataTables.buttons.min.js')}}
{{Html::script('assets/js/buttons.flash.min.js')}}
{{Html::script('assets/js/jszip.min.js')}}
{{Html::script('assets/js/pdfmake.min.js')}}
{{Html::script('assets/js/vfs_fonts.js')}}
{{Html::script('assets/js/buttons.html5.min.js')}}
{{Html::script('assets/js/buttons.print.min.js')}}
{{Html::script('assets/custom_js/crud.js')}}
{{Html::script('assets/custom_js/datatable.js')}}

<!-- end - This is for export functionality only -->
{{-- {{Html::script('assets/public_js/index.js')}} --}}
<script>
</script>

@endsection