@section('title','Report - POS')
@extends('layouts.master')
@section('style')
{{Html::style('assets/css/index.css')}}
<style>
.page-wrapper {
  margin-left: 90px !important;
}
/* bootstrap custom nav-tabs start */
.nav-tabs-wrapper {
  background: #fff;
  margin-right: 10px;
  min-height: 70vh;
  -webkit-box-shadow: 0 1px 15px 0px #999;
  -moz-box-shadow: 0 1px 15px 0px #999;
  box-shadow: 0 1px 15px 0px #999;
}
.nav-tabs {
  border-bottom: 0;
}
.nav-tabs .nav-item {
  width: 20%;
  border-right: 2px solid #ddd;
  text-align: center;
  list-style: none;
}
.nav-tabs .nav-item:last-child{
  border-right: 0;
}
.nav-tabs .nav-link {
  color: #555;
  border-bottom: 5px solid #ddd;
  transition: all .5s;
}
.nav-tabs .nav-link:focus, .nav-tabs .nav-link:hover {
  border-bottom: 5px solid #339c6a;
  color: #339c6a;
}
.nav-tabs .nav-item.show .nav-link, .nav-tabs .nav-link.active {
  border-bottom: 5px solid #339c6a;
  color: #339c6a;
}
@media only screen and (max-width: 600px) {
  .nav-tabs .nav-item {
    width: 33%;
  }
}
@media only screen and (max-width: 380px) {
  .nav-tabs .nav-item {
    width: 100%;
  }
}
/* bootstrap custom nav-tabs end */
</style>
@endsection


@section('content')

<div class="page-wrapper">
  <div class="row page-titles">
    <div class="col-md-5 align-self-center">
      <h4 class="text-themecolor title"><span id="heading_field"></span> {{trans('label.Report')}}</h4>
    </div>
  </div>
<div class="row">
  <div class="col-md-12">
    <div class="nav-tabs-wrapper shadow">
      <ul class="nav nav-tabs" id="myTab" role="tablist">
        <li class="nav-item">
          <a class="nav-link active" id="cash-tab" data-toggle="tab" href="#cash" role="tab" aria-controls="cash" aria-selected="true">{{trans('label.Cash')}}</a>
        </li>
        <li class="nav-item">
          <a class="nav-link" id="credit-tab" data-toggle="tab" href="#credit" role="tab" aria-controls="credit" aria-selected="false">{{trans('label.Credit')}}</a>
        </li>
        <li class="nav-item">
          <a class="nav-link" id="purchase-tab" data-toggle="tab" href="#purchase" role="tab" aria-controls="purchase" aria-selected="false">{{trans('label.Purchase')}}</a>
        </li>
        <li class="nav-item">
          <a class="nav-link" id="sales-tab" data-toggle="tab" href="#sales" role="tab" aria-controls="sales" aria-selected="false">{{trans('label.Sales')}}</a>
        </li>
        <li class="nav-item">
          <a class="nav-link" id="inventory-tab" data-toggle="tab" href="#inventory" role="tab" aria-controls="inventory" aria-selected="false">{{trans('label.Inventory')}}</a>
        </li>
      </ul>
      <div class="tab-content p-3" id="myTabContent">
        <div class="tab-pane fade show active" id="cash" role="tabpanel" aria-labelledby="cash-tab">
          <div class="row">

            <div class="col-sm-3">
              <div class="box-wrapper">
                <div class="boxes">
                  <a href="{{url('cash-report')}}">
                    <img src="{{ asset('assets/images/icons/cash.png') }}" alt="inventory">
                    <span>@lang('label.cash_report')</span>
                  </a>
                </div>
              </div>
            </div>
            <div class="col-sm-3">
              <div class="box-wrapper">
                <div class="boxes">
                  <a href="#">
                    <img src="{{ asset('assets/images/icons/debit.png') }}" alt="inventory">
                    <span>{{trans('label.User wise Cash DR')}}</span>
                  </a>
                </div>
              </div>
            </div>
            <div class="col-sm-3">
              <div class="box-wrapper">
                <div class="boxes">
                  <a href="#">
                    <img src="{{ asset('assets/images/icons/credit.png') }}" alt="inventory">
                    <span>{{trans('label.User wise Cash CR')}}</span>
                  </a>
                </div>
              </div>
            </div>

          </div>
        </div>
        <div class="tab-pane fade" id="credit" role="tabpanel" aria-labelledby="credit-tab">
          <div class="row">
            <div class="col-sm-3">
              <div class="box-wrapper">
                <div class="boxes">
                  <a href="{{url('credit-sales')}}">
                    <img src="{{ asset('assets/images/icons/inventory.png') }}" alt="inventory">
                    <span>{{trans('label.Credit sales')}}</span>
                  </a>
                </div>
              </div>
            </div>
            <div class="col-sm-3">
              <div class="box-wrapper">
                <div class="boxes">
                  <a href="{{url('credit-invoice')}}">
                    <img src="{{ asset('assets/images/icons/inventory.png') }}" alt="inventory">
                    <span>{{trans('label.Credit Invoice (sales)')}}</span>
                  </a>
                </div>
              </div>
            </div>
            <div class="col-sm-3">
              <div class="box-wrapper">
                <div class="boxes">
                  <a href="{{url('credit-purchase')}}">
                    <img src="{{ asset('assets/images/icons/inventory.png') }}" alt="inventory">
                    <span>{{trans('label.Credit Purchase')}}</span>
                  </a>
                </div>
              </div>
            </div>
            <div class="col-sm-3">
              <div class="box-wrapper">
                <div class="boxes">
                  <a href="{{url('credit-purchase-invoice')}}">
                    <img src="{{ asset('assets/images/icons/inventory.png') }}" alt="inventory">
                    <span>{{trans('label.Credit Invoice (Purchase)')}}</span>
                  </a>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="tab-pane fade" id="purchase" role="tabpanel" aria-labelledby="purchase-tab">
          <div class="row">

            <div class="col-sm-3">
              <div class="box-wrapper">
                <div class="boxes">
                  <a href="{{url('purchase-invoice')}}">
                    <img src="{{ asset('assets/images/icons/inventory.png') }}" alt="inventory">
                    <span>{{trans('label.Purchase')}}</span>
                  </a>
                </div>
              </div>
            </div>
            <div class="col-sm-3">
              <div class="box-wrapper">
                <div class="boxes">
                  <a href="{{url('cash-purchase')}}">
                    <img src="{{ asset('assets/images/icons/inventory.png') }}" alt="inventory">
                    <span>{{trans('label.Cash Purchase')}}</span>
                  </a>
                </div>
              </div>
            </div>
            <div class="col-sm-3">
              <div class="box-wrapper">
                <div class="boxes">
                  <a href="{{url('user-purchase')}}">
                    <img src="{{ asset('assets/images/icons/inventory.png') }}" alt="inventory">
                    <span>{{trans('label.User wise Purchase')}}</span>
                  </a>
                </div>
              </div>
            </div>

          </div>
        </div>

        <div class="tab-pane fade" id="sales" role="tabpanel" aria-labelledby="sales-tab">
          <div class="row">

            <div class="col-sm-3">
              <div class="box-wrapper">
                <div class="boxes">
                  <a href="{{url('sales-invoices')}}">
                    <img src="{{ asset('assets/images/icons/inventory.png') }}" alt="inventory">
                    <span>{{trans('label.Sales')}}</span>
                  </a>
                </div>
              </div>
            </div>
            <div class="col-sm-3">
              <div class="box-wrapper">
                <div class="boxes">
                  <a href="{{url('cash-sales')}}">
                    <img src="{{ asset('assets/images/icons/inventory.png') }}" alt="inventory">
                    <span>{{trans('label.Cash sales')}}</span>
                  </a>
                </div>
              </div>
            </div>
            <div class="col-sm-3">
              <div class="box-wrapper">
                <div class="boxes">
                  <a href="{{url('user-sales')}}">
                    <img src="{{ asset('assets/images/icons/inventory.png') }}" alt="inventory">
                    <span>{{trans('label.User wise Sales')}}</span>
                  </a>
                </div>
              </div>
            </div>

          </div>
        </div>
        <div class="tab-pane fade" id="inventory" role="tabpanel" aria-labelledby="inventory-tab">
          <div class="row">
            <div class="col-sm-3">
              <div class="box-wrapper">
                <div class="boxes">
                  <a href="{{url('all-item-report')}}">
                    <img src="{{ asset('assets/images/icons/inventory.png') }}" alt="inventory">
                    <span>{{trans('label.Inventory')}}</span>
                  </a>
                </div>
              </div>
            </div>
            <div class="col-sm-3">
              <div class="box-wrapper">
                <div class="boxes">
                  <a href="{{url('available-item')}}">
                    <img src="{{ asset('assets/images/icons/inventory.png') }}" alt="inventory">
                    <span>{{trans('label.Available Items')}}</span>
                  </a>
                </div>
              </div>
            </div>
            <div class="col-sm-3">
              <div class="box-wrapper">
                <div class="boxes">
                  <a href="{{url('reorder')}}">
                    <img src="{{ asset('assets/images/icons/inventory.png') }}" alt="inventory">
                    <span>{{trans('label.Reorder Level')}}</span>
                  </a>
                </div>
              </div>
            </div>
            <div class="col-sm-3">
              <div class="box-wrapper">
                <div class="boxes">
                  <a href="{{url('srinkage-item')}}">
                    <img src="{{ asset('assets/images/icons/inventory.png') }}" alt="inventory">
                    <span>{{trans('label.Srinkage Items')}}</span>
                  </a>
                </div>
              </div>
            </div>

            <div class="col-sm-3">
              <div class="box-wrapper">
                <div class="boxes">
                  <a href="{{url('profit')}}">
                    <img src="{{ asset('assets/images/icons/inventory.png') }}" alt="inventory">
                    <span>{{trans('label.Profit')}}</span>
                  </a>
                </div>
              </div>
            </div>
            <div class="col-sm-3">
              <div class="box-wrapper">
                <div class="boxes">
                  <a href="{{url('customer-report')}}">
                    <img src="{{ asset('assets/images/icons/inventory.png') }}" alt="inventory">
                    <span>{{trans('label.Customer Report')}}</span>
                  </a>
                </div>
              </div>
            </div>
            <div class="col-sm-3">
              <div class="box-wrapper">
                <div class="boxes">
                  <a href="#">
                    <img src="{{ asset('assets/images/icons/inventory.png') }}" alt="inventory">
                    <span>{{trans('label.Supplier Report')}}</span>
                  </a>
                </div>
              </div>
            </div>

          </div>
        </div>
      </div>
    </div>
  </div>
</div>

  </div>

</div>

@endsection


@section('script')

<!--stickey kit -->
{{Html::script('assets/js/sticky-kit.min.js')}}
{{Html::script('assets/js/jquery.sparkline.min.js')}}
<!-- This is data table -->
{{Html::script('assets/js/jquery.dataTables.min.js')}}
<!-- start - This is for export functionality only -->
{{Html::script('assets/js/dataTables.buttons.min.js')}}
{{Html::script('assets/js/buttons.flash.min.js')}}
{{Html::script('assets/js/jszip.min.js')}}
{{Html::script('assets/js/pdfmake.min.js')}}
{{Html::script('assets/js/vfs_fonts.js')}}
{{Html::script('assets/js/buttons.html5.min.js')}}
{{Html::script('assets/js/buttons.print.min.js')}}
{{Html::script('assets/custom_js/crud.js')}}

<link rel="stylesheet" href="//code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">


<script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
@endsection