@section('title','income-statement')
@extends('layouts.master')
@section('style')
{{Html::style('assets/css/daterangepicker.css')}}
<style>
td form {
    display: inline-block;
}
</style>
@endsection


@section('content')
<script>
function printContent(el){
  var restorepage = document.body.innerHTML;
  var printcontent = document.getElementById(el).innerHTML;
  document.body.innerHTML = printcontent;
  window.print();
  document.body.innerHTML = restorepage;
}
</script>
<div class="page-wrapper">
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12 text-right">
            <span onclick="printContent('income_statement')"><span class="fa fa-print btn btn-lg danger" style="color: red; margin-bottom: 10px;"></span></span>
            </div>
        </div>
            <div class="col-md-12 text-center" id="income_statement" >
                <div class="text-center">
                @if($shopinfo->shop_name!=null)<h4>{{$shopinfo->shop_name}}</h4>
                  <address>
                  <p>{{$shopinfo->shop_address}}</p>
                  <p>{{$shopinfo->shop_email}} , {{$shopinfo->shop_phone}}</p>
                  </address>
                  @else
                  <h4>Leftjoin</h4>
                   <address>
                  <p>Mirpur ,Dhaka</p>
                  <p>leftjoin@gmail.com , 01738088325</p>
                  </address>
                  @endif

                <h4>{{trans('label.Income Statement')}} </h4>
                </div>
                 <table class="table">
                <thead>
                    <tr>
                        <th>{{trans('label.Description')}}</th>
                        <th>{{trans('label.Amount')}}</th>
                        <th>{{trans('label.Amount')}}</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td>{{trans('label.Gross Sales')}}</td>
                        <td>{{$salesInfo[0]->totalSales ?? 0}}</td>
                        <td></td>
                    </tr>
                    <tr>
                        <td>{{trans('label.Less')}} : {{trans('label.Sales Return')}} </td>
                        <td>{{$salesInfo[0]->TotalReturn ?? 0}}</td>
                        <td></td>
                    </tr>
                    <tr>
                        <td>{{trans('label.Net Sales')}} </td>
                        <td></td>
                        <td>{{($salesInfo[0]->totalSales ?? 0) - ($salesInfo[0]->TotalReturn ?? 0)}}</td>
                    </tr>
                    <tr>
                        <td>{{trans('label.Cost Of Goods Sold')}}</td>
                        <td></td>
                        <td>{{$cogsinfo[0]->cogsTotal ?? 0}}</td>
                    </tr>

                    <tr>
                        <td>{{trans('label.Gross Income')}} </td>
                        <td></td>
                        <td>{{(($salesInfo[0]->totalSales ?? 0) - ($salesInfo[0]->TotalReturn ?? 0)) -($cogsinfo[0]->cogsTotal ?? 0)}}</td>
                    </tr>
                    <tr>
                        <td>{{trans('label.Expenses')}}</td>
                        <td></td>
                        <td>{{($totalExp - $totalExReverse)}}</td>
                    </tr>
                    <tr>
                        <td>{{trans('label.Net Income')}}</td>
                        <td></td>
                        <td>{{((($salesInfo[0]->totalSales ?? 0) - ($salesInfo[0]->TotalReturn ?? 0)) -($cogsinfo[0]->cogsTotal ?? 0))-($totalExp - $totalExReverse)}}</td>
                    </tr>
                </tbody>
            </table>
            </div>

    </div>
</div>

@endsection


@section('script')

<!--stickey kit -->
{{Html::script('assets/js/sticky-kit.min.js')}}
{{Html::script('assets/js/jquery.sparkline.min.js')}}
<!-- This is data table -->
{{Html::script('assets/js/jquery.dataTables.min.js')}}
<!-- start - This is for export functionality only -->
{{Html::script('assets/js/dataTables.buttons.min.js')}}
{{Html::script('assets/js/buttons.flash.min.js')}}
{{Html::script('assets/js/jszip.min.js')}}
{{Html::script('assets/js/pdfmake.min.js')}}
{{Html::script('assets/js/vfs_fonts.js')}}
{{Html::script('assets/js/buttons.html5.min.js')}}
{{Html::script('assets/js/buttons.print.min.js')}}
{{Html::script('assets/custom_js/crud.js')}}
{{Html::script('assets/custom_js/datatable.js')}}

{{Html::script('assets/js/moment.min.js')}}
{{Html::script('assets/js/daterangepicker.min.js')}}




@endsection