@section('title','Report - POS')
@extends('layouts.master')
@section('style')
{{Html::style('assets/css/index.css')}}
<style>
.page-wrapper {
  margin-left: 90px !important;
}
/* bootstrap custom nav-tabs start */
.nav-tabs-wrapper {
  background: #fff;
  margin-right: 10px;
  min-height: 70vh;
  -webkit-box-shadow: 0 1px 15px 0px #999;
  -moz-box-shadow: 0 1px 15px 0px #999;
  box-shadow: 0 1px 15px 0px #999;
}
.nav-tabs {
  border-bottom: 0;
}
.nav-tabs .nav-item {
  width: 20%;
  border-right: 2px solid #ddd;
  text-align: center;
  list-style: none;
}
.nav-tabs .nav-item:last-child{
  border-right: 0;
}
.nav-tabs .nav-link {
  color: #555;
  border-bottom: 5px solid #ddd;
  transition: all .5s;
}
.nav-tabs .nav-link:focus, .nav-tabs .nav-link:hover {
  border-bottom: 5px solid #339c6a;
  color: #339c6a;
}
.nav-tabs .nav-item.show .nav-link, .nav-tabs .nav-link.active {
  border-bottom: 5px solid #339c6a;
  color: #339c6a;
}
@media only screen and (max-width: 600px) {
  .nav-tabs .nav-item {
    width: 33%;
  }
}
@media only screen and (max-width: 380px) {
  .nav-tabs .nav-item {
    width: 100%;
  }
}

.sales_card{
  background: gray;
  padding: 5px;
  color: #fff;
}
/* bootstrap custom nav-tabs end */
</style>
@endsection


@section('content')

<div class="page-wrapper" style="margin-bottom: 100px;">
  <div class="row page-titles">
    <div class="col-md-5 align-self-center">
      <h4 class="text-themecolor title"><span id="heading_field"></span> {{trans('label.Report')}}</h4>
    </div>
  </div>
  <div class="container">
    <div class="row">
      <div class="col-md-4">
        <div class="card">
          <div class="card-body">
            <h4 class="sales_card" >{{trans('label.Total Sales')}}:{{trans('label.TK')}} {{$totalSales[0]->total_sales ?? 0.00}} </h4>
            <h4 class="sales_card">{{trans('label.Today Total Sales')}}:{{trans('label.TK')}} {{$todaySales[0]->total_sales ?? 0.00}} </h4>
            <h4 class="sales_card">{{trans('label.Total Cash Sales')}}:{{trans('label.TK')}} {{$todaySales[0]->receive_amount_from_custome ?? 0.00}} </h4>
            <h4 class="sales_card">{{trans('label.Total Credit Sales')}}:{{trans('label.TK')}} {{$todaySales[0]->due_amount ?? 0.00}} </h4>
          </div>
        </div>
      </div>
      <div class="col-md-4">
        <div class="card">
          <div class="card-body">
            This is some text within a card body.
          </div>
        </div>
      </div>
      <div class="col-md-4">
        <div class="card">
          <div class="card-body">
            This is some text within a card body.
          </div>
        </div>
      </div>
    </div>

      <div class="row">
        <div id="container" style="width: 100%; height: 400px; margin: 0 auto"></div>
        <div id="expenseAndIncome" style="width: 100%; height: 400px; margin: 0 auto;margin-top: 10px;"></div>
      </div>
            <div class="row">
        <div class="col-md-12" style="background: #fff;margin: 10px;">
          <h3 class="text-center">{{trans('label.Over Due Customer List')}}</h3>
          <table id="example" class="display" style="width:100%">
        <thead>
            <tr>
                <th>{{trans('label.code')}}</th>
                <th>{{trans('label.name')}}</th>
                <th>{{trans('label.address')}}</th>
                <th>{{trans('label.phone')}}</th>
                <th>{{trans('label.day_count')}}</th>
                <th>{{trans('label.amount')}}</th>
                <th>{{trans('label.date')}}</th>
            </tr>
        </thead>
        <tbody>
            @forelse($dueCustomers as $dueCustomer)
            <tr>
              <?php
$date1=date_create($dueCustomer->order_date);
$date2=date_create(now());
$diff=date_diff($date1,$date2);
//echo $diff->format("%R%a days");
?>
                <td>{{$dueCustomer->customer_Id ?? null}}</td>
                <td>{{$dueCustomer->name ?? null}}</td>
                <td>{{$dueCustomer->address ?? null}}</td>
                <td>{{$dueCustomer->phone ?? null}}</td>
                <td>{{$dueCustomer->phone ?? null}}</td>
                <td>{{$diff->format("%a days") ?? null}}</td>
                <td>{{$dueCustomer->due_amount ?? null}}</td>
                <td>{{$dueCustomer->order_date ?? null}}</td>
                
                
            </tr>
            @empty
            <tr>
              <td colspan="3"></td>
            </tr>
            @endforelse
        </tbody>

    </table>
        </div>
        
      </div>
      <div class="row" style="margin-top: 20px;">
        <div class="col-md-6" >
          <div style="background: gray;margin-right:5px;padding: 5px;color: #fff;">
            
          <h4 class="text-center">Top Ten Customers</h4>
          <table class="table">
            <thead>
              <tr>
                <td>{{trans('label.sl')}}</td>
                <td>{{trans('label.name')}}</td>
                <td>{{trans('label.amount')}}</td>
              </tr>
            </thead>
            <tbody>
              @forelse($topTenCustomer as $topCustomer)
              <tr>
                <td>{{$loop->iteration}}</td>
                <td>{{$topCustomer->customer_Id ?? null}} | {{$topCustomer->name ?? null}}</td>
                <td>{{$topCustomer->total_amount ?? null}}</td>
              </tr>
              @empty
              <tr>
                <td>{{trans('label.no data found')}}</td>
              </tr>
              @endforelse
            </tbody>
          </table>
          </div>
        </div>
        <div class="col-md-6" style="background: gray;color: #fff;">
          <h4 class="text-center">Top Ten Products</h4>
          <table class="table">
            <thead>
              <tr>
                <td>{{trans('label.sl')}}</td>
                <td>{{trans('label.name')}}</td>
                <td>{{trans('label.amount')}}</td>
              </tr>
            </thead>
            <tbody>
              @forelse($topTenProductList as $topProdcut)
              <tr>
                <td>{{$loop->iteration}}</td>
                <td>{{$topProdcut->product_id ?? null}} | {{$topProdcut->name ?? null}}</td>
                <td>{{$topProdcut->total_amount ?? null}}</td>
              </tr>
              @empty
              <tr>
                <td>{{trans('label.no data found')}}</td>
              </tr>
              @endforelse
            </tbody>
          </table>
        </div>
      </div>
  </div>
</div>


@endsection


@section('script')

<!--stickey kit -->
{{Html::script('assets/js/sticky-kit.min.js')}}
{{Html::script('assets/js/jquery.sparkline.min.js')}}
<!-- This is data table -->
{{Html::script('assets/js/jquery.dataTables.min.js')}}
<!-- start - This is for export functionality only -->
{{Html::script('assets/js/dataTables.buttons.min.js')}}
{{Html::script('assets/js/buttons.flash.min.js')}}
{{Html::script('assets/js/jszip.min.js')}}
{{Html::script('assets/js/pdfmake.min.js')}}
{{Html::script('assets/js/vfs_fonts.js')}}
{{Html::script('assets/js/buttons.html5.min.js')}}
{{Html::script('assets/js/buttons.print.min.js')}}
{{Html::script('assets/custom_js/crud.js')}}

<link rel="stylesheet" href="//code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">


<script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>

<script src="https://code.highcharts.com/highcharts.js"></script>
<script src="https://code.highcharts.com/modules/exporting.js"></script>
<script src="https://code.highcharts.com/modules/export-data.js"></script>

<script type="text/javascript">
  $(document).ready(function() {
    var table = $('#example').DataTable( {
        fixedHeader: {
            header: true,
            footer: true
        }
    } );
} );

  Highcharts.chart('expenseAndIncome', {
    chart: {
        type: 'spline'
    },
    title: {
        text: 'Monthly Income and Cost of goods Sold Line Chart'
    },
    subtitle: {
        text: 'Last 12 Month'
    },
    xAxis: {
        categories: [<?php foreach ($costofsales as $key => $value) {
             $monthName = date("F", mktime(0, 0, 0, $value->Month, 10));
          echo '"'.$monthName ." ".$value->Year.'"'.',';} ?>]
    },
    yAxis: {
        labels: {
            formatter: function () {
                return this.value + '°';
            }
        }
    },
    tooltip: {
        crosshairs: true,
        shared: true
    },
    plotOptions: {
        spline: {
            marker: {
                radius: 4,
                lineColor: '#666666',
                lineWidth: 1
            }
        }
    },
    series: [{
        name: 'Income',
        marker: {
            symbol: 'square'
        },
        data: [<?php foreach ($monthlySalesReport as $key => $value) {
          echo $value->monthly_amount. ',';
        } ?>]

    }, {
        name: 'Cost of Goods Sold',
        marker: {
            symbol: 'diamond'
        },
        data: [<?php foreach ($costofsales as $key => $value) {
          echo $value->monthly_amount. ',';
        } ?>]
    }]
});

    Highcharts.chart('container', {
    chart: {
        type: 'column'
    },
    title: {
        text: 'Monthly Sales Report For last 12 Month'
    },
    xAxis: {
        categories: [
            <?php foreach ($monthlySalesReport as $key => $value) {
             $monthName = date("F", mktime(0, 0, 0, $value->Month, 10));
          echo '"'.$monthName ." ".$value->Year.'"'.',';} ?>
        ],
        crosshair: true
    },
    yAxis: {
        min: 0,
        title: {
            text: 'Monthly Sales Report (tk)'
        }
    },
    tooltip: {
        headerFormat: '<span style="font-size:10px">{point.key}</span><table>',
        pointFormat: '<tr><td style="color:{series.color};padding:0">{series.name}: </td>' +
            '<td style="padding:0"><b>{point.y:.2f} tk</b></td></tr>',
        footerFormat: '</table>',
        shared: true,
        useHTML: true
    },
    plotOptions: {
        column: {
            pointPadding: 0.2,
            borderWidth: 0
        }
    },
    series: [{
        name: 'Monthly Sales Report',
        data: [<?php foreach ($monthlySalesReport as $key => $value) {
          echo $value->monthly_amount. ',';
        } ?>]

    }]
});
 
</script>
@endsection