@section('title','balance sheet')
@extends('layouts.master')
@section('style')
{{Html::style('assets/css/daterangepicker.css')}}
<style>
td form {
    display: inline-block;
}

</style>
@endsection


@section('content')
<script>
function printContent(el){
  var restorepage = document.body.innerHTML;
  var printcontent = document.getElementById(el).innerHTML;
  document.body.innerHTML = printcontent;
  window.print();
  document.body.innerHTML = restorepage;
}
</script>

<div class="page-wrapper">
    <div class="container-fluid">

       <!-- <form class="form-inline">
        <div class="form-group  mb-2">
                @php
                $todayyear=date("Y");
                $prevfive=$todayyear-5;
                @endphp
                <select name="year" class="form-control">
                  @for($todayyear;$todayyear>$prevfive;$todayyear--)
                  <option value="{{$todayyear}}" @if(isset($_GET['year']) && $_GET['year']==$todayyear) selected="selected" @endif>{{$todayyear}}</option>
                  @endfor
                </select>
        </div>
        <button type="submit" class="btn btn-primary mb-2">{{trans('label.change')}}</button>
      </form> -->
        <div class="row">

            <div class="col-sm-12 text-right">
            <span onclick="printContent('income_statement')"><span class="fa fa-print btn btn-lg danger" style="color: red; margin-bottom: 10px;"></span></span>
            </div>
        </div>
            <div class="col-md-12 text-center" id="income_statement" >
                <div class="text-center">
                @if($shopinfo->shop_name!=null)<h4>{{$shopinfo->shop_name}}</h4>
                  <address>
                  <p>{{$shopinfo->shop_address}}</p>
                  <p>{{$shopinfo->shop_email}} , {{$shopinfo->shop_phone}}</p>
                  </address>
                  @else
                  <h4>Leftjoin</h4>
                   <address>
                  <p>Mirpur ,Dhaka</p>
                  <p>leftjoin@gmail.com , 01738088325</p>
                  </address>
                  @endif

                <h4>{{trans('label.Balance Sheet')}}</h4>
                <h6>{{trans('label.For the year')}} {{$_GET['year'] ?? date("Y")}}</h6>
                </div>
                <table class="table table-bordered">
                  <thead>
                  <tr>
                    <th width="80%">{{trans('label.Account Title')}}</th>
                    <th width="10%" >{{trans('label.Debit')}}</th>
                    <th width="10%" >{{trans('label.Credit')}}</th>
                  </tr>
                  </thead>
                  <tbody id="table-content">
                    @php
                    $ap=$accountspayable->sab ?? 0;
                    $ar=$accountsrecivale->cab ?? 0;
                    $cb=$cash[0]->csab ?? 0;
                    $capacc=$capital->capab ?? 0;
                    $bankb=$bank->bab ?? 0;
                    $addpaid=$advanced_paid->apab ?? 0;
                    $addreceived=$advanced_received->arb ?? 0;
                    @endphp
                  <tr>
                    <td style="text-align:left">{{trans('label.Cash')}}</td>
                    <td class="debit" style="text-align:right;">{{number_format($cb,2)}}</td>
                    <td class="credit" style="text-align:right"></td>
                  </tr>
                  <tr>
                    <td style="text-align:left">{{trans('label.Inventory')}}</td>
                    <td class="debit" style="text-align:right;">{{number_format($inventory[0]->total_amount ?? 0,2)}}</td>
                    <td class="credit" style="text-align:right"></td>
                  </tr>
                  <tr>
                    <td style="text-align:left">{{($bankb <0)? 'Bank Overdraft' :'Bank'}}</td>
                    <td class="debit" style="text-align:right;">{{($bankb >=0)? number_format($bankb,2) :null}}</td>
                    <td class="credit" style="text-align:right">{{($bankb <0)? number_format($bankb*-1,2) :null}}</td>
                  </tr>
                  <tr>
                    <td style="text-align:left">{{trans('label.Customer')}}</td>
                    <td class="debit" style="text-align:right;">{{($ar >=0)? number_format($ar,2) :null}}</td>
                    <td class="credit" style="text-align:right">{{($ar <0)? number_format($ar*-1,2) :null}}</td>
                  </tr>
                  <tr>
                    <td style="text-align:left">{{trans('label.Investment (outside)')}}</td>
                    <td class="debit" style="text-align:right;">{{number_format($addpaid,2)}}</td>
                    <td class="credit" style="text-align:right"></td>
                  </tr>
                  <tr>
                    <td style="text-align:left">{{($capacc <0)? 'Withdraw' :'Capital'}}</td>
                    <td class="debit" style="text-align:right;">{{($capacc <0)? number_format($capacc*-1,2) :null}}</td>
                    <td class="credit" style="text-align:right">{{($capacc >=0)? number_format($capacc,2) :null}}</td>
                  </tr>
                  <tr>
                    <td style="text-align:left">{{trans('label.Supplier')}}</td>
                    <td class="debit" style="text-align:right;">{{($ap <0)? number_format($ap*-1,2) :null}}</td>
                    <td class="credit" style="text-align:right">{{($ap >=0)? number_format($ap,2) :null}}</td>
                  </tr>

                  <tr>
                    <td style="text-align:left">{{trans('label.Advanced received')}}</td>
                    <td class="debit" style="text-align:right;"></td>
                    <td class="credit" style="text-align:right">{{number_format($addreceived,2)}}</td>
                  </tr>
                  <tr>
                    <td style="text-align:left">{{trans('label.Net Profit / Loss')}}</td>
                    <td class="debit" style="text-align:right;"></td>
                    <td class="credit" style="text-align:right">{{ number_format($net_income,2) }}</td>
                  </tr>
                  <tr style="font-weight: bold;">
                    <td style="text-align:center">{{trans('label.Total')}}</td>
                    <td class="debittotal"  style="text-align:right;"></td>
                    <td class="credittotal" style="text-align:right"></td>
                  </tr>
                  </tbody>
                </table>
            </div>

    </div>
</div>

@endsection
@section('script')

<!--stickey kit -->
{{Html::script('assets/js/sticky-kit.min.js')}}
{{Html::script('assets/js/jquery.sparkline.min.js')}}
<!-- This is data table -->
{{Html::script('assets/js/jquery.dataTables.min.js')}}
<!-- start - This is for export functionality only -->
{{Html::script('assets/js/dataTables.buttons.min.js')}}
{{Html::script('assets/js/buttons.flash.min.js')}}
{{Html::script('assets/js/jszip.min.js')}}
{{Html::script('assets/js/pdfmake.min.js')}}
{{Html::script('assets/js/vfs_fonts.js')}}
{{Html::script('assets/js/buttons.html5.min.js')}}
{{Html::script('assets/js/buttons.print.min.js')}}
{{Html::script('assets/custom_js/crud.js')}}
{{Html::script('assets/custom_js/datatable.js')}}

{{Html::script('assets/js/moment.min.js')}}
{{Html::script('assets/js/daterangepicker.min.js')}}

<script>
  $(document).ready(function(){
    var debittotal=0;
    $('#table-content').find('.debit').each(function() {
      var debit=$(this).text();
      var modifydebit=debit.trim();
      var sumdebit=(modifydebit!='')?modifydebit:'0';
      var sdmd=sumdebit.replace(/,\s?/g, "");
      debittotal=debittotal+parseFloat(sdmd);
    });
    $('.debittotal').html("<span>"+debittotal.toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,')+"<span>");
    var credittotal=0;
    $('#table-content').find('.credit').each(function() {
      var credit=$(this).text();
      var modifycredit=credit.trim();
      var sumcredit=(modifycredit!='')?modifycredit:'0';
      var sdmc=sumcredit.replace(/,\s?/g, "");
      credittotal=credittotal+parseFloat(sdmc);
    });
    $('.credittotal').html("<span>"+credittotal.toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,')+"<span>");
  });
</script>




@endsection