<div class="table-responsive">
    <table id="example23" class="display nowrap table table-hover table-striped table-bordered" cellspacing="0" width="100%">
        <thead>
            <tr>
                <th>{{trans('label.SL')}}</th>
                <th>{{trans('label.Order No')}}</th>
                <th>{{trans('label.Supplier')}}</th>
                <th>{{trans('label.Phone')}}</th>
                <th>{{trans('label.Amount')}}</th>
                <th>{{trans('label.Order Date')}}</th>
                <th>{{trans('label.Receivable Date')}}</th>

                <th>{{trans('label.Action')}}</th>
            </tr>
        </thead>

        <tbody>
            @forelse($info as $invoice)
            <tr>
                <td class="text-right">{{$loop->iteration}}</td>
                <td class="text-right">{{$invoice->id}}</td>
                <td>
                    {{$invoice->SupplierProfile->name ?? 'Opening Inventory'}}
                </td>
                <td>
                    {{$invoice->SupplierProfile->phone ?? null}}
                </td>
                <td class="text-right">{{$invoice->net_amount}}</td>
                <td>{{$invoice->order_date}}</td>
                <?php
$dt = new DateTime('now', new DateTimezone('Asia/Dhaka'));
$date = $dt->format('Y-m-d H:i:s');
if ($invoice->expected_delivery_date < $date) {
	?>

                <td style="background: #f39a9e" >{{$invoice->expected_delivery_date}}</td>
                <?php } else {?>

                <td>{{$invoice->expected_delivery_date}}</td>

                <?php }?>


                <td><a href="{{url('purchase-invoice',$invoice->id)}}">{{trans('label.Details')}}</a> | <a href="{{url('preorder-receive',$invoice->id)}}" >{{trans('label.Receive')}}</a> | <a href="{{url('preorder-delete',$invoice->id)}}">{{trans('label.Cancel')}}</a></td>
            </tr>
            @empty
            @endforelse

        </tbody>
    </table>
</div>