@section('title','Purchase Invoice- POS')
@extends('layouts.master')
@section('style')
{{-- {{Html::style('assets/public_css/index.css')}} --}}
<style>
td form {
    display: inline-block;
}
body {
    counter-reset: serial-number;
}
table#example23 tr td:first-child:before {
    counter-increment: serial-number;
    content: counter(serial-number);
}
</style>
@endsection


@section('content')

<div class="page-wrapper">

    <div class="container-fluid">
        <div class="row page-titles">
            <div class="col-md-6 align-self-center">
                <h4 class="text-themecolor title"><span id="heading_field"></span> {{trans('label.Pre Order')}} </h4>
            </div>
            <div class="col-md-6">
              <a href="{{url('reorder')}}" class="btn btn-success pull-right">{{trans('label.Re Order Item List')}}</a>
            </div>

        </div>

        <div class="row">
        <div class="col-12">
           @if (Session::has('message'))
              <div class="alert alert-info" style="color: #000">{{ Session::get('message') }}</div>
            @endif
            <div class="card">
                <div class="card-body">
                  <div class="container">
                    <form action="{{url('add-single-pre-order')}}" method="post" >
                      {{csrf_field()}}
                      @if($errors->any())
                      <h4 class="alert alert-warning" >{{$errors->first()}}</h4>
                      @endif
                     <?php
if (isset($priceListInfo)) {
	?>
                         <div class="form-group row">
                        <label for="product_id" class="col-sm-2 col-form-label">{{trans('label.Product Id')}}</label>
                        <div class="col-sm-10">
                          <input type="text" name="product_id" id="product_id" class="form-control"  required="required" value="{{$priceListInfo->id}}" readonly="readonly"  >
                        </div>
                      </div>
                       <div class="form-group row">
                        <label for="product_Name" class="col-sm-2 col-form-label">{{trans('label.Product Name')}}</label>
                        <div class="col-sm-10">
                          <input type="text" name="product_Name" id="product_Name" class="form-control"  required="required" value="{{$priceListInfo->name}}" readonly="readonly" >
                        </div>
                      </div>
                      <div class="form-group row">
                        <label for="qty" class="col-sm-2 col-form-label">{{trans('label.Qty')}} </label>
                        <div class="col-sm-10">
                          <input type="text" name="qty" id="qty" class="form-control"  required="required" value="{{ $priceListInfo->min_reorder_qty}}">
                        </div>
                      </div>
                      <div class="form-group row">
                        <label for="price" class="col-sm-2 col-form-label">{{trans('label.Unit Price')}}</label>
                        <div class="col-sm-10">
                          <input type="text" name="price" id="price" class="form-control"  required="required" placeholder="{{trans('label.Estimated Purchase Price')}}" value="{{ $priceListInfo->cost_price}}" >
                          <input type="hidden" name="status"  class="form-control text-right"  value="2" >
                        </div>
                      </div>
                      <div class="row">
                        <div class="col-md-12">
                          <div class="pull-right">
                            <input type="submit" class="btn btn-success" value="{{trans('label.Add To Order')}}" >
                          </div>
                        </div>
                      </div>
                    <?php }?>


                    <?php
if (isset($profileInfo)) {?>
                      <div class="form-group row">
                        <label for="product_id" class="col-sm-2 col-form-label">{{trans('label.Product Id')}}</label>
                        <div class="col-sm-10">
                          <input type="text" name="product_id" id="product_id" class="form-control"  required="required" value="{{$profileInfo->id}}" readonly="readonly"  >
                        </div>
                      </div>
                       <div class="form-group row">
                        <label for="product_Name" class="col-sm-2 col-form-label">{{trans('label.Product Name')}}</label>
                        <div class="col-sm-10">
                          <input type="text" name="product_Name" id="product_Name" class="form-control"  required="required" value="{{$profileInfo->name}}" readonly="readonly" >
                        </div>
                      </div>
                      <div class="form-group row">
                        <label for="qty" class="col-sm-2 col-form-label">{{trans('label.Qty')}} </label>
                        <div class="col-sm-10">
                          <input type="text" name="qty" id="qty" class="form-control"  required="required" value="{{ $profileInfo->min_reorder_qty}}">
                        </div>
                      </div>
                      <div class="form-group row">
                        <label for="price" class="col-sm-2 col-form-label">{{trans('label.Unit Price')}}</label>
                        <div class="col-sm-10">
                          <input type="text" name="price" id="price" class="form-control"  required="required" placeholder="{{trans('label.Back')}}Estimated Purchase Price"  >
                          <input type="hidden" name="status"  class="form-control text-right"  value="2" >
                        </div>
                      </div>
                      <div class="row">
                        <div class="col-md-12">
                          <div class="pull-right">
                            <input type="submit" class="btn btn-success" value="{{trans('label.Add To Order')}}" >
                          </div>
                        </div>
                      </div>
                  <?php }?>



                    </form>
                  </div>
                </div>
            </div>
        </div>
    </div>
    </div>
</div>

@endsection


@section('script')

<!--stickey kit -->
{{Html::script('assets/js/sticky-kit.min.js')}}
{{Html::script('assets/js/jquery.sparkline.min.js')}}
<!-- This is data table -->
{{Html::script('assets/js/jquery.dataTables.min.js')}}
<!-- start - This is for export functionality only -->
{{Html::script('assets/js/dataTables.buttons.min.js')}}
{{Html::script('assets/js/buttons.flash.min.js')}}
{{Html::script('assets/js/jszip.min.js')}}
{{Html::script('assets/js/pdfmake.min.js')}}
{{Html::script('assets/js/vfs_fonts.js')}}
{{Html::script('assets/js/buttons.html5.min.js')}}
{{Html::script('assets/js/buttons.print.min.js')}}
{{Html::script('assets/custom_js/crud.js')}}
{{Html::script('assets/custom_js/datatable.js')}}

<!-- end - This is for export functionality only -->
{{-- {{Html::script('assets/public_js/index.js')}} --}}
<link rel="stylesheet" href="//code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">


<script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>


@endsection