@section('title','Purchase return - POS')
@extends('layouts.master')
@section('style')
{{-- {{Html::style('assets/public_css/index.css')}} --}}
<style>
td form {
  display: inline-block;
}
.right_side_panel {
  background: #999;
  padding: 15px 7px;
  color: #fff;
}


.btn-transparent.active {
  border-color: #6692B0;
  background-color: #6692B0;
  color: #FFF;
}
td form {
  display: inline-block;
}
.right_side_panel {
  background: #999;
  padding: 15px 7px;
  color: #fff;
}
.product-name {
  font-size: 17px;
  font-weight: bold;
}
.single-product .media {
  position: relative;
}
.single-product .media[aria-expanded='false'] .arrow:before {
  content: "\f105";
  font-family: 'FontAwesome';
  position: absolute;
  left: 0px;
  top: 0px;
  color: #555;
  font-size: 16px;
}
.single-product .media[aria-expanded='true'] .arrow:before {
  content: "\f107";
  font-family: 'FontAwesome';
  position: absolute;
  left: -3px;
  top: 0px;
  color: #555;
  font-size: 16px;
}
#selected_customer {
  padding: 10px;
}
#selected_customer .customer_link {
  font-size: 16px;
  font-weight: bold;
  cursor: pointer;
}

/* table style start */
.table td {
  padding: 0;
}
.table td input {
  width: 100%;
}
/* table style end */
.table td input {
  width: 100%;
  border: 0;
  text-align: center;
  padding: 0 6px;
}

/* modal style start */
.modal-header {
  border-bottom: 0;
  padding-bottom: 0;
}
.info-heading .title {
  border-bottom: 1px solid #ddd;
}
.info-heading .info .lebel {
  color: #6692B0;
}
/* modal style end */
.card.shadow {
  box-shadow: 0 .5rem 1rem rgba(0,0,0,.15)!important;
}
.modal-content {
    border: 1px solid rgba(27, 142, 19, 0.94);
}
.modal-header {
    border-bottom: 1px solid rgba(27, 142, 19, 0.94);
}
.modal-footer {
    border-top: 1px solid rgba(27, 142, 19, 0.94);
}
</style>
@endsection


@section('content')


<div class="page-wrapper">
  <div class="container-fluid">
    <div class="row">
      <div class="col-md-6">
        {{trans('label.Purchase Invoice')}}
      </div>
      <div class="col-md-6">
        <a href="{{ url('purchase-invoice')}}" class="btn btn-success pull-right">{{trans('label.Product Recieved List')}}</a>
      </div>


      <div class="col-md-12">
        @if (Session::has('message'))
                       <h6 style="background: #20c997; color: red; text-align: center; padding: 5px; border-radius: 5px;">{{ Session::get('message') }}</h6>
                    @endif
        <div class="card shadow">
          <div class="card-body">
            <form action="{{ url('purchase-return-confirm')}}"  method="post">
              {{csrf_field()}}
              <div class="row">
                <div class="col-md-3">
                    <div class="form-group">
                      <label for="customer_field">{{trans('label.Supplier')}} <span class="text-danger">*</span></label>
                      <div>

                      <input type="text" attr_url="" name="supplier_name" id="supplier_name" class="form-control" required="required" value="{{ $porder->SupplierProfileLimit->name ?? null}}" readonly="readonly">
                      <input type="hidden" name="supplier_id" id="supplier_id" class="form-control" value="{{ $porder->supplier_Id ?? null}}" readonly="readonly" required="required">
                      </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="ref_no">{{trans('label.Supplier Ref')}} : <span class="text-danger">*</span></label>
                        <div class="controls">
                          <input type="text" name="sup_ref_no" id="ref_no" class="form-control text-right">
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group text-center">
                        <label for="preorder_ref">{{trans('label.Order Ref')}} : </label>
                        <div class="controls">
                          <input type="text" name="preorder_ref" id="preorder_ref" class="form-control" value="{{$porder->id}}" readonly="readonly" required="required">
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                  <div class="form-group">
                      <label for="Purchase_date">{{trans('label.Purchase Date')}} <span class="text-danger">*</span></label>
                      <input class="form-control text-right" name="order_date" id="Purchase_date" type="text" required="required" readonly="readonly" value="{{$porder->order_date}}">



                  </div>
                </div>

              </div>

              <div class="searching-items">
                <div class="table-responsive">
                  <table id="example23" class="tem_product display nowrap table table-hover table-striped table-bordered view_data_table" cellspacing="0" width="100%">
                    <thead>
                      <tr>
                        <th>{{trans('label.Barcode')}}</th>
                        <th>{{trans('label.Product Name')}}</th>
                        <th>{{trans('label.Quantity')}}</th>
                        <th>{{trans('label.Price_unit')}}</th>
                        <th>{{trans('label.VAT')}} %</th>
                        <th>{{trans('label.Discount')}} %</th>
                        <th>{{trans('label.Line Total')}}</th>
                        <th>{{trans('label.Action')}}</th>
                      </tr>
                    </thead>
                    <tbody>
                      @php
                      $discount_total=0;
                      $vat_total=0;
                      $gross_total=0;
                      $net_line_total=0;

                      @endphp
@foreach($porder_details as $pdetails)
                      @if($pdetails->pqty>0)
                      @php
                          $discount_rate=$pdetails->discount_rate ?? 0;
                          $vat_rate=$pdetails->vat_rate ?? 0;
                          $per_unitgros=$pdetails->l_gross_cost_price/$pdetails->qty;
                           $dislinetotal=(($per_unitgros*$discount_rate)/100)*$pdetails->pqty;
                         $grossltad=($per_unitgros-($per_unitgros*$discount_rate)/100)*$pdetails->pqty;
                           $grossvatlt=(($grossltad*$vat_rate)/100);
                          $linetav=$grossltad+$grossvatlt;


                          //
                          $discount_total=$discount_total+$dislinetotal;
                          $vat_total=$vat_total+$grossvatlt;
                          $gross_total=$gross_total+($per_unitgros*$pdetails->pqty);
                          $net_line_total=$net_line_total+$linetav;

                          @endphp
                      <tr class="single_return">
                        <td>
                          <input type="hidden" name="perchase_details_id[]" id="product_id" value="{{$pdetails->id}}">
                          <input type="hidden" name="order_id" id="order_id" value="{{$pdetails->order_id}}">

                          <input type='text'  name='barcode[]' value='{{$pdetails->bqcode ?? null}}' class='text-right' readonly="readonly">
                        </td>
                        <td>
                          <input  type='hidden' class='product_id' id='' value='{{$pdetails->product_id ?? null}}' name='product_id[]' readonly="readonly">

                          <input type='text'  name='product_name[]' value='{{$pdetails->product_name}}' class='text-right' readonly="readonly" required="required">

                        </td>
                        <td>
                          <input type="hidden" value="{{$pdetails->pqty}}">
                          <input type='number' step='any' min='1' class='form-control qty text-right'   value='{{$pdetails->pqty}}' name='qty[]' autocomplete="off" @if($pdetails->bqcode!=null) readonly="readonly" @endif>
                          <input type='hidden' name="default_qty[]"  class='form-control qty_default text-right'   value='{{$pdetails->pqty}}'  autocomplete="off">
                        </td>
                        <td class="text-right">
                          <input type='number' step='any' name='unitgross_price[]' value='{{$per_unitgros}}' class='unitgross_price cost_price text-right' required="required" min="0" readonly="readonly">
                          <input type="hidden" name="gross_line_total" value="{{$per_unitgros*$pdetails->pqty}}" class="gross_line_total">
                        </td>
                         <td>
                          <input type='number' step='any' name='vat_rate[]' value='{{$pdetails->vat_rate ?? 0}}' class='vat_rate text-right' required="required" min="0" readonly="readonly">
                        </td>
                        <td>
                          <input type='number' step='any' class='form-control discount_rate text-right'  name='discount_rate[]' value='{{$pdetails->discount_rate ?? 0}}' min="0" autocomplete="off" readonly="readonly">
                        </td>

                         <td>
                          <input  type='hidden' class='discount_line_total' value='{{$dislinetotal}}' name='discount_line_total[]'>
                          <input  type='hidden' class='vat_line_total' id='vat_line_total' value='{{$grossvatlt}}' name='vat_line_total[]'>
                          <input type='text' step='any' name='line_total[]' value='{{$linetav}}' class=' text-right cost_price_line_total' required="required" min="0" readonly="readonly">




                        </td>

                        <td class="text-center">
                          <a class="delpurchaseTemp" href="">
                            <i class='fa fa-trash' aria-hidden='true'></i>
                          </a>
                        </td>
                      </tr>
                  @endif
                  @endforeach

                    </tbody>
                  </table>
                </div>
                <div class="row grand_total_field text-center">
                  @php
                  if($porder->payment_amount<$porder->net_amount){
                    $initialdue=$porder->net_amount-$porder->payment_amount;
                  }else{
                    $initialdue=0;
                  }
                  if ($initialdue !=0 && $initialdue >$net_line_total) {
                    $payment_net_amount=$net_line_total;
                    $cash_received=0;
                  }elseif($initialdue !=0 && $initialdue <$net_line_total){
                    $payment_net_amount=$initialdue;
                    $cash_received=$net_line_total-$initialdue;
                  }else{
                    $payment_net_amount=$net_line_total;
                    $cash_received=0;
                  }



                  @endphp

                    <div class="col-md-2">
                      <div class="form-group">
                        <label for="gross_amount">{{trans('label.Gross total')}} <span class="text-danger"></span></label>
                        <input type="text" name="gross_amount"  class="form-control gross_total_input text-right " value="{{$gross_total}}" readonly="readonly" required="required">
                      </div>
                    </div>
                    <div class="col-md-2">
                      <div class="form-group">
                        <label for="discount_total">{{trans('label.Discount total')}} <span class="text-danger"></span></label>
                        <input type="number" step="any" name="gross_discount"  class="form-control gross_discount_input text-right " value="{{$discount_total}}" required="required" readonly="readonly">
                      </div>
                    </div>
                    <div class="col-md-2">
                      <div class="form-group">
                        <label for="vat_total">{{trans('label.Vat Total')}} <span class="text-danger"></span></label>
                        <input type="number" step="any" name="gross_vat_amount"  class="form-control gross_tax_input text-right" value="{{$vat_total}}" required="required" readonly="readonly">
                      </div>
                    </div>

                    <div class="col-md-2">
                      <div class="form-group">
                        <label for="net_amount">{{trans('label.Net Amount')}} <span class="text-danger"></span></label>
                        <input type="hidden" name="return_tansaction_type" value="{{$porder->transection_type}}">
                        <input type="number" step="any" name="net_amount"  class="form-control net_total_input text-right" value="{{$net_line_total}}" required="required" readonly="readonly">
                      </div>
                    </div>
                   <div class="col-md-2" style="color:red;">
                    <div class="form-group">
                      <label for="paid_amount">{{trans('label.Receive Amount')}} <span class="text-danger"></span></label>
                      <input type="number" step="any" name="received_amount"  class="form-control text-right refund" value="{{$cash_received}}" >
                    </div>
                   </div>
                   <div class="col-md-2">
                      <div class="form-group">
                        <label for="due_amount">{{trans('label.Payable Amount')}} <span class="text-danger"></span></label>
                        <input type="hidden" name="initialdue" id="initialdue" value="{{$initialdue}}">
                        <input type="hidden" name="payment_net_amount" id="payment_net_amount" value="{{$payment_net_amount}}">

                        <input type="hidden" name="cash_received" id="cash_received" value="{{$cash_received}}">
                        <input type="number" step="any" name="Due_amount"  class="form-control text-right Due_amount "  value="{{$payment_net_amount}}"  value="0"   required="required" readonly="readonly">
                      </div>
                   </div>
                    <div class="col-md-12">
                  <div class="form-group">

                        <input type="text" name="note"  class="form-control"  required="required" autocomplete="off" style="border-radius:  5px; min-height: 50px; " placeholder="{{trans('label.Write Reson of Return')}} ">

                </div>
                    <div class="col-md-12">
                      <button type="submit" id="sales_return_confirm" class="btn btn-success btn-lg pull-right" style="width: 100%">
                            {{trans('label.Return')}} <span class="inner-badge">F2</span>
                          </button>
                    </div>
                </div>

              </div>
            </form>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>



@endsection


@section('script')

<!--stickey kit -->
{{Html::script('assets/js/sticky-kit.min.js')}}
{{Html::script('assets/js/jquery.sparkline.min.js')}}
<!-- This is data table -->
{{Html::script('assets/js/jquery.dataTables.min.js')}}
<!-- start - This is for export functionality only -->
{{Html::script('assets/js/dataTables.buttons.min.js')}}
{{Html::script('assets/js/buttons.flash.min.js')}}
{{Html::script('assets/js/jszip.min.js')}}
{{Html::script('assets/js/pdfmake.min.js')}}
{{Html::script('assets/js/vfs_fonts.js')}}
{{Html::script('assets/js/buttons.html5.min.js')}}
{{Html::script('assets/js/buttons.print.min.js')}}
{{Html::script('assets/custom_js/crud.js')}}
{{Html::script('assets/custom_js/add_more.js')}}

<link rel="stylesheet" href="//code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">


<script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
{{Html::script('assets/custom_js/purchase_return.js')}}

@endsection