@section('title','Purchase Return List')
@extends('layouts.master')
@section('style')
<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
{{-- {{Html::style('assets/public_css/index.css')}} --}}
<style>
td form {
    display: inline-block;
}
</style>
@endsection


@section('content')
<div class="page-wrapper">
    <div class="container-fluid">
        <div class="row page-titles">
          <div class="col-md-6">
            <h5>{{trans('label.Purchase Return Report')}}</h5>
          </div>
          <div class="col-md-6" style="text-align: right;">
            <a href="{{ url('purchase-order') }}" class="btn btn-success">{{trans('label.Make Purchase')}}</a>
            <button onclick="goBack()" class="btn btn-transparent-border"><i class="fa fa-chevron-left" aria-hidden="true"></i> {{trans('label.Back')}}</button>
          </div>
        </div>
        <div class="row">
            <div class="col-md-3">
               <div id="reportrange" style="background: #fff; cursor: pointer; padding: 5px 10px; border: 1px solid #ccc; width: 100%">
                <i class="fa fa-calendar"></i>&nbsp;
                <span></span> <i class="fa fa-caret-down"></i>

               </div>
            </div>
            <div class="col-md-1 pl-0">
                <form>
                    <input type="hidden" name="date_range" class="date_range">
                    <input type="submit" value="Change" class="btn btn-success" style="padding: 7px 10px;border-radius: 0;">
                </form>

            </div>
            <div class="col-md-3">
              <div class="box-shadow">
                <span>{{trans('label.Total Purchase Return')}}:
                @if(!empty($info))
                {{number_format($info->sum('return_return_amount'),2)}}
                @endif
                </span>
              </div>
            </div>
            <div class="col-12">
                <div class="card-body-wrapper">
                    <div id='table_position'>
                    @include('purchase-order.purchase_invoice_return_table')
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('script')

<!--stickey kit -->
{{Html::script('assets/js/sticky-kit.min.js')}}
{{Html::script('assets/js/jquery.sparkline.min.js')}}
<!-- This is data table -->
{{Html::script('assets/js/jquery.dataTables.min.js')}}
<!-- start - This is for export functionality only -->
{{Html::script('assets/js/dataTables.buttons.min.js')}}
{{Html::script('assets/js/buttons.flash.min.js')}}
{{Html::script('assets/js/jszip.min.js')}}
{{Html::script('assets/js/pdfmake.min.js')}}
{{Html::script('assets/js/vfs_fonts.js')}}
{{Html::script('assets/js/buttons.html5.min.js')}}
{{Html::script('assets/js/buttons.print.min.js')}}
{{Html::script('assets/custom_js/crud.js')}}
{{Html::script('assets/custom_js/datatable.js')}}

<!-- end - This is for export functionality only -->
{{-- {{Html::script('assets/public_js/index.js')}} --}}
<script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
@if($request->all()==null)
<script>

    $(function() {

    var start = moment().subtract(29, 'days');
    var end = moment();

    function cb(start, end) {
        $('#reportrange span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
        $('input.date_range').val(start.format('Y-MM-DD')+' '+ end.format('Y-MM-DD'));
    }

    $('#reportrange').daterangepicker({
        startDate: start,
        endDate: end,
        ranges: {
           'Today': [moment(), moment()],
           'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
           'Last 7 Days': [moment().subtract(6, 'days'), moment()],
           'Last 30 Days': [moment().subtract(29, 'days'), moment()],
           'This Month': [moment().startOf('month'), moment().endOf('month')],
           'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
        }
    }, cb);

    cb(start, end);

});
</script>
@else
@php
$time = explode(' ', $_GET['date_range']);
@endphp
@if(array_key_exists(0, $time) && array_key_exists(1, $time))
@php
$start_date = $time[0];
$end_date = $time[1];
@endphp
<input type="hidden" id="start_date" value="{{$start_date }}">
<input type="hidden" id="end_date" value="{{$end_date }}">
<script>

    $(function() {
    var start_date=$('#start_date').val();
    var end_date=$('#end_date').val();
    var start = moment(start_date);
    var end = moment(end_date);

    function cb(start, end) {
        $('#reportrange span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
        $('input.date_range').val(start.format('Y-MM-DD')+' '+ end.format('Y-MM-DD'));
    }

    $('#reportrange').daterangepicker({
        startDate: start,
        endDate: end,
        ranges: {
           'Today': [moment(), moment()],
           'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
           'Last 7 Days': [moment().subtract(6, 'days'), moment()],
           'Last 30 Days': [moment().subtract(29, 'days'), moment()],
           'This Month': [moment().startOf('month'), moment().endOf('month')],
           'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
        }
    }, cb);

    cb(start, end);

});
</script>
@endif
@endif

@endsection