@section('title','Purchase return - POS')
@extends('layouts.master')
@section('style')
{{-- {{Html::style('assets/public_css/index.css')}} --}}
<style>
td form {
    display: inline-block;
}
body {
    counter-reset: serial-number;
}
table#example23 tr td:first-child:before {
    counter-increment: serial-number;
    content: counter(serial-number);
}
</style>
@endsection


@section('content')

<div class="page-wrapper">

    <div class="container-fluid">
        <div class="row page-titles">
            <div class="col-md-5 align-self-center">
                <h4 class="text-themecolor title"><span id="heading_field"></span> {{trans('label.Purchase Return')}} </h4>
            </div>

        </div>
                    @if (Session::has('message'))
                       <h6 style="background: #20c997; color: red; text-align: center; padding: 5px; border-radius: 5px;">{{ Session::get('message') }}</h6>
                    @endif
                    @if (Session::has('errormessage'))
                    <h6 style="background: red; color: #fff; text-align: center; padding: 5px; border-radius: 5px;">{{ Session::get('errormessage') }}</h6>
                    @endif
        <div class="row">
            <div class="col-12">
                <div class="card-body-wrapper">
                        <div style=" text-align: center; margin-left: 20%; padding: 10px;">
                            <form action="{{url('purchase-return-invoice')}}" method="post" class="form-group">
                                {{ csrf_field()}}
                                <div class="col-md-6">
                                    <div class="input-group mb-3">
                                      <input type="text" name="searchInvoice" placeholder="{{trans('label.Purchase Invoice Number')}} " class="form-control" id="mouse_enter" autocomplete="off" required="required" aria-label="Recipient's username" aria-describedby="basic-addon2">
                                      <div class="input-group-append">

                                        <input type="submit" class="btn btn-success" name="sumbit" value="{{trans('label.search')}}" class="form-control">
                                      </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                </div>
            </div>
        </div>

    </div>
</div>

@endsection


@section('script')

<!--stickey kit -->
{{Html::script('assets/js/sticky-kit.min.js')}}
{{Html::script('assets/js/jquery.sparkline.min.js')}}
<!-- This is data table -->
{{Html::script('assets/js/jquery.dataTables.min.js')}}
<!-- start - This is for export functionality only -->
{{Html::script('assets/js/dataTables.buttons.min.js')}}
{{Html::script('assets/js/buttons.flash.min.js')}}
{{Html::script('assets/js/jszip.min.js')}}
{{Html::script('assets/js/pdfmake.min.js')}}
{{Html::script('assets/js/vfs_fonts.js')}}
{{Html::script('assets/js/buttons.html5.min.js')}}
{{Html::script('assets/js/buttons.print.min.js')}}
{{Html::script('assets/custom_js/crud.js')}}
{{Html::script('assets/custom_js/datatable.js')}}
{{Html::script('assets/custom_js/add_more.js')}}

<!-- end - This is for export functionality only -->
{{-- {{Html::script('assets/public_js/index.js')}} --}}
<script>
    $('#mouse_enter').keypress(function(event){
        var keycode = (event.keyCode ? event.keyCode : event.which);
        if(keycode == '13'){}
        event.stopPropagation();
    });
</script>

@endsection