@section('title','Purchase Order - POS')
@extends('layouts.master')
@section('style')
{{Html::style('assets/css/jquery-ui.css')}}
<style>
td form {
  display: inline-block;
}
.right_side_panel {
  background: #999;
  padding: 15px 7px;
  color: #fff;
}
.sales_price{
  display: none;
}

.btn-transparent.active {
  border-color: #6692B0;
  background-color: #6692B0;
  color: #FFF;
}
td form {
  display: inline-block;
}
.right_side_panel {
  background: #999;
  padding: 15px 7px;
  color: #fff;
}
.table thead th {
  border-bottom: 2px solid transparent;
}
.table td, .table th {
  border-top: 1px solid transparent;
}
.product-name {
  font-size: 17px;
  font-weight: bold;
}
.single-product .media {
  position: relative;
}
.single-product .media[aria-expanded='false'] .arrow:before {
  content: "\f105";
  font-family: 'FontAwesome';
  position: absolute;
  left: 0px;
  top: 0px;
  color: #555;
  font-size: 16px;
}
.single-product .media[aria-expanded='true'] .arrow:before {
  content: "\f107";
  font-family: 'FontAwesome';
  position: absolute;
  left: -3px;
  top: 0px;
  color: #555;
  font-size: 16px;
}
#selected_customer {
  padding: 10px;
}
#selected_customer .customer_link {
  font-size: 16px;
  font-weight: bold;
  cursor: pointer;
}

/* table style start */
.table td {
  padding: 0;
}
.table td input {
  width: 100%;
  border: 0;
  padding: 0 10px;
}
.table thead th {
  border-bottom: 2px solid #dee2e6;
  border-top: 1px solid #dee2e6;
}
/* table style end */


/* modal style start */
.modal-header {
  border-bottom: 0;
  padding-bottom: 0;
}
.info-heading .title {
  border-bottom: 1px solid #ddd;
}
.info-heading .info .lebel {
  color: #6692B0;
}
/* modal style end */
.card.shadow {
  box-shadow: 0 .5rem 1rem rgba(0,0,0,.15)!important;
}
.modal-content {
  border: 1px solid rgba(27, 142, 19, 0.94);
}
.modal-header {
  border-bottom: 1px solid rgba(27, 142, 19, 0.94);
}
.modal-footer {
  border-top: 1px solid rgba(27, 142, 19, 0.94);
}
</style>
@endsection


@section('content')


<div class="page-wrapper">
  <div class="container-fluid">
    <div class="row">
     <div class="col-md-6">
      <h4 class="m-0 pt-2">{{trans('label.Create Order')}} </h4>
    </div>
    <div class="col-md-6">
      <a href="{{ url('preorder-invoice')}}" class="btn btn-success pull-right">{{trans('label.Order List')}}</a>
    </div>

    <div class="col-md-12 mt-2">
      @if (Session::has('message'))
      <h6 style="background: #20c997; color: #fff; text-align: center; padding: 5px; border-radius: 5px;">{{ Session::get('message') }}</h6>
      @endif
      <div class="card shadow">
        <div class="card-body">
          @include('purchase-order.preorder_added_form')
          @include('supplier.add_supplier')
        </div>
      </div>
    </div>

    <div class="col-md-12">

      <form action="{{ url('pre-order')}}"  method="post">
        {{csrf_field()}}
        <div class="card shadow">
          <div class="card-body">
            <div class="row">
              <div class="col-md-3">
                <div class="form-group">
                  <label for="suplier_field">{{trans('label.Supplier')}} <span class="text-danger">*</span></label>
                  <div class="addon">
                    <span class="addonadd user-plus" data-toggle="modal" data-target="#addNewSupplier" title="{{trans('label.Add New Supplier')}}" style="cursor: pointer; color: #339c6a;"></span>
                    <input type="text" attr_url="{{url('supplier_for_purchase')}}" name="supplierAutofill" id="supplierAutofill" class="form-control" required="required">
                    <span class="inner-badge default right">F9</span>
                  </div>
                </div>
              </div>
              <div class="col-md-2">
                <div class="form-group text-center">
                  <label for="ref_no">{{trans('label.Ref. No')}} </label>
                  <div class="controls">
                    <input autocomplete="off" type="text" name="ref_no" id="ref_no" class="form-control">
                  </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="form-group text-center">
                  <label for="transection_type">{{trans('label.Payment Type')}} <span class="text-danger">*</span></label>
                  <div class="controls">
                    <select class="form-control text-right" name="transection_term_id" id="transection_type">

                      @if($payments)
                      @foreach($payments as $payment )
                      <option value="{{ $payment->id }}">{{$payment->name}}</option>
                      @endforeach
                      @endif
                    </select>
                  </div>
                </div>
              </div>
              <div class="col-md-2">
                <div class="form-group text-center">
                  <label>{{trans('label.Preorder Date')}}<span class="text-danger">*</span></label>
                  <div class="controls">
                    <input type="text" class="form-control datepicker" name="preorder_date" required="required">
                  </div>
                </div>
              </div>
              <div class="col-md-2">
                <div class="form-group text-center">
                  <label>{{trans('label.Expected Delivery Date')}}<span class="text-danger">*</span></label>
                  <div class="controls">
                    <input type="text" class="form-control datepicker" name="expected_delivery_date" required="required">
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="card shadow">
          <div class="card-body">
            <div class="searching-items">
              <div class="table-responsive">
                <table id="example23" class="tem_product display nowrap table table-hover table-striped table-bordered view_data_table" cellspacing="0" width="100%">
                  <thead>
                    <tr>
                      <th>{{trans('label.Select')}}</th>
                      <th>{{trans('label.Product Name')}}</th>
                      <th>{{trans('label.Price_unit')}}</th>
                      <th>{{trans('label.Quantity')}}</th>
                      <th>{{trans('label.VAT')}} %</th>
                      <th>{{trans('label.Discount')}} %</th>
                      <th>{{trans('label.Net Price_unit')}}</th>
                      <th>{{trans('label.Net Cost Total')}}</th>
                      <th>{{trans('label.Action')}}</th>
                    </tr>
                  </thead>
                  <tbody>
                    @forelse($info as $temop)
                    <tr>
                      @php
                      $discount_rate=$temop->discount_rate ?? 0;
                      $vat_rate=$temop->vat_rate ?? 0;
                      $line_discount=(float)($temop->cost_price*($discount_rate/100));
                      $line_vat=(float)($temop->cost_price-$line_discount)*($vat_rate/100);
                      $total_vat=(float)($line_vat*$temop->qty);
                      $total_discount=(float)($line_discount*$temop->qty);
                      $net_price=($temop->cost_price-$line_discount+$line_vat);
                      $total_net_price=(float)($net_price*$temop->qty);
                      @endphp
                      <td>
                        <input type="hidden" name="l_gross_cost_price[]" value='{{(float)($temop->cost_price*$temop->qty)}}' class="change_purchae l_gross_cost_price">
                        <input type="hidden" name="id[]" value="{{$temop->id}}">
                        <input type='checkbox' class="orderItemSelect" name='barcode[]'>
                        <input type="hidden" value="{{$total_discount}}" class="change_purchae lt_discount" >
                        <input type="hidden" class="change_purchae lt_vat" value="{{$total_vat}}" >
                      </td>
                      <td>
                        <input type='hidden' readonly="" name='product_id[]'' value='{{$temop->product_id}}' ><input type="text"  name="name[]" value="{{$temop->product->name ?? null}}">
                      </td>
                      <td>
                        <input type='number'  step='any' min="0" autocomplete="off" name='cost_price[]' value='{{$temop->cost_price}}' class="change_purchae l_cost_price text-right" >
                      </td>
                      <td>
                        <input type='number'  step='any' min="0" autocomplete="off" name="qty[]" arrt_qty='qty' class="qty_unit change_purchae text-right" value='{{$temop->qty}}' >
                      </td>
                      <td>
                        <input type='number'  step='any' min="0" autocomplete="off" name='vat_rate[]' value='{{$vat_rate}}' class="change_purchae l_vat_rate text-right">
                      </td>
                      <td>
                        <input type='number'  step='any' min="0" autocomplete="off" name='discount_rate[]' value='{{$discount_rate}}' class="change_purchae l_discount_rate text-right" >
                      </td>
                      <td>
                        <input type='number'  step='any' min="0" autocomplete="off" name="net_cost_price[]" value="{{$net_price}}" class="change_purchae lt_net_cost_price text-right">
                      </td>

                      <td>
                        <input type='number'  step='any' min="0" autocomplete="off" name='net_line_total[]' value='{{$total_net_price}}' class='change_purchae total_net_price text-right' readonly="readonly">
                      </td>
                      <td class="text-center">
                        <a class="delpurchaseTemp" href="{{url('delete_temp',$temop->id)}}">
                          <i class='fa fa-trash' aria-hidden='true'></i>
                        </a>
                      </td>
                    </tr>

                    @empty
                    @endforelse
                  </tbody>
                </table>
              </div>
              <div class="row Grand_purchase_total">
                <div class="col-md-3">
                  <div class="form-group text-center">
                    <label for="gross_amount" >{{trans('label.Gross total')}} </label>
                    <input type="text" name="gross_amount"  class="form-control text-right gross_total" value="" readonly="readonly" required="required">
                  </div>
                </div>
                <div class="col-md-3">
                  <div class="form-group text-center">
                    <label for="discount_total">{{trans('label.Discount total')}}</label>
                    <input type="number" step="any" name="gross_discount"  class="form-control text-right discount_total" value="" required="required" readonly="readonly">
                  </div>
                </div>
                <div class="col-md-3">
                  <div class="form-group text-center">
                    <label for="vat_total">{{trans('label.Vat Total')}}</label>
                    <input type="number" step="any" name="gross_vat_amount"  class="form-control text-right vat_total" value="" required="required" readonly="readonly">
                  </div>
                </div>

                <div class="col-md-3">
                  <div class="form-group text-center">
                    <label for="net_amount">{{trans('label.Net Amount')}}</label>
                    <input type="number" step="any" name="net_amount"  class="form-control text-right net_amount" value="" required="required" readonly="readonly">
                  </div>
                </div>
                    <!-- <div class="col-md-2">
                    <div class="form-group ">
                      <label for="paid_amount">Paid Amount <span class="text-danger"></span></label>
                      <input type="hidden" step="any" name="payment_amount"  class="form-control text-right paid_amount" value="0">
                    </div>
                  </div> -->

                  <div class="col-md-12">
                    <button type="submit" id="product_purchase_preorder" class="btn btn-success btn-lg pull-right" style="width: 100%" >{{trans('label.Order')}} <span class="inner-badge">F2</span></button>
                  </div>
                  <input type="hidden" name="suplier" id="suplier_field" class="form-control">
                  <input type="hidden" step="any" name="payment_amount"  class="form-control text-right paid_amount" value="0">
                </div>
            </div>
          </div>
        </div>
      </form>

    </div>
    </div>
  </div>
</div>



@endsection


@section('script')

<!--stickey kit -->
{{Html::script('assets/js/sticky-kit.min.js')}}
{{Html::script('assets/js/jquery.sparkline.min.js')}}
<!-- This is data table -->
{{Html::script('assets/js/jquery.dataTables.min.js')}}
<!-- start - This is for export functionality only -->
{{Html::script('assets/js/dataTables.buttons.min.js')}}
{{Html::script('assets/js/buttons.flash.min.js')}}
{{Html::script('assets/js/jszip.min.js')}}
{{Html::script('assets/js/pdfmake.min.js')}}
{{Html::script('assets/js/vfs_fonts.js')}}
{{Html::script('assets/js/buttons.html5.min.js')}}
{{Html::script('assets/js/buttons.print.min.js')}}
{{Html::script('assets/custom_js/crud.js')}}
{{Html::script('assets/custom_js/jquery-ui.js')}}
{{Html::script('assets/custom_js/pur_pre_order.js')}}
{{Html::script('assets/custom_js/add_more.js')}}

<!-- end - This is for export functionality only -->
{{-- {{Html::script('assets/public_js/index.js')}} --}}

<script>
  $(document).ready(function($) {
    $( ".datepicker" ).datepicker({
      changeMonth: true,
      changeYear: true,
      dateFormat : 'yy-mm-dd'
    }).datepicker("setDate", new Date());
  });
</script>

@endsection