@section('title','Purchase Order - POS')
@extends('layouts.master')
@section('style')
{{-- {{Html::style('assets/public_css/index.css')}} --}}
<style>
td form {
  display: inline-block;
}
.right_side_panel {
  background: #999;
  padding: 15px 7px;
  color: #fff;
}
.sales_price{
  display: none;
}

.btn-transparent.active {
  border-color: #6692B0;
  background-color: #6692B0;
  color: #FFF;
}
td form {
  display: inline-block;
}
.right_side_panel {
  background: #999;
  padding: 15px 7px;
  color: #fff;
}
.product-name {
  font-size: 17px;
  font-weight: bold;
}
.single-product .media {
  position: relative;
}
.single-product .media[aria-expanded='false'] .arrow:before {
  content: "\f105";
  font-family: 'FontAwesome';
  position: absolute;
  left: 0px;
  top: 0px;
  color: #555;
  font-size: 16px;
}
.single-product .media[aria-expanded='true'] .arrow:before {
  content: "\f107";
  font-family: 'FontAwesome';
  position: absolute;
  left: -3px;
  top: 0px;
  color: #555;
  font-size: 16px;
}
#selected_customer {
  padding: 10px;
}
#selected_customer .customer_link {
  font-size: 16px;
  font-weight: bold;
  cursor: pointer;
}

/* table style start */
.table td {
  padding: 0;
}
.table td input {
  width: 100%;
}
/* table style end */
.table td input {
  width: 100%;
  border: 0;
  text-align: center;
  padding: 0 6px;
}

/* modal style start */
.modal-header {
  border-bottom: 0;
  padding-bottom: 0;
}
.info-heading .title {
  border-bottom: 1px solid #ddd;
}
.info-heading .info .lebel {
  color: #6692B0;
}
/* modal style end */
.card.shadow {
  box-shadow: 0 .5rem 1rem rgba(0,0,0,.15)!important;
}
</style>
@endsection


@section('content')


<div class="page-wrapper">
    <div class="container-fluid">

        <div class="row">
          <div class="col-md-6">
            <button type="button" class="btn btn-transparent default_btn active" style="margin-right: 5px;"><i class="fa fa-check-circle" aria-hidden="true"></i> {{trans('label.Default')}} <span class="inner-badge transparent-btn"> {{trans('label.Alt+N')}}</span></button>
            <button type="button" class="btn btn-transparent barcode_btn"><i class="fa fa-barcode"></i> {{trans('label.Barcode')}} <span class="inner-badge transparent-btn"> {{trans('label.Alt+b')}}</span></button>
          </div>

          <div class="col-md-6">
            <a href="{{ url('purchase-invoice')}}" class="btn btn-success pull-right">{{trans('label.Product Recieved List')}}</a>
          </div>

          <div class="col-md-12 mt-2">
            @if (Session::has('message'))
          <h6 style="background: #20c997; color: #fff; text-align: center; padding: 5px; border-radius: 5px;">{{ Session::get('message') }}</h6>
           @endif

            @if (Session::has('error_message'))
          <h6 style="background: red; color: #fff; text-align: center; padding: 5px; border-radius: 5px;">{{ Session::get('error_message') }}</h6>
           @endif

            <div class="card shadow">
              <div class="card-body">
                @include('purchase-order.manual_added_form')
                @include('purchase-order.barcode_added_form')
                @include('purchase-order.add_product')
              </div>
            </div>
          </div>

            <div class="col-md-12">


              <form action="{{ url('process-order')}}"  method="post">
              {{csrf_field()}}
                <div class="card shadow">
                  <div class="card-body">
                    <div class="row">
                      <div class="col-md-3">
                          <div class="form-group">
                              <label for="suplier_field">{{trans('label.Opening Item')}} <span class="text-danger">*</span></label>
                              <div class="controls">
                                  <select class="form-control" name="suplier" id="suplier_field">
                                      <option value="000">{{trans('label.Opening Item')}}</option>
                                  </select>

                              </div>
                          </div>
                      </div>
                      <div class="col-md-3">
                          <div class="form-group">
                              <label for="ref_no">{{trans('label.Ref. No')}} <span class="text-danger"></span></label>
                              <div class="controls">
                                <input autocomplete="off" type="text" name="ref_no" id="ref_no" class="form-control">
                              </div>
                          </div>
                      </div>
                      <div class="col-md-3">
                        <div class="form-group">
                            <label for="transection_type">{{trans('label.Payment Type')}} <span class="text-danger">*</span></label>
                            <div class="controls">
                                <select class="form-control" name="transection_term_id" id="transection_type">

                                    @if($payments)
                                        @foreach($payments as $payment )
                                                <option value="{{ $payment->id }}">{{$payment->name}}</option>
                                        @endforeach
                                    @endif
                                </select>
                            </div>
                        </div>
                      </div>

                      <div class="col-md-3">
                        <div class="form-group">
                            <label>{{trans('label.Date')}}<span class="text-danger">*</span></label>
                            <div class="controls">
                              <input type="text" name="purchase_date" id="purchase_date" value="" autocomplete="off" class="form-control datepicker">
                            </div>
                          </div>
                      </div>
                    </div>
                  </div>
                </div>
                <div class="card shadow">
                  <div class="card-body">
                    <div class="searching-items">
                        <div class="table-responsive">
                            <table id="example23" class="tem_product display nowrap table table-hover table-striped table-bordered view_data_table" cellspacing="0" width="100%">
                                <thead>
                                    <tr>
                                        <th>{{trans('label.Barcode')}}</th>
                                        <th>{{trans('label.Product Name')}}</th>
                                        <th>{{trans('label.Price_unit')}}</th>
                                        <th>{{trans('label.Quantity')}}</th>
                                        <th>{{trans('label.VAT')}} %</th>
                                        <th>{{trans('label.Discount')}} %</th>
                                        <th>{{trans('label.Net Price_unit')}}</th>
                                        <th>{{trans('label.Sales Price_unit')}}</th>
                                        <th>{{trans('label.Net Cost Total')}}</th>
                                        <th>{{trans('label.Action')}}</th>
                                    </tr>
                                </thead>

                                <tbody>
                                  @forelse($info as $temop)

                                  <tr>
                                    @php
                                    $discount_rate=$temop->discount_rate ?? 0;
                                    $vat_rate=$temop->vat_rate ?? 0;
                                    $line_discount=(float)($temop->cost_price*($discount_rate/100));
                                    $line_vat=(float)($temop->cost_price-$line_discount)*($vat_rate/100);
                                    $total_vat=(float)($line_vat*$temop->qty);
                                    $total_discount=(float)($line_discount*$temop->qty);
                                    $net_price=($temop->cost_price-$line_discount+$line_vat);
                                    $total_net_price=(float)($net_price*$temop->qty);
                                    @endphp
                                  <td>
                                    <input type="hidden" name="l_gross_cost_price[]" value='{{(float)($temop->cost_price*$temop->qty)}}' class="change_purchae l_gross_cost_price">
                                    <input type="hidden" name="id" value="{{$temop->id}}">
                                    <input type='text' readonly="readonly" name='barcode[]'value='{{$temop->barcode}}'>
                                    <input type="hidden" value="{{$total_discount}}" class="change_purchae lt_discount" >
                                    <input type="hidden" class="change_purchae lt_vat" value="{{$total_vat}}" >
                                  </td>
                                  <td>
                                    <input type='hidden' readonly="" name='product_id[]'' value='{{$temop->product_id}}' >
                                    <?php
if (isset($productProfile)) {
	foreach ($productProfile as $product) {
		if ($product->id == $temop->product_id) {?>
                                      <input type='text' readonly="" name='name[]'' value='{{$product->name}}' >
                                    <?php }
	}
}

?>

                                  </td>
                                  <td>
                                    <input type='text' name='cost_price[]' value='{{$temop->cost_price}}' class="change_purchae l_cost_price text-right">
                                  </td>
                                  <td>
                                    <input type="text" name="qty[]" arrt_qty='qty' class="qty_unit change_purchae text-right" value='{{$temop->qty}}'></td><td><input type='text' name='vat_rate[]' value='{{$vat_rate}}' class="change_purchae l_vat_rate text-right">
                                    </td>
                                    <td>
                                      <input type='text' name='discount_rate[]' value='{{$discount_rate}}' class="change_purchae l_discount_rate text-right">
                                    </td>
                                    <td>
                                      <input type="text" name="net_cost_price[]" value="{{$net_price}}" class="change_purchae lt_net_cost_price text-right">
                                    </td>
                                  <td>
                                    <input type='text' name='sales_price[]' value='{{$temop->sales_price}}' class="change_purchae lt_sales_price text-right">
                                  </td>
                                  <td>
                                    <input type='text' name='net_line_total[]' value='{{$total_net_price}}' class='change_purchae total_net_price text-right'>
                                  </td>
                                  <td class="text-center">
                                    <a href="{{url('deleteTempFromOpeningItem',$temop->id)}}" onclick="return confirm('Are you sure want to delete ?')"><i class='fa fa-trash' aria-hidden='true'></i></a>
                                  </td>
                                  </tr>
                                  @empty
                                  @endforelse
                                </tbody>
                            </table>
                        </div>
                       <div class="row Grand_purchase_total">
                         <div class="col-md-2">
                          <div class="form-group">
                                          <label for="gross_amount">{{trans('label.Gross total')}} <span class="text-danger">*</span></label>
                                          <input type="text" name="gross_amount"  class="form-control gross_total text-right" value="" readonly="readonly" required="required">
                            </div>
                         </div>
                         <div class="col-md-2">
                            <div class="form-group">
                                            <label for="discount_total">{{trans('label.Discount total')}} <span class="text-danger">*</span></label>
                                            <input type="number" step="any" name="gross_discount"  class="form-control discount_total text-right" value="" required="required" readonly="readonly">
                            </div>
                         </div>
                         <div class="col-md-2">
                          <div class="form-group">
                                          <label for="vat_total">{{trans('label.VAT Total')}} <span class="text-danger">*</span></label>
                                          <input type="number" step="any" name="gross_vat_amount"  class="form-control vat_total text-right text-right" value="" required="required" readonly="readonly">
                          </div>
                         </div>

                        <div class="col-md-2">
                          <div class="form-group">
                            <label for="net_amount">{{trans('label.Net Amount')}} <span class="text-danger">*</span></label>
                            <input type="number" step="any" name="net_amount"  class="form-control net_amount text-right" value="" required="required" readonly="readonly">
                          </div>
                        </div>
                        <div class="col-md-2" >
                          <div class="form-group">
                            <label for="paid_amount">{{trans('label.Paid Amount')}} <span class="text-danger"></span></label>
                            <input type="number" step="any" name="payment_amount"  class="form-control paid_amount text-right" value="0" >
                          </div>
                        </div>
                        <div class="col-md-2">
                           <div class="form-group">
                              <label for="due_amount">{{trans('label.Due Amount')}} <span class="text-danger">*</span></label>
                              <input type="number" step="any" name="Due_amount"  class="form-control due_amount text-right" value="0" required="required" readonly="readonly">
                            </div>
                        </div>
                        <div class="col-md-12">

                          <button type="submit" id="product_received" class="btn btn-success btn-lg pull-right" style="width: 100%">
                            {{trans('label.Add to inventory')}} <span class="inner-badge">{{trans('label.F2')}}</span>
                          </button>
                        </div>
                       </div>
                    </div>
                  </div>
                </div>
              </form>
            </div>
            </div>
        </div>
    </div>
</div>

<!-- Customer info modal start -->
<div class="modal fade customer_info_modal" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <div class="text-center">
          <h3 class="modal-title" id="">Macrosoft</h3>
          <small><a href="" style="color: #6692B0;">All Customers</a></small> -
          <small style="color: #6692B0;">Last shopped 15 days ago</small>
          <div class="small-divider"></div>
        </div>
        <div class="info-heading">
          <div class="title"><h5 class="mb-2"><strong>Customer info</strong></h5></div>
          <div class="info mt-2">
            <div class="row">
              <div class="col-md-4">
                <div class="lebel">Customer code</div>
              </div>
              <div class="col-md-8">
                1207798
              </div>
              <div class="col-md-4">
                <div class="lebel">Sex</div>
              </div>
              <div class="col-md-8">
                Male
              </div>
              <div class="col-md-4">
                <div class="lebel">Date of birth</div>
              </div>
              <div class="col-md-8">
                11-06-2018
              </div>

            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
<!-- Customer info modal end -->

@endsection


@section('script')

<!--stickey kit -->
{{Html::script('assets/js/sticky-kit.min.js')}}
{{Html::script('assets/js/jquery.sparkline.min.js')}}
<!-- This is data table -->
{{Html::script('assets/js/jquery.dataTables.min.js')}}
<!-- start - This is for export functionality only -->
{{Html::script('assets/js/dataTables.buttons.min.js')}}
{{Html::script('assets/js/buttons.flash.min.js')}}
{{Html::script('assets/js/jszip.min.js')}}
{{Html::script('assets/js/pdfmake.min.js')}}
{{Html::script('assets/js/vfs_fonts.js')}}
{{Html::script('assets/js/buttons.html5.min.js')}}
{{Html::script('assets/js/buttons.print.min.js')}}
{{Html::script('assets/custom_js/crud.js')}}

<link rel="stylesheet" href="//code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">


<script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
{{Html::script('assets/custom_js/purchase_order.js')}}
{{Html::script('assets/custom_js/add_more.js')}}

<!-- end - This is for export functionality only -->
{{-- {{Html::script('assets/public_js/index.js')}} --}}

<script>
  $(document).ready(function($) {
    $( ".datepicker" ).datepicker({
      changeMonth: true,
      changeYear: true,
      dateFormat : 'yy-mm-dd'
    }).datepicker("setDate", new Date());
  });
</script>



@endsection