@section('title','Purchase Order - POS')
@extends('layouts.master')
@section('style')

<style>
td form {
  display: inline-block;
}
.right_side_panel {
  background: #999;
  padding: 15px 7px;
  color: #fff;
}
.sales_price{
  display: none;
}

.btn-transparent.active {
  border-color: #6692B0;
  background-color: #6692B0;
  color: #FFF;
}
td form {
  display: inline-block;
}
.right_side_panel {
  background: #999;
  padding: 15px 7px;
  color: #fff;
}
.product-name {
  font-size: 17px;
  font-weight: bold;
}
.single-product .media {
  position: relative;
}
.single-product .media[aria-expanded='false'] .arrow:before {
  content: "\f105";
  font-family: 'FontAwesome';
  position: absolute;
  left: 0px;
  top: 0px;
  color: #555;
  font-size: 16px;
}
.single-product .media[aria-expanded='true'] .arrow:before {
  content: "\f107";
  font-family: 'FontAwesome';
  position: absolute;
  left: -3px;
  top: 0px;
  color: #555;
  font-size: 16px;
}
#selected_customer {
  padding: 10px;
}
#selected_customer .customer_link {
  font-size: 16px;
  font-weight: bold;
  cursor: pointer;
}

/* table style start */
.table td {
  padding: 0;
}
.table td input {
  width: 100%;
}
/* table style end */
.table td input {
  width: 100%;
  border: 0;
  text-align: center;
  padding: 0 6px;
}

/* modal style start */
.modal-header {
  border-bottom: 0;
  padding-bottom: 0;
}
.info-heading .title {
  border-bottom: 1px solid #ddd;
}
.info-heading .info .lebel {
  color: #6692B0;
}
/* modal style end */
.card.shadow {
  box-shadow: 0 .5rem 1rem rgba(0,0,0,.15)!important;
}
.modal-content {
    border: 1px solid rgba(27, 142, 19, 0.94);
}
.modal-header {
    border-bottom: 1px solid rgba(27, 142, 19, 0.94);
}
.modal-footer {
    border-top: 1px solid rgba(27, 142, 19, 0.94);
}
</style>
@endsection


@section('content')


<div class="page-wrapper">
  <div class="container-fluid">
    <div class="row">
      <div class="col-md-6">
        <button type="button" class="btn btn-transparent default_btn active" style="margin-right: 5px;"><i class="fa fa-check-circle" aria-hidden="true"></i> {{trans('label.Default')}} <span class="inner-badge transparent-btn"> Alt+N</span></button>
        <button type="button" class="btn btn-transparent barcode_btn"><i class="fa fa-barcode"></i> {{trans('label.Barcode')}} <span class="inner-badge transparent-btn">Alt+b</span></button>
      </div>
      <div class="col-md-6">
        <a href="{{ url('purchase-invoice')}}" class="btn btn-success pull-right">{{trans('label.Product Recieved List')}}</a>
      </div>

      <div class="col-md-12 mt-2">
          @if (Session::has('message'))
          <h6 style="background: #20c997; color: #fff; text-align: center; padding: 5px; border-radius: 5px;">{{ Session::get('message') }}</h6>
          @endif
        <div class="card shadow">
          <div class="card-body">
            @include('purchase-order.manual_added_form')
            @include('purchase-order.barcode_added_form')
            @include('purchase-order.add_product')
            @include('supplier.add_supplier')

          </div>
        </div>
      </div>

      <div class="col-md-12">
        <form action="{{ url('process-order')}}"  method="post">
        {{csrf_field()}}
          <div class="card shadow">
            <div class="card-body">
              <div class="row">
                <div class="col-md-3">
                    <div class="form-group">
                      <label for="suplier_field">{{trans('label.Supplier')}} <span class="text-danger">*</span></label>
                      <div class="addon badge-wrapper">
                      <span class="addonadd user-plus" data-toggle="modal" data-target="#addNewSupplier" title="{{trans('label.Add New Supplier')}}" style="cursor: pointer; color: #339c6a;"></span>
                      <input type="text" attr_url="{{url('supplier_for_purchase')}}" name="supplierAutofill" id="supplierAutofill" class="form-control" required="required">
                      <span class="inner-badge default right">{{trans('label.F9')}}</span>
                      <input type="hidden" name="suplier" id="suplier_field" class="form-control">
                      </div>
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="form-group">
                        <label for="ref_no">{{trans('label.Supplier Ref')}} : <span class="text-danger"></span></label>
                        <div class="controls">
                          <input autocomplete="off" type="text" name="ref_no" id="ref_no" class="form-control text-right">
                        </div>
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="form-group text-center">
                        <label for="preorder_ref">{{trans('label.Order Ref')}} : </label>
                        <div class="controls">
                          <input autocomplete="off" type="text" name="preorder_ref" id="preorder_ref" class="form-control">
                        </div>
                    </div>
                </div>
                <div class="col-md-2">
                  <div class="form-group">
                      <label for="transection_type">{{trans('label.Payment Type')}} <span class="text-danger">*</span></label>
                      <select class="form-control text-right" name="transection_term_id" id="transection_type">
                        @if($payments)
                            @foreach($payments as $payment )
                                    <option value="{{ $payment->id }}">{{$payment->name}}</option>
                            @endforeach
                        @endif
                      </select>
                  </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>{{trans('label.Purchase date')}}<span class="text-danger">*</span></label>
                        <div class="controls">
                          <input type="text" name="purchase_date" id="purchase_date" value="" autocomplete="off" class="form-control datepicker">
                        </div>
                    </div>
                </div>
              </div>
            </div>
          </div>
          <div class="card shadow">
            <div class="card-body">
              <div class="searching-items">
                <div class="table-responsive">
                  <table id="example23" class="tem_product display nowrap table table-hover table-striped table-bordered view_data_table" cellspacing="0" width="100%">
                    <thead>
                      <tr>
                        <th>{{trans('label.Barcode')}}</th>
                        <th>{{trans('label.Product Name')}}</th>
                        <th>{{trans('label.Price_unit')}}</th>
                        <th>{{trans('label.Quantity')}}</th>
                        <th>{{trans('label.VAT')}} %</th>
                        <th>{{trans('label.Discount')}} %</th>
                        <th>{{trans('label.Net Price_unit')}}</th>
                        <th>{{trans('label.Sales Price_unit')}}</th>
                        <th>{{trans('label.Net Cost Total')}}</th>
                        <th>{{trans('label.Action')}}</th>
                      </tr>
                    </thead>
                    <tbody>
                      @forelse($info as $temop)
                      <tr>
                        @php
                        $discount_rate=$temop->discount_rate ?? 0;
                        $vat_rate=$temop->vat_rate ?? 0;
                        $line_discount=(float)($temop->cost_price*($discount_rate/100));
                        $line_vat=(float)($temop->cost_price-$line_discount)*($vat_rate/100);
                        $total_vat=(float)($line_vat*$temop->qty);
                        $total_discount=(float)($line_discount*$temop->qty);
                        $net_price=($temop->cost_price-$line_discount+$line_vat);
                        $total_net_price=(float)($net_price*$temop->qty);
                        @endphp
                        <td>
                          <input type="hidden" name="l_gross_cost_price[]" value='{{(float)($temop->cost_price*$temop->qty)}}' class="change_purchae l_gross_cost_price">
                          <input type="hidden" name="id[]" value="{{$temop->id}}"><input type='text' readonly="readonly" name='barcode[]'value='{{$temop->barcode}}'>
                          <input type="hidden" value="{{$total_discount}}" class="change_purchae lt_discount" >
                          <input type="hidden" class="change_purchae lt_vat" value="{{$total_vat}}" >
                        </td>
                        <td>
                          <input type='hidden' readonly="" name="product_id[]'" value='{{$temop->product_id}}' ><input type="text"  name="name[]" value="{{$temop->product->name ?? null}}">
                        </td>
                        <td>
                          <input type='number' step='any' name='cost_price[]' value='{{$temop->cost_price}}' class="change_purchae l_cost_price text-right" autocomplete="off">
                        </td>
                        <td>
                          <input type="number" step='any' name="qty[]" arrt_qty='qty' class="qty_unit change_purchae text-right" value='{{$temop->qty}}' min="1" autocomplete="off">
                        </td>
                        <td>
                          <input type='number' step='any' name='vat_rate[]' value='{{$vat_rate}}' class="change_purchae l_vat_rate text-right" min="0" autocomplete="off">
                        </td>
                        <td>
                          <input type='number' step='any' name='discount_rate[]' value='{{$discount_rate}}' class="change_purchae l_discount_rate text-right" min="0" autocomplete="off">
                        </td>
                        <td>
                          <input type="number" step='any' name="net_cost_price[]" value="{{$net_price}}" class="change_purchae lt_net_cost_price text-right" min="0">
                        </td>
                      <td>
                          <input type='number' step='any' name='sales_price[]' value='{{$temop->sales_price}}' class="change_purchae lt_sales_price text-right" min="0" autocomplete="off">
                        </td>
                        <td>
                          <input type='number' step='any' name='net_line_total[]' value='{{$total_net_price}}' class='change_purchae total_net_price text-right' min="0">
                        </td>
                        <td class="text-center">
                          <a class="delpurchaseTemp" href="{{url('delete_temp',$temop->id)}}">
                            <i class='fa fa-trash' aria-hidden='true'></i>
                          </a>
                        </td>
                      </tr>
                      @empty
                      @endforelse
                    </tbody>
                  </table>
                </div>
                <div class="row Grand_purchase_total">
                    <div class="col-md-2">
                      <div class="form-group">
                        <label for="gross_amount">{{trans('label.Gross total')}} <span class="text-danger">*</span></label>
                        <input type="text" name="gross_amount"  class="form-control text-right gross_total" value="" readonly="readonly" required="required">
                      </div>
                    </div>
                    <div class="col-md-2">
                      <div class="form-group">
                        <label for="discount_total">{{trans('label.Discount total')}} <span class="text-danger">*</span></label>
                        <input type="number" step="any" name="gross_discount"  class="form-control text-right discount_total" value="" required="required" readonly="readonly">
                      </div>
                    </div>
                    <div class="col-md-2">
                      <div class="form-group">
                        <label for="vat_total">{{trans('label.Vat Total')}} <span class="text-danger">*</span></label>
                        <input type="number" step="any" name="gross_vat_amount"  class="form-control text-right vat_total" value="" required="required" readonly="readonly">
                      </div>
                    </div>

                    <div class="col-md-2">
                      <div class="form-group">
                        <label for="net_amount">{{trans('label.Net Amount')}} <span class="text-danger">*</span></label>
                        <input type="number" step="any" name="net_amount"  class="form-control text-right net_amount" value="" required="required" readonly="readonly">
                      </div>
                    </div>
                   <div class="col-md-2">
                    <div class="form-group">
                      <label for="paid_amount">{{trans('label.Paid Amount')}} <span class="text-danger"></span></label>
                      <div class="badge-wrapper">
                        <input type="number" step="any" name="payment_amount"  class="form-control text-right paid_amount" value="0">
                        <span class="inner-badge default left">{{trans('label.Alt+a')}}</span>
                      </div>
                    </div>
                   </div>
                   <div class="col-md-2">
                      <div class="form-group">
                        <label for="due_amount">{{trans('label.Due Amount')}} <span class="text-danger">*</span></label>
                        <input type="number" step="any" name="Due_amount"  class="form-control text-right due_amount" value="0" required="required" readonly="readonly">
                      </div>
                   </div>
                   <div class="col-md-12">
                    <div class="form-group">
                      <input type="text" name="common_notes" class="form-control" equired="required"  placeholder="Write Purchase  Notes">
                    </div>

                    </div>
                    <div class="col-md-12">
                      <button type="submit" id="product_received" class="btn btn-success btn-lg pull-right" style="width: 100%" >{{trans('label.Product Received')}} <span class="inner-badge">{{trans('label.F2')}}</span></button>


                    </div>
                </div>
              </div>
            </div>
          </div>
        </form>
      </div>


    </div>
  </div>
</div>


<!-- ============================================================== -->
<!-- footer -->
<!-- ============================================================== -->
<footer class="footer">
  <div class="container-fluid pb-0">
    <div class="row">
      <div class="col-md-2 logo-side">
        <div class="media">
          <img src="{{ asset('assets/images/leftjoin_logo.png') }}" alt="leftjoin logo" class="" style="">
          <div class="media-body navbar-dark">
            <h4 class="navbar-brand">{{trans('label.Quick Sale')}}</h4>
          </div>
        </div>
      </div>
      <div class="col-md-10 pl-4">
        <div class="row">
        <div class="col-md-3 key-shotcut">
          <span>{{trans('label.Insert Total Pay Amount')}} <span class="inner-badge">{{trans('label.Alt+a')}}</span></span>
        </div>
        </div>
      </div>
    </div>

  </div>
</footer>
<!-- ============================================================== -->
<!-- End footer -->
<!-- ============================================================== -->
@endsection


@section('script')

<!--stickey kit -->
{{Html::script('assets/js/sticky-kit.min.js')}}
{{Html::script('assets/js/jquery.sparkline.min.js')}}
<!-- This is data table -->
{{Html::script('assets/js/jquery.dataTables.min.js')}}
<!-- start - This is for export functionality only -->
{{Html::script('assets/js/dataTables.buttons.min.js')}}
{{Html::script('assets/js/buttons.flash.min.js')}}
{{Html::script('assets/js/jszip.min.js')}}
{{Html::script('assets/js/pdfmake.min.js')}}
{{Html::script('assets/js/vfs_fonts.js')}}
{{Html::script('assets/js/buttons.html5.min.js')}}
{{Html::script('assets/js/buttons.print.min.js')}}
{{Html::script('assets/custom_js/crud.js')}}
{{Html::script('assets/custom_js/add_more.js')}}

<link rel="stylesheet" href="//code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">


<script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
{{Html::script('assets/custom_js/purchase_order.js')}}
<script>
  $('#bq_id').on('keydown', function(event) {
    if(event.which == 17 || event.which == 74 )
      event.preventDefault();
     //setTimeout(function(){ $('#bq_id').unbind() }, 100);
  });
</script>
<!-- end - This is for export functionality only -->
{{-- {{Html::script('assets/public_js/index.js')}} --}}

<script>
  $(document).ready(function($) {
    $( ".datepicker" ).datepicker({
      changeMonth: true,
      changeYear: true,
      timeInput: true,
      dateFormat : 'yy-mm-dd'
    }).datepicker("setDate", new Date());
  });
</script>


@endsection


