<div class="row">
    <div class="col-12">
        @if ($errors->any())
        <div class="alert alert-danger">
            <ul>
                @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
        @endif
        @if(!empty($info))
        <form  method="post" action="{{url('product-price-list',$info->id)}}">
            {{csrf_field()}}
            <input type="hidden" name="_method" value="PUT">
            <input type="hidden" name="id" value="{{$info->id}}">
            <div class="row">
                <div class="col-md-3">
                    <div class="form-group">
                        <h5>{{trans('label.Lot No')}} <span class="text-danger"></span></h5>
                        <div class="controls">
                            <input type="text" class="form-control text-right" value="{{$info->order_id}}" readonly="readonly">
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <h5>{{trans('label.Product Id')}} <span class="text-danger"></span></h5>
                        <div class="controls">
                            <input type="text" class="form-control text-right" value="{{$info->product_id}}" readonly="readonly">
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <h5>{{trans('label.Barcode')}} <span class="text-danger"></span></h5>
                        <div class="controls">
                            <input type="text" class="form-control text-right" value="{{$info->barcode}}" readonly="readonly">
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <h5>{{trans('label.Product name')}} <span class="text-danger"></span></h5>
                        <div class="controls">
                            <input type="text" class="form-control" value="{{$info->ProductProfile->name ?? null}}" readonly="readonly">
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <h5>{{trans('label.Cost Price')}} <span class="text-danger"></span></h5>
                        <div class="controls">
                            <input type="text" class="form-control text-right" value="{{$info->cost_price}}" readonly="readonly">
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <h5>{{trans('label.Sales Price')}} <span class="text-danger"></span></h5>
                        <div class="controls">
                            <input type="text" class="form-control text-right" value="{{$info->sales_price}}" name="sales_price" >
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <h5>{{trans('label.Status')}} <span class="text-danger"></span></h5>
                        <div class="controls">
                            <select name="status" class="form-control">
                                <option value="1" @if($info->status=='Active') selected="selected" @endif>{{trans('label.Active')}}</option>
                                <option value="0" @if($info->status=='Inactive') selected="selected" @endif>{{trans('label.Inactive')}}</option>
                            </select>
                        </div>
                    </div>
                </div>

                <div class="col-md-3">
                    <div class="text-xs-right w-100" style="margin-top: 27px">
                        <button type="submit" class="btn btn-success w-100">{{trans('label.Update')}}</button>
                    </div>
                </div>
            </div>
        </form>
        @endif
    </div>
</div>