@section('title','Sales Price - POS')
@extends('layouts.master')
@section('style')
{{-- {{Html::style('assets/public_css/index.css')}} --}}
<style>
td form {
    display: inline-block;
}
body {
    counter-reset: serial-number;
}
table#example23 tr td:first-child:before {
    counter-increment: serial-number;
    content: counter(serial-number);
}
</style>
@endsection


@section('content')

<div class="page-wrapper">

    <div class="container-fluid">
        <div class="row page-titles">
            <div class="col-md-5 align-self-center">
                <h4 class="text-themecolor title"><span id="heading_field"></span> {{trans('label.Sales Price')}}</h4>
            </div>
            <div class="col-md-7 align-self-center text-right">
                <div class="d-flex justify-content-end align-items-center">
                    <div class="add_form_btn" style="text-align: right"><button class="btn btn-primary add"><i class="fa fa-plus-circle" aria-hidden="true"></i> {{trans('label.Add New')}} </button><button class="btn btn-danger remove" style="display: none;"><i class="fa fa-times" aria-hidden="true"></i> {{trans('label.Back')}}</button></div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-12">
                <div class="card-body-wrapper">
                    <div id="add_form" style="display: none;">
                        @include('price.create')
                    </div>

                    <div id='table_position'>
                    @include('price.table')
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>

@endsection


@section('script')

<!--stickey kit -->
{{Html::script('assets/js/sticky-kit.min.js')}}
{{Html::script('assets/js/jquery.sparkline.min.js')}}
<!-- This is data table -->
{{Html::script('assets/js/jquery.dataTables.min.js')}}
<!-- start - This is for export functionality only -->
{{Html::script('assets/js/dataTables.buttons.min.js')}}
{{Html::script('assets/js/buttons.flash.min.js')}}
{{Html::script('assets/js/jszip.min.js')}}
{{Html::script('assets/js/pdfmake.min.js')}}
{{Html::script('assets/js/vfs_fonts.js')}}
{{Html::script('assets/js/buttons.html5.min.js')}}
{{Html::script('assets/js/buttons.print.min.js')}}
{{Html::script('assets/custom_js/crud.js')}}
{{Html::script('assets/custom_js/datatable.js')}}

<!-- end - This is for export functionality only -->
{{-- {{Html::script('assets/public_js/index.js')}} --}}
<link rel="stylesheet" href="//code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">


<script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>

<!-- end - This is for export functionality only -->
{{-- {{Html::script('assets/public_js/index.js')}} --}}

<script>
$( function() {

    var name = [];

        $.ajax({
            url: 'search-unset-price',
            type: 'GET',
            dataType: 'json',
            success: function(result){
                console.log(result);
                var obj = result;
                for (var i = 0; i < obj.length; i++) {
                name.push(obj[i].id+" - " + obj[i].name );
                }
            }
        })



    $("#product").autocomplete({
        source:  name,
        select: function (event, ui) {
            var product_info = ui.item.value;
                var info =  product_info.split('-');
                var id = info[0].trim();
                var name = info[1].trim();
                $("#product_id").val(id);

        }

        });



});
</script>
@endsection