@section('title','Account Sub-Category')
@extends('layouts.master')
@section('style')
<style>
td form {
    display: inline-block;
}
body {
    counter-reset: serial-number;
}
table#example23 tr td:first-child:before {
    counter-increment: serial-number;
    content: counter(serial-number);
}
</style>
@endsection


@section('content')

<div class="page-wrapper">
    <div class="container-fluid">
        <div class="row page-titles">

            <div class="col-md-5 align-self-center">
                <h4 class="text-themecolor title"><span id="heading_field"></span> {{trans('label.Voucher List')}}</h4>
            </div>
            <div class="col-md-7 align-self-center text-right">
                <div class="row">
                    <div class="col-md-4">
                        <a class="form-control btn btn-primary " href="{{ url('receive-journal') }}">{{ trans('label.Receive Voucher') }}</a>
                    </div>
                    <div class="col-md-4">
                        <a  class="form-control btn btn-primary "href="{{ url('payment-journal') }}">{{ trans('label.Payment Voucher') }}</a>
                    </div>
                    <div class="col-md-4">
                        <a class="form-control btn btn-primary " href="{{ url('adjustment-journal') }}">{{ trans('label.Adjustment Journal') }}</a>
                    </div>
                </div>
            </div>
        </div>


        <div class="row">
            <div class="col-12">
                @if (Session::has('message'))
                  <h6 style="background: #20c997; color: #fff; text-align: center; padding: 5px; border-radius: 5px;">{{ Session::get('message') }}</h6>
                  @endif
                  
                <div class="card-body-wrapper">
                    
                     <div id="search_form">
                       
                            @include('journal.search')
                        
                    </div>
                       

                    <div id='table_position'>
                        <div class="table-responsive">
                            <table id="example23" class="display nowrap table table-hover table-striped table-bordered" cellspacing="0" width="100%">
                                <thead>
                                    <tr>
                                        <th>{{trans('label.ID')}}</th>
                                        <th>{{trans('label.Voucher No')}}</th>
                                        <th>{{trans('label.Voucher Type')}}</th>
                                        <th>{{trans('label.Date')}}</th>
                                        <th>{{trans('label.Naration')}}</th>
                                        <th>{{trans('label.Amount')}}</th>
                                        <th>{{trans('label.User')}}</th>
                                       
                                        <th>{{trans('label.Action')}}</th>
                                       
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($info as $key=>$in_value)
                                    <tr>

                                        <td class="text-right"></td>
                                        <td>{{ $in_value->vm_no?? '' }}</td>
                                        <td>{{ $in_value->vm_type ?? '' }}</td>
                                        <td>{{ $in_value->vm_date ?? '' }}</td>
                                        <td>
                                           {{ $in_value->vm_naration ?? '' }}
                                           
                                        </td>
                                        <td>{{ $in_value->vm_amount ?? '' }}</td>
                                        <td>{{ $in_value->vm_user ?? '' }}</td>
                                        
                                        <td>
                                            <a href="{{ url('voucher-print',$in_value->id) }}">Print</a>
                                            @if(Auth::user()->position_id ==1)
                                            <a href="{{url('journal',$in_value->id)}}"  title="edit" class="btn btn-light btn-sm"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></a>
                                            @endif
                                            @if(Auth::user()->position_id ==1)
                                            <a onclick="return confirm('Are You sure ?')" href="{{url('journal-delete',$in_value->id)}}"  title="edit" class="btn btn-light btn-sm"><i class="fa fa-trash" aria-hidden="true"></i></a>
                                            @endif
                                        </td>
                                    </tr>
                                @empty
                                @endforelse
                                </tbody>
                            </table>
                            </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>

@endsection


@section('script')

<!--stickey kit -->
{{Html::script('assets/js/sticky-kit.min.js')}}
{{Html::script('assets/js/jquery.sparkline.min.js')}}
<!-- This is data table -->
{{Html::script('assets/js/jquery.dataTables.min.js')}}
<!-- start - This is for export functionality only -->
{{Html::script('assets/js/dataTables.buttons.min.js')}}
{{Html::script('assets/js/buttons.flash.min.js')}}
{{Html::script('assets/js/jszip.min.js')}}
{{Html::script('assets/js/pdfmake.min.js')}}
{{Html::script('assets/js/vfs_fonts.js')}}
{{Html::script('assets/js/buttons.html5.min.js')}}
{{Html::script('assets/js/buttons.print.min.js')}}
{{Html::script('assets/custom_js/crud.js')}}
{{Html::script('assets/custom_js/datatable.js')}}
{{Html::script('assets/custom_js/add_more.js')}}

<!-- end - This is for export functionality only -->
{{-- {{Html::script('assets/public_js/index.js')}} --}}
<script>
</script>

@endsection