  @section('title','Adjustment Voucher')
  @extends('layouts.master')
  @section('style')
  
  {{Html::style('assets/css/jquery-ui.css')}}
  {{Html::style('assets/css/select2.min.css')}}
   {{Html::style('assets/css/custom_search.css')}} //for select 2 css
  @endsection


  @section('content')

  <div class="page-wrapper">

      <div class="container-fluid">
          <div class="row page-titles">
          <div class="col-md-6">
            <h5>{{ trans('label.Adjustment Voucher') }}</h5>
          </div>
          <div class="col-md-6" style="text-align: right;">
            
             <a class="btn btn-success"  href="{{url('voucher-list')}}">  {{trans('label.Voucher list')}} </a>
            <button onclick="goBack()" class="btn btn-transparent-border"><i class="fa fa-chevron-left" aria-hidden="true"></i> {{trans('label.Back')}}</button>
          </div>
        </div>

        <div class="row">
          <div class="col-md-12">
            <div class="card">
               @if (Session::has('message'))
                         <h6 style="background: #20c997; color: #fff; text-align: center; padding: 5px; border-radius: 5px;">{{ Session::get('message') }}</h6>
                      @endif
              @if(Session::has('errormessage'))
                         <h6 style="background: red; color: #fff; text-align: center; padding: 5px; border-radius: 5px;">{{ Session::get('errormessage') }}</h6>
              @endif
              <div class="card-body">
                <div class="container-fluid">
                  <form action="{{url('receive-journal')}}" method="post" >
                    {{csrf_field()}}
                    @if($errors->any())
                    <h4 class="alert alert-warning" >{{$errors->first()}}</h4>
                    @endif
                    <div class="form-group row mt-3">
                      <label for="date" class="col-sm-3 col-form-label">{{trans('label.Date')}}</label>
                      <div class="col-sm-9">
                            <input type="date" name="vm_date" class="form-control" required >
                      </div>
                    </div>
                    <div class="form-group row">
                      <label for="debit_id" class="col-sm-3 col-form-label">{{trans('label.Debit Account')}}</label>
                          <div class="col-sm-9" id="credit_id">
                            <select name="debit_id" class="form-control js-example-responsive">
                                 <option value="">{{trans('label.Select Debit Account')}}</option>
                                  @forelse($others as $account)
                                  <option value="{{ $account->id  }}">{{ $account->name ?? '' }}</option>
                                @empty
                                @endforelse
                            </select>
                            <input type="hidden" name="lg_voucher_type" value="JV">
                      </div>
                    </div>
                    <div class="form-group row mt-3">
                      <label for="credit_id" class="col-sm-3 col-form-label">{{trans('label.Credit Account')}}</label>
                      <div class="col-sm-9">
                            <select name="credit_id"  class="form-control js-example-responsive">
                              <option value="">Select Credit Account</option>
                              @forelse($others as $account)
                                <option value="{{ $account->id  }}">{{ $account->name ?? '' }}</option>
                              @empty
                              @endforelse
                            </select>
                      </div>
                    </div>
                    

                    
                    
                    <div class="form-group row">
                        <label for="amount" class="col-sm-3 col-form-label">{{trans('label.Amount')}} </label>
                        <div class="col-sm-9">
                           <input type="number" value="{{old('amount')}}" name="amount" step="any" autocomplete="off" required="required" class="form-control">
                      </div>
                    </div>
                    <div class="form-group row">
                        <label for="note" class="col-sm-3 col-form-label">{{trans('label.Note')}} </label>
                        <div class="col-sm-9">
                           <input type="text" name="note" value="{{old('note')}}"  autocomplete="off" required="required" class="form-control">
                      </div>
                    </div>

                    <div class="row">
                      <div class="col-md-12">
                        <div class="pull-right">
                          <input type="submit" class="btn btn-success" value="{{trans('label.Received')}}" >
                        </div>
                      </div>
                    </div>

                  </form>
                </div>
              </div>
            </div>
          </div>

        </div>
  </div>

  @endsection


  @section('script')
  {{Html::script('assets/js/select2.min.js')}}

  <script>
     $(document).ready(function($) {
      $(".js-example-responsive").select2({
        width: '100%'
      });
    });
  </script>

  @endsection