@section('title','Purchase Order - POS')
@extends('layouts.master')
@section('style')
{{Html::style('assets/css/index.css')}}
<style>
td form {
  display: inline-block;
}
.right_side_panel {
  background: #999;
  padding: 15px 7px;
  color: #fff;
}
.square-box {
  background:#a2d8a4;
  padding: 44px;
  text-align: center;
  margin: 10px;
}
.divider {
  border-bottom: 2px solid #ddd;
  width: 50%;
  margin: 30px auto;
}
.sm-box-wrapper {
  text-align: center;
}
.sm-boxes {
  background-color: #fff;
  border: 1px solid #ddd;
  box-shadow: 0 1px 2px 0 rgba(90, 91, 95, 0.25);
  padding: 29px;
  position: relative;
  top: 0;
  transition: all 0.3s ease-in-out 0s;
  border: 1px solid #ddd;
  margin: 0 6px;
  text-align: center;
  display: inline-block;
  border-radius: 50%;
  margin-bottom: 48px;
}
.sm-boxes:hover {
  background-color: #18bd6f82;
  box-shadow: 0px 16px 22px 0px rgba(90, 91, 95, 0.3);
  top: -5px;
  border:1px solid #18bd6f82;
}

.sm-boxes small {
  position: absolute;
  width: 100%;
  left: 0;
  bottom: -36px;
  font-weight: bold;
  color: #555;
}
.sm-boxes:hover small {
  color: #18bd6f82;
}
</style>
@endsection


@section('content')

<div class="page-wrapper">
  <div class="row">
    <div class="col-sm-3">
      <div class="box-wrapper">
        <div class="boxes">
          <a href="{{url('product-category')}}">
            <img src="{{ asset('assets/images/icons/category.png') }}" alt="Product Category">
            <span>{{trans('label.Product Category')}}</span>
          </a>
        </div>
      </div>
    </div>

    <div class="col-sm-3">
      <div class="box-wrapper">
        <div class="boxes">
          <a href="{{url('product-profile')}}">
            <img src="{{ asset('assets/images/icons/product-profile.png') }}" alt="Product Profile">
            <span>{{trans('label.Product Profile')}}</span>
          </a>
        </div>
      </div>
    </div>

    <div class="col-sm-3">
      <div class="box-wrapper">
        <div class="boxes">
          <a href="{{url('supplier')}}">
            <img src="{{ asset('assets/images/icons/supplier.png') }}" alt="Supplier">
            <span>{{trans('label.Supplier')}}</span>
          </a>
        </div>
      </div>
    </div>

    <div class="col-sm-3">
      <div class="box-wrapper">
        <div class="boxes">
          <a href="{{url('customer')}}">
            <img src="{{ asset('assets/images/icons/customer.png') }}" alt="Customer">
            <span>{{trans('label.Customer')}}</span>
          </a>
        </div>
      </div>
    </div>
  </div>
  <div class="divider"></div>


  <div class="row">
    <div class="col-sm-12">
      <div class="sm-box-wrapper">
        <div class="sm-boxes">
          <a title="Supplier Category" href="{{url('supplier-category')}}">
            <img src="{{ asset('assets/images/icons/supplier-profile.png') }}" alt="Supplier Category">
            <small>{{trans('label.Supplier Category')}}</small>
          </a>
        </div>

        <div class="sm-boxes">
          <a title="Customer Category" href="{{url('customer-category')}}">
            <img src="{{ asset('assets/images/icons/category.png') }}" alt="Customer Category">
            <small>{{trans('label.Customer Category')}}</small>
          </a>

        </div>


        <div class="sm-boxes">
          <a title="Employee Role" href="{{url('role')}}">
            <img src="{{ asset('assets/images/icons/position.png') }}" alt="user role /position">
            <small>{{trans('label.User Role/Position')}}</small>
          </a>

        </div>

        <div class="sm-boxes">
          <a title="Employee" href="{{url('employee')}}">
            <img src="{{ asset('assets/images/icons/employee.png') }}" alt="Employee">
            <small>{{trans('label.Employee')}}</small>
          </a>

        </div>

        <div class="sm-boxes">
          <a title="Shipper Profile" href="{{url('shipper-profile')}}">
            <img src="{{ asset('assets/images/icons/supplier-profile.png') }}" alt="Shipper Profile">
            <small>{{trans('label.Shipper Profile')}}</small>
          </a>

        </div>

        <div class="sm-boxes">
          <a title="Transaction Terms" href="{{url('transaction-terms')}}">
            <img src="{{ asset('assets/images/icons/transaction.png') }}" alt="Transaction Terms">
            <small>{{trans('label.Transaction Terms')}}</small>
          </a>

        </div>

        <div class="sm-boxes">
          <a title="VAT" href="{{url('vat')}}">
            <img src="{{ asset('assets/images/icons/vat.png') }}" alt="VAT">
            <small>{{trans('label.VAT')}}</small>
          </a>

        </div>

        <div class="sm-boxes">
          <a title="Store House Location" href="{{url('store-house-location')}}">
            <img src="{{ asset('assets/images/icons/map-location.png') }}" alt="Store House Location">
            <small>{{trans('label.Store House Location')}}</small>
          </a>

        </div>

        <div class="sm-boxes">
          <a title="Measurment" href="{{url('measurment')}}">
            <img src="{{ asset('assets/images/icons/measurement.png') }}" alt="Measurment">
            <small>{{trans('label.Measurment')}}</small>
          </a>

        </div>

      </div>
    </div>
  </div>
</div>

@endsection


@section('script')

<!--stickey kit -->
{{Html::script('assets/js/sticky-kit.min.js')}}
{{Html::script('assets/js/jquery.sparkline.min.js')}}
<!-- This is data table -->
{{Html::script('assets/js/jquery.dataTables.min.js')}}
<!-- start - This is for export functionality only -->
{{Html::script('assets/js/dataTables.buttons.min.js')}}
{{Html::script('assets/js/buttons.flash.min.js')}}
{{Html::script('assets/js/jszip.min.js')}}
{{Html::script('assets/js/pdfmake.min.js')}}
{{Html::script('assets/js/vfs_fonts.js')}}
{{Html::script('assets/js/buttons.html5.min.js')}}
{{Html::script('assets/js/buttons.print.min.js')}}
{{Html::script('assets/custom_js/crud.js')}}

<link rel="stylesheet" href="//code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">


<script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
@endsection