@section('title','Expense - POS')
@extends('layouts.master')
@section('style')
{{-- {{Html::style('assets/public_css/index.css')}} --}}
<style>
td form {
    display: inline-block;
}
body {
    counter-reset: serial-number;
}
table#example23 tr td:first-child:before {
    counter-increment: serial-number;
    content: counter(serial-number);
}
.card-body {
  -webkit-box-shadow: 0 1px 15px 0px #999;
  -moz-box-shadow: 0 1px 15px 0px #999;
  box-shadow: 0 1px 15px 0px #999;
}
</style>
@endsection


@section('content')

<div class="page-wrapper">

    <div class="container-fluid">
        <div class="row page-titles">
            <div class="align-self-center">
                <h4 class="text-themecolor title"><span id="heading_field"></span> {{trans('label.Expense Transection Reverse')}}</h4>
            </div>
        </div>

      <div class="row">
        <div class="col-md-8">
          <div class="card">
             @if (Session::has('message'))
                       <h6 style="background: #20c997; color: #fff; text-align: center; padding: 5px; border-radius: 5px;">{{ Session::get('message') }}</h6>
                    @endif
            <div class="card-body">
              <div class="container-fluid">
                <form action="{{url('expenseTransectionReverse')}}" method="post" >
                  {{csrf_field()}}
                  @if($errors->any())
                  <h4 class="alert alert-warning" >{{$errors->first()}}</h4>
                  @endif

                  <div class="form-group row">
                    <label for="receiveableAccount" class="col-sm-2 col-form-label">{{trans('label.Expense No')}}</label>
                    <div class="col-sm-10">
                      <input type="text" name="receiveableAccount" id="receiveableAccount" class="form-control" placeholder="{{trans('label.Expense Name')}}" required="required" value="exp -{{ $ExpenseProfile->id}} - {{ $ExpenseProfile->name}}">
                      <input type="hidden" name="account_number" id="account_number" class="form-control" value="{{ $ExpenseProfile->id}}"  required="required" style="width: 300px !important;" >
                    </div>

                  </div>
                  <div class="form-group row">
                    <label for="ref_no" class="col-sm-2 col-form-label">{{trans('label.Media Person')}}</label>
                    <div class="col-sm-10">
                      <input type="text" name="findMediaPerson" id="findMediaPerson" autocomplete="off" class="form-control" placeholder="{{trans('label.Media Persone')}}" required="required"  value="emp - {{$User->id}} - {{$User->name}}">

                      <input type="hidden" name="ref_no" id="ref_no" autocomplete="off" class="form-control text-right" placeholder="{{trans('label.Media Persone')}}" required="required" value="{{$User->id}}" >
                    </div>
                  </div>
                  <div class="form-group row">
                    <label for="recevedAmount" class="col-sm-2 col-form-label">{{trans('label.Expense Amount')}}</label>
                    @php
                    $expense=($ExpenseAccount->debit ?? 0);
                    @endphp
                    <div class="col-sm-10">
                      <input type="number" name="recevedAmount" id="recevedAmount" class="form-control" placeholder="{{trans('label.Amount')}}" autocomplete="off" required="required" value="{{$expense}}" min="0">
                    </div>
                  </div>
                  <div class="form-group row">
                    <label for="note" class="col-sm-2 col-form-label">{{trans('label.Note')}}</label>
                    <div class="col-sm-10">
                      <input type="text" name="note" id="note" class="form-control" placeholder="{{trans('label.Note')}}" required="required" autocomplete="off" value="{{ $ExpenseAccount->description}}">
                    </div>
                  </div>

                  <div class="row">
                    <div class="col-md-12">
                      <div class="pull-right">
                        <input type="submit" class="btn btn-success" value="{{trans('label.Expense Reverse')}}" >
                      </div>
                    </div>
                  </div>
                </form>
              </div>
            </div>
          </div>
        </div>

      </div>
</div>

@endsection


@section('script')

<!--stickey kit -->
{{Html::script('assets/js/sticky-kit.min.js')}}
{{Html::script('assets/js/jquery.sparkline.min.js')}}
<!-- This is data table -->
{{Html::script('assets/js/jquery.dataTables.min.js')}}
<!-- start - This is for export functionality only -->
{{Html::script('assets/js/dataTables.buttons.min.js')}}
{{Html::script('assets/js/buttons.flash.min.js')}}
{{Html::script('assets/js/jszip.min.js')}}
{{Html::script('assets/js/pdfmake.min.js')}}
{{Html::script('assets/js/vfs_fonts.js')}}
{{Html::script('assets/js/buttons.html5.min.js')}}
{{Html::script('assets/js/buttons.print.min.js')}}
{{Html::script('assets/custom_js/crud.js')}}
{{Html::script('assets/custom_js/datatable.js')}}

<!-- end - This is for export functionality only -->
{{-- {{Html::script('assets/public_js/index.js')}} --}}
<link rel="stylesheet" href="//code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">


<script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>



@endsection