@section('title','Expenses - POS')
@extends('layouts.master')
@section('style')
{{-- {{Html::style('assets/public_css/index.css')}} --}}
<style>
td form {
    display: inline-block;
}
body {
    counter-reset: serial-number;
}
table#example23 tr td:first-child:before {
    counter-increment: serial-number;
    content: counter(serial-number);
}
</style>
@endsection


@section('content')

<div class="page-wrapper">

    <div class="container-fluid">


        <div class="row">
            <div class="col-12">
                    @if (Session::has('message'))
                       <h6 style="background: #20c997; color: #fff; text-align: center; padding: 5px; border-radius: 5px;">{{ Session::get('message') }}</h6>
                    @endif
                <div class="card-body-wrapper">
                        <div class="text-center">
                            <h2>{{trans('label.Reverse Entry For Expenses')}}</h2>

                        <form action="{{url('expense-reverse-details')}}" method="post" class="form-group">
                            {{csrf_field()}}
                            <input class="col-md-4 form-control" type="text" name="transectionId" placeholder="{{trans('label.Expense Transection Number')}}" required="required">
                            <input type="submit" name="submit" value="Search" class="btn btn-success">
                        </form>
                        </div>
                </div>
            </div>
        </div>

    </div>
</div>

@endsection


@section('script')

<!--stickey kit -->
{{Html::script('assets/js/sticky-kit.min.js')}}
{{Html::script('assets/js/jquery.sparkline.min.js')}}
<!-- This is data table -->
{{Html::script('assets/js/jquery.dataTables.min.js')}}
<!-- start - This is for export functionality only -->
{{Html::script('assets/js/dataTables.buttons.min.js')}}
{{Html::script('assets/js/buttons.flash.min.js')}}
{{Html::script('assets/js/jszip.min.js')}}
{{Html::script('assets/js/pdfmake.min.js')}}
{{Html::script('assets/js/vfs_fonts.js')}}
{{Html::script('assets/js/buttons.html5.min.js')}}
{{Html::script('assets/js/buttons.print.min.js')}}
{{Html::script('assets/custom_js/crud.js')}}
{{Html::script('assets/custom_js/datatable.js')}}
{{Html::script('assets/custom_js/add_more.js')}}

<!-- end - This is for export functionality only -->
{{-- {{Html::script('assets/public_js/index.js')}} --}}
<script>
</script>

@endsection