<div class="row">
    <div class="col-md-12">
        <div class="text-center">
            @if(!empty($info))
            @if($info->image!=null){{Html::image('storage/image/employee_image/' .$info->image, 'Employee image',array('width'=>'100px','height'=>'100px','class'=>'image image-responsive'))}}@endif
            @endif
        </div>
    </div>
    <div class="col-12">
        @if ($errors->any())
        <div class="alert alert-danger">
            <ul>
                @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
        @endif
        @if(!empty($info))
        <form class="m-t-40" novalidate method="post" action="{{url('employee-update')}}" enctype="multipart/form-data">
            {{csrf_field()}}
            <input type="hidden" name="id" value="{{$info->id}}">
            <div class="row">
                <div class="col-md-3">
                    <div class="form-group">
                        <h5>{{trans('label.Employee Name')}} <span class="text-danger">*</span></h5>
                        <div class="controls">
                            <input type="text" name="name" class="form-control" value="{{$info->name}}" required="required">
                        </div>
                    </div>
                </div>
                <div class="col-md-3">

                    <div class="form-group">
                        <h5>{{trans('label.Position')}} <span class="text-danger">*</span></h5>
                        <div class="controls">

                            <select name="position" class="form-control" required="required">
                                <option value="">{{trans('label.Select')}}</option>
                                @forelse($employeePosition as $position)
                                <option value="{{$position->id}}" @if($info->position_id==$position->id) selected="selected" @endif>{{$position->name}}</option>
                                @empty
                                @endforelse
                            </select>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <h5>{{trans('label.Email')}} <span class="text-danger">*</span></h5>
                        <div class="controls">
                            <input type="email" name="email" class="form-control" value="{{$info->email}}" required="required">
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <h5>{{trans('label.Address')}} <span class="text-danger">*</span></h5>
                        <div class="controls">
                            <input type="text" name="address" class="form-control"  required="required" value="{{$info->address}}">
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <h5>{{trans('label.Phone')}} <span class="text-danger">*</span></h5>
                        <div class="controls">
                            <input type="text" name="phone" class="form-control" value="{{$info->phone}}" required="required">
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <h5>{{trans('label.Password')}} <span class="text-danger">*</span></h5>
                        <div class="controls">
                            <input type="password" name="password" class="form-control"  required="required">
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <h5>{{trans('label.Confirm Password')}} <span class="text-danger">*</span></h5>
                        <div class="controls">
                            <input type="password" name="password_confirmation" class="form-control"  required="required">
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <h5>{{trans('label.Status')}} <span class="text-danger">*</span></h5>
                        <div class="controls">

                            <select name="status" class="form-control" required="required">
                                <option value="1" @if($info->status=='Active') selected @endif>{{trans('label.Active')}}</option>
                                <option value="0" @if($info->status=='Inactive') selected @endif>{{trans('label.Inactive')}}</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <h5>{{trans('label.Photo')}} <span class="text-danger">*</span></h5>
                        <div class="controls">
                            <input type="file" name="image" class="form-control"  required="required">
                        </div>
                    </div>
                </div>
                <div class="col-md-3">

                    <div class="text-xs-right" style="margin-top: 27px;">
                        <button type="submit" class="btn btn-success">{{trans('label.Update')}}</button>
                    </div>
                </div>
            </div>
        </form>
        @endif
    </div>
</div>