<div class="row">
    <div class="col-12">
        @if ($errors->any())
            <div class="alert alert-danger">
                <ul>
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
        <form class="mt-3" method="post" action="{{url('employee')}}" enctype="multipart/form-data">
            {{csrf_field()}}
                    <div class="row">
                    <div class="col-lg-2 col-md-3 col-sm-6">
                            <div class="form-group">
                                        <h5>{{trans('label.Employee Name')}} <span class="text-danger">*</span></h5>
                                        <div class="controls">
                                            <input type="text" name="name" class="form-control" value="{{ old('name') }}" required="required">
                                        </div>
                            </div>
                    </div>
                    <div class="col-lg-2 col-md-3 col-sm-6">
                        <h5>{{trans('label.Role')}} <span class="text-danger">*</span></h5>
                        <div class="input-group">
                            <select name="position" class="form-control" required="required">
                              <option value="">{{trans('label.Select')}}</option>
                              @forelse($employeePosition as $position)
                              <option value="{{$position->id}}">{{$position->name}}</option>
                              @empty
                              @endforelse
                            </select>
                            <div class="input-group-append">
                                <a href="{{url('role')}}" class="btn btn-outline-secondary btn-sm add_more" type="button" ><i class="fa fa-plus" style="color:#339c6a"></i></a>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-2 col-md-3 col-sm-6">
                        <div class="form-group">
                            <h5>{{trans('label.Email')}} <span class="text-danger">*</span></h5>
                            <div class="controls">
                                <input type="email" name="email" class="form-control" value="{{ old('email') }}" required="required">
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-2 col-md-3 col-sm-6">
                        <div class="form-group">
                            <h5>{{trans('label.Phone')}} <span class="text-danger">*</span></h5>
                            <div class="controls">
                                <input type="text" name="phone" class="form-control" value="{{ old('phone') }}" required="required">
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-2 col-md-3 col-sm-6">
                        <div class="form-group">
                            <h5>{{trans('label.Password')}} <span class="text-danger">*</span></h5>
                            <div class="controls">
                                <input type="password" name="password" class="form-control"  required="required">
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-2 col-md-3 col-sm-6">
                        <div class="form-group">
                            <h5>{{trans('label.Confirm Password')}} <span class="text-danger">*</span></h5>
                            <div class="controls">
                                <input type="password" name="password_confirmation" class="form-control"  required="required">
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-5 col-md-6 col-sm-12">
                        <div class="form-group">
                            <h5>{{trans('label.Address')}} <span class="text-danger">*</span></h5>
                            <div class="controls">
                                <input type="text" name="address" class="form-control"  required="required" value="{{old('address')}}">
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-2 col-md-3 col-sm-6">
                            <div class="form-group">
                                <h5>{{trans('label.Status')}} <span class="text-danger">*</span></h5>
                                <div class="controls">

                                    <select name="status" class="form-control" required="required">
                                        <option value="1" @if(!is_null(old('status'))&& old('status')=='1') selected @endif>{{trans('label.Active')}}</option>
                                        <option value="0" @if(!is_null(old('status'))&& old('status')=='0') selected @endif>{{trans('label.Inactive')}}</option>
                                    </select>
                                </div>
                            </div>
                    </div>
                    <div class="col-lg-3 col-md-4 col-sm-6">
                        <div class="form-group">
                                <h5>{{trans('label.Photo')}} <span class="text-danger">*</span></h5>
                                <div class="controls">
                                    <input type="file" name="image" class="form-control">
                                </div>
                            </div>
                    </div>
                    <div class="col-lg-2 col-md-3 col-sm-6">

                            <div class="text-xs-right w-100" style="margin-top: 27px;float: left;">
                                <button type="submit" class="btn btn-success w-48">{{trans('label.Submit')}}</button>
                                <button type="reset" class="btn btn-inverse w-48">{{trans('label.Cancel')}}</button>
                            </div>
                    </div>
                </div>
                        </form>
    </div>
</div>