@section('title','Daily report - POS')
@extends('layouts.master')
@section('style')
{{-- {{Html::style('assets/css/index.css')}} --}}
<style>
.page-wrapper {
  margin-left: 90px !important;
}
/* bootstrap custom nav-tabs start */
.nav-tabs-wrapper {
  background: #fff;
  margin-right: 10px;
  min-height: 70vh;
  -webkit-box-shadow: 0 1px 15px 0px #999;
  -moz-box-shadow: 0 1px 15px 0px #999;
  box-shadow: 0 1px 15px 0px #999;
}
.nav-tabs {
  border-bottom: 0;
}
.nav-tabs .nav-item {
  width: 20%;
  border-right: 2px solid #ddd;
  text-align: center;
  list-style: none;
}
.nav-tabs .nav-item:last-child{
  border-right: 0;
}
.nav-tabs .nav-link {
  color: #555;
  border-bottom: 5px solid #ddd;
  transition: all .5s;
}
.nav-tabs .nav-link:focus, .nav-tabs .nav-link:hover {
  border-bottom: 5px solid #339c6a;
  color: #339c6a;
}
.nav-tabs .nav-item.show .nav-link, .nav-tabs .nav-link.active {
  border-bottom: 5px solid #339c6a;
  color: #339c6a;
}
@media only screen and (max-width: 600px) {
  .nav-tabs .nav-item {
    width: 33%;
  }
}
@media only screen and (max-width: 380px) {
  .nav-tabs .nav-item {
    width: 100%;
  }
}
/* bootstrap custom nav-tabs end */
</style>
@endsection


@section('content')

<div class="page-wrapper">
  <div class="row page-titles">
    <div class="col-md-5 align-self-center">
      <h4 class="text-themecolor title"><span id="heading_field"></span> {{trans('label.Today Report')}}</h4>
    </div>
  </div>
<div class="row">
  <div class="col-md-12">
    <div class="nav-tabs-wrapper shadow">
      <ul class="nav nav-tabs" id="myTab" role="tablist">
        <li class="nav-item">
          <a class="nav-link active" id="cash-tab" data-toggle="tab" href="#cash" role="tab" aria-controls="cash" aria-selected="true">{{trans('label.Cash Statement')}}</a>
        </li>
        <li class="nav-item">
          <a class="nav-link" id="credit-tab" data-toggle="tab" href="#credit" role="tab" aria-controls="credit" aria-selected="false">{{trans('label.Credit')}}</a>
        </li>
        <li class="nav-item">
          <a class="nav-link" id="purchase-tab" data-toggle="tab" href="#purchase" role="tab" aria-controls="purchase" aria-selected="false">{{trans('label.Purchase')}}</a>
        </li>
        <li class="nav-item">
          <a class="nav-link" id="sales-tab" data-toggle="tab" href="#sales" role="tab" aria-controls="sales" aria-selected="false">{{trans('label.Sales')}}</a>
        </li>
        <li class="nav-item">
          <a class="nav-link" id="inventory-tab" data-toggle="tab" href="#inventory" role="tab" aria-controls="inventory" aria-selected="false">{{trans('label.Sales Item')}}</a>
        </li>
      </ul>
      <div class="tab-content p-3" id="myTabContent">
        <div class="tab-pane fade show active" id="cash" role="tabpanel" aria-labelledby="cash-tab">
              
            <table id="" class="table table-striped table-bordered dataTable" style="width:100%">
            <thead>
                <tr>
                    <th class="text-center">{{trans('label.Time')}}</th>
                    <th class="text-center">{{trans('label.Account Type')}}</th>
                    <th class="text-center">{{trans('label.Account No')}}</th>
                    <th class="text-center">{{trans('label.Account Name')}}</th>

                    <th class="text-center">{{trans('label.Received')}}</th>
                    <th class="text-center">{{trans('label.Payment')}}</th>

                    <th class="text-center">{{trans('label.Entry by')}}</th>
                </tr>
            </thead>
            <tbody>
@if($openingBalance[0]->balance !='' )
<tr>
  <td></td>
  <td></td>
  <td></td>
  
  <td>{{$openingBalance[0]->descriptions}}</td>
  <td class="text-right">{{$openingBalance[0]->balance}}</td>

  <td></td>
  <td></td>
</tr>

@endif

             @forelse($todayCash as $cash)
                  <tr>
                    <td>{{ $cash->created_at }}</td>
                    <td>{!! ucfirst($cash->person_type ?? '') !!}</td>
                    <td colspan="2">{!! $cash->account_no ?? '' !!} @php 
                                        echo   \App\Http\Controllers\TransectionController::getAccountName($cash->own_account_no,$cash->person_type,'cash_books');

                                      @endphp</td>
                   
                  <td class="text-right">{{ $cash->debit }}</td>
                  <td class="text-right">{{ $cash->credit }}</td>

                  <td>{{ $cash->user_name->name ?? '' }}</td>
              </tr>
              @empty
                 <tr>
                   <td colspan="5">{{trans('label.No Transection')}}</td>
                 </tr>
              @endforelse

            </tbody>
            <tfoot>
              <tr>
              <td colspan="4" class="text-center"><b>{{trans('label.Today Total')}}</b></td>
              
              <td class="text-right">
                <?php echo $todayCash->sum('debit');?> 
              </td>

              <td class="text-right"><?php echo $todayCash->sum('credit'); ?></td>
              <td></td>
              </tr>
                <tr>
                  <td colspan="4" class="text-center"><b>Balance</b></td>
                  <td colspan="3" class="text-center">
                    <?php 
                    echo $todayCash->sum('debit')-$todayCash->sum('credit');
                     ?>
                  </td>
                </tr>

            </tfoot>
          </table>
        </div>





        <div class="tab-pane fade" id="credit" role="tabpanel" aria-labelledby="credit-tab">
          <table id="" class="table table-striped table-bordered dataTable" style="width:100%">
            <thead>
                <tr>
                    <th>{{trans('label.Time')}}</th>
                    <th class="text-center">{{trans('label.Invoice No')}}</th>
                    <th class="text-center">{{trans('label.Customer Name')}}</th>
                    <th class="text-center">{{trans('label.Sales')}}</th>
                    <th class="text-center">{{trans('label.Receive')}}</th>
                    <th class="text-center">{{trans('label.Due Amount')}}</th>
                    <th class="text-center">{{trans('label.Entry By')}}</th>
                </tr>
            </thead>
            <tbody>
              <?php
if (!empty($SalesOrder)) {
	foreach ($SalesOrder as $creditSales) {?>
   <tr>
    <td>{{$creditSales->created_at}}</td>
    <td>
      <a href="{{url('sales-invoices')}}/{{$creditSales->id}}">{{$creditSales->id}}</a>
      </td>
    <td>{{$creditSales->Customer->name ?? null}}</td>
    <td class="text-right">{{$creditSales->payment_amount}}</td>
    <td class="text-right">{{$creditSales->receive_amount_from_custome}}</td>
    <td class="text-right">{{$creditSales->due_amount}}</td>
    <td>{{$creditSales->entryBy->name ?? ''}}</td>
  </tr>
 <?php }
} else {?>
<tr>
  <td class="6">{{trans('label.Today Have No Credit Invoice')}} </td>
</tr>
<?php }?>

<tfoot>
  <tr>
    <td colspan="3" class="text-center"><b>Total</b></td>
  
  <td style="background: #339c6a; color: #ffffff" class="text-right"><?php echo $SalesOrder->sum('payment_amount'); ?></td>
  <td style="background: #339c6a; color: #ffffff" class="text-right"><?php echo $SalesOrder->sum('receive_amount_from_custome'); ?></td>
  <td style="background: #339c6a; color: #ffffff" class="text-right"><?php echo $SalesOrder->sum('due_amount'); ?></td>
  <td></td>
</tr>
</tfoot>

            </tbody>
          </table>
        </div>
        <div class="tab-pane fade" id="purchase" role="tabpanel" aria-labelledby="purchase-tab">
          <table id="" class="table table-striped table-bordered dataTable" style="width:100%">
            <thead>
                <tr>
                    <th class="text-center">{{trans('label.Time')}}</th>
                    <th class="text-center">{{trans('label.Invoice No')}}</th>
                    <th class="text-center">{{trans('label.Supplier Name')}}</th>
                    <th class="text-center">{{trans('label.Purchase')}}</th>
                    <th class="text-center">{{trans('label.Payment')}}</th>
                    <th class="text-center">{{trans('label.Due Amount')}}</th>
                    <th class="text-center">{{trans('label.Entry By')}}</th>
                </tr>
            </thead>
            <tbody>
              <?php
if (!empty($PurchaseOrder)) {
	foreach ($PurchaseOrder as $purchase) {?>
   <tr>
    <td>{{$purchase->created_at}}</td>
    <td>{{$purchase->id}}</td>
    <td>{{$purchase->SupplierProfile->name ?? null}}</td>
    <td class="text-right">{{$purchase->net_amount ?? null}}</td>
    <td class="text-right">{{($purchase->payment_amount ?? null)}}</td>
    <td class="text-right">{{(($purchase->net_amount ?? 0) - ($purchase->payment_amount ?? 0))}}</td>
    <td>{{$purchase->employee_id}}</td>
  </tr>
 <?php }
} else {?>
<tr>
  <td class="6">{{trans('label.Today Have No purchase Invoice')}} </td>
</tr>
<?php }?>
</tbody>
<tfoot>
  <tr>
    <td colspan="3" class="text-center"><b>Total</b></td>
  <td style="background: #339c6a; color: #ffffff" class="text-right"><?php echo $PurchaseOrder->sum('net_amount'); ?></td>
  <td style="background: #339c6a; color: #ffffff" class="text-right"><?php echo $PurchaseOrder->sum('payment_amount'); ?></td>
  <td style="background: #339c6a; color: #ffffff" class="text-right"><?php echo ($PurchaseOrder->sum('net_amount') - $PurchaseOrder->sum('payment_amount')); ?></td>

  <td></td>
</tr>
</tfoot>
          </table>
        </div>

        <div class="tab-pane fade" id="sales" role="tabpanel" aria-labelledby="sales-tab">
          <table id="" class="table table-striped table-bordered dataTable" style="width:100%">
            <thead>
                <tr>
                    <th class="text-center">{{trans('label.Time')}}</th>
                    <th class="text-center">{{trans('label.Invoice No')}}</th>
                    <th class="text-center">{{trans('label.Customer Name')}}</th>
                    <th class="text-center">{{trans('label.Sales')}}</th>
                    <th class="text-center">{{trans('label.Receive')}}</th>
                    <th class="text-center">{{trans('label.Due Amount')}}</th>
                    <th class="text-center">{{trans('label.Entry By')}}</th>
                </tr>
            </thead>
            <tbody>
              <?php
if (!empty($Sales)) {
	foreach ($Sales as $sale) {?>
   <tr>
    <td>{{$sale->created_at}}</td>
    <td><a href="{{url('sales-invoices')}}/{{$sale->id}}">{{$sale->id}}</a></td>
    <td>{{$sale->Customer->name ?? null}}</td>
    <td class="text-right">{{$sale->payment_amount}}</td>
    <td class="text-right">{{$sale->receive_amount_from_custome}}</td>
    <td class="text-right">{{$sale->due_amount}}</td>
    <td>{{$sale->User->name ?? ''}}</td>
  </tr>
 <?php }
} else {?>
<tr>
  <td class="6">{{trans('label.Today Have No Sales Invoice')}} </td>
</tr>
<?php }?>
</tbody>
<tfoot>
  <tr>
    <td colspan="3" class="text-center"><b>Total</b></td>
  <td style="background: #339c6a; color: #ffffff" class="text-right"><?php echo $Sales->sum('payment_amount'); ?></td>
  <td style="background: #339c6a; color: #ffffff" class="text-right"><?php echo $Sales->sum('receive_amount_from_custome'); ?></td>
  <td style="background: #339c6a; color: #ffffff" class="text-right"><?php echo $Sales->sum('due_amount'); ?></td>
  <td></td>
</tr>
</tfoot>

          </table>
        </div>
        <div class="tab-pane fade" id="inventory" role="tabpanel" aria-labelledby="inventory-tab">
          <table id="" class="table table-striped table-bordered dataTable" style="width:100%">
            <thead>
                <tr>
                    <th class="text-center">{{trans('label.Time')}}</th>
                    <th class="text-center">{{trans('label.Invoice No')}}</th>
                    <th class="text-center">{{trans('label.Item Id')}}</th>
                    <th class="text-center">{{trans('label.Name')}}</th>
                    <th class="text-center">{{trans('label.Lot No')}}</th>
                    <th class="text-center">{{trans('label.Qty')}}</th>
                    <th class="text-center">{{trans('label.Sales_Price_unit')}}</th>
                    <th class="text-center">{{trans('label.Total')}}</th>
                    <th class="text-center">{{trans('label.Type')}}</th>
                    <th class="text-center">{{trans('label.Entry')}}</th>

                </tr>
            </thead>
            <tbody>
              <?php
if (!empty($salesItems)) {
	foreach ($salesItems as $item) {
		?>
<tr>
  <td>{{$item->created_at}}</td>
  <td>{{$item->order_id}}</td>
  <td>{{$item->product_id}}</td>
  <td>{{$item->product->name ?? null}}</td>
  <td>{{$item->lot_no}}</td>
  <td>{{$item->qty}}</td>
  <td>{{$item->sales_price}}</td>
  <?php
$discount_rate = $item->discount_rate ?? 0;
		$discount = ($item->line_total * $item->discount_rate) / 100;
		$vatAbleTotal = $item->line_total - $discount;
		$vat_rate = $item->vat_rate ?? 0;
		$vat_amount = ($vatAbleTotal * $vat_rate) / 100;
		$total_amount = $vatAbleTotal + $vat_amount;

		?>
  <td>{{$total_amount}}</td>
  <td><?php if ($item->status == 1) {
			echo "Sales";
		} else {
			echo "sales Return";
		}?></td>
  <td>{{$item->entryBy->employee_id ?? null}}</td>
</tr>
           <?php }}?>


            </tbody>
            <tfoot>

            </tfoot>
          </table>
        </div>
      </div>
    </div>
  </div>
</div>

  </div>

</div>

@endsection


@section('script')

<!--stickey kit -->
{{Html::script('assets/js/sticky-kit.min.js')}}
{{Html::script('assets/js/jquery.sparkline.min.js')}}
<!-- This is data table -->
{{Html::script('assets/js/jquery.dataTables.min.js')}}
<!-- start - This is for export functionality only -->
{{Html::script('assets/js/dataTables.buttons.min.js')}}
{{Html::script('assets/js/buttons.flash.min.js')}}
{{Html::script('assets/js/jszip.min.js')}}
{{Html::script('assets/js/pdfmake.min.js')}}
{{Html::script('assets/js/vfs_fonts.js')}}
{{Html::script('assets/js/buttons.html5.min.js')}}
{{Html::script('assets/js/buttons.print.min.js')}}
{{Html::script('assets/custom_js/crud.js')}}

<link rel="stylesheet" href="//code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
<script>

   $('.dataTable').DataTable( {
        dom: 'lBfrtip',
         lengthMenu: [
            [  50,100, -1 ],
            [  '50','100', 'all' ]
        ],
        buttons: [
             'csv', 'excel', 'pdf', 'print'
        ],
    } );


   /*$("#credit-tab").on('click',function(){
      $.ajax({
        url: 'todayCreditSales',
        type: 'GET',
        dataType: 'html',

      })
      .done(function(success) {
        if(success.length > 0){
          var htmlView = [];
          for (var i = 0; i < success.length; i++) {
            var View = "<tr><td>Tiger Nixon</td><td>System Architect</td><td>Edinburgh</td><td>61</td><td>2011/04/25</td><td>$320,800</td></tr>";
            htmlView.push(View);
          }

        }else{

        }
        $("#addCreditSales").html(htmlView);
      })
      .fail(function() {
        console.log("error");
      })
      .always(function() {
        console.log("complete");
      });

    alert(1);
   })*/
</script>
@endsection