@section('title','Customer - POS')
@extends('layouts.master')
@section('style')
<link rel="stylesheet" href="//code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">

<style>
td form {
    display: inline-block;
}
body {
    counter-reset: serial-number;
}
table#example23 tr td:first-child:before {
    counter-increment: serial-number;
    content: counter(serial-number);
}
.agging_report_p{

}
</style>
@endsection


@section('content')
<script>
function printContent(el){
  var restorepage = document.body.innerHTML;
  var printcontent = document.getElementById(el).innerHTML;
  document.body.innerHTML = printcontent;
  window.print();
  document.body.innerHTML = restorepage;
}
</script>


<div class="page-wrapper">

    <div class="container-fluid">
        <div class="row page-titles">
            <div class="col-md-5 align-self-center">
                <h4 class="text-themecolor title"><span id="heading_field"></span> {{trans('label.Customer Supplier Both Account History')}}</h4>
            </div>
            <div class="col-md-6" style="text-align: right;">
              <button onclick="goBack()" class="btn btn-transparent-border"><i class="fa fa-chevron-left" aria-hidden="true"></i> {{trans('label.Back')}}</button>
            </div>

        </div>

        <div class="row">
            <div class="col-12">
                <div class="card-body-wrapper">
                <div class="row">
                    <div class="col-12">
                        @if ($errors->any())
                            <div class="alert alert-danger">
                                <ul>
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif
                        <form class="" method="get" action="" >
                            {{csrf_field()}}
                            <div class="row">
                                <div class="col-md-3">
                                        <div class="form-group">
                                        <h5>{{trans('label.Customer Id / Name')}} <span class="text-danger">*</span></h5>
                                        <div class="controls">
                                            <input class="form-control mr-sm-2" type="search" placeholder="{{trans('label.Search With Id or Name')}}" aria-label="Search" id="addCustomer" name="addCustomer" name="customer_search" attr_url="{{url('customer_for_sales')}}" required="required"  @if(isset($_GET['addCustomer'])) value="{{$_GET['addCustomer']}}" @else value="{{ old('addCustomer') }}" @endif>
                                            <input class="form-control mr-sm-2 id_for_history" type="hidden" placeholder="Customer Search By Id or Name" aria-label="Search" id="id_for_history" name="account_no" @if(isset($_GET['account_no'])) value="{{$_GET['account_no']}}" @else value="{{ old('account_no') }}" @endif >
                                        </div>
                                        </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <h5>{{trans('label.From Date')}} <span class="text-danger">*</span></h5>
                                        <div class="controls">
                                            <input type="text" name="start_date" id="start_date" class="form-control prventSubmit" @if(isset($_GET['start_date'])) value="{{$_GET['start_date']}}" @else value="{{ old('start_date') }}" @endif required="required" tabindex="1">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <h5>{{trans('label.End Date')}}<span class="end_date">*</span></h5>
                                        <div class="controls">
                                            <input type="text" name="end_date" id="end_date" class="form-control prventSubmit" @if(isset($_GET['end_date'])) value="{{$_GET['end_date']}}" @else value="{{ old('end_date') }}" @endif required="required" tabindex="1">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="text-xs-right" style="margin-top: 27px;">
                                        <button type="submit" id="submit_button" class="btn btn-success btnSubmit">{{trans('label.Search')}}</button>
                                        <button type="reset" class="btn btn-inverse ">{{trans('label.Reset')}}</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                    </div>

                @if(isset($customerHistory))
                @if(count($customerHistory)>0)
                <div class="col-sm-12 text-right">
                  <span class="print_invoice" onclick="printContent('print-section')"><span class="fa fa-print btn btn-lg danger" style="color: red; margin-bottom: 10px;"></span></span>
                </div>


                <div class="col-md-12" id="print-section">
                  <div class="card shadow">
                      <div class="text-center mt-2">
                      
                        @if($shopinfo->shop_name ?? '' !=null)<h4>{{$shopinfo->shop_name}}</h4>
                        <p class="agging_report_p">{{$shopinfo->shop_address}}</p>
                        <p class="agging_report_p">{{$shopinfo->shop_email}} , {{$shopinfo->shop_phone}}</p>
                        @else

                        <h4 >Leftjoin</h4>
                        <p class="agging_report_p">Mirpur ,Dhaka</p>
                        <p class="agging_report_p">leftjoin@gmail.com , 01738088325</p>
                        @endif
                        
                      </div>
                      <div>
                    <div class=" pull-left ml-2">@if(!empty($info))<p class="agging_report_p">{{trans('label.Customer information')}} :</p><p>{{trans('label.Name')}} :{{$info->name}} </p><p>{{trans('label.Contact Number')}} :{{$info->phone}} </p><p>{{trans('label.Address')}} :{{$info->address}} </p>
                    @endif
                    </div>
                    <div class="pull-right mr-2"><p class="agging_report_p">{{trans('label.Report Date')}} :</p>
                                                  <p> @if(isset($_GET['start_date'])) From : {{$_GET['start_date']}} to @endif @if(isset($_GET['end_date'])) {{$_GET['end_date']}} @endif</p>
                    </div>
                    <table class="table">
                      <tr>
                        <th>{{trans('label.Date')}}</th>
                        <th>{{trans('label.Description')}}</th>
                        <th>{{trans('label.Debit')}}</th>
                        <th>{{trans('label.Credit')}}</th>
                        <th>{{trans('label.Balance')}}</th>
                      </tr>
                      @php
                      $balance = 0;
                      @endphp
                      @forelse($customerHistory as $hiskey=> $history)
                      @php 
                      $balance +=($history->debit-$history->credit)
                      @endphp
                      <tr>
                        <td>
                          @if($hiskey==0)
                          {{ $_GET['start_date'] }}
                          @else
                          {{ $history->transection_date ?? '' }}
                          @endif

                          </td>
                        <td>{{ $history->description ?? '' }}</td>
                        <td>@if( $history->debit !=0) {{ $history->debit }} @endif</td>
                        <td>@if( $history->credit !=0) {{ $history->credit }} @endif</td>
                        <td>{{ $balance }}</td>
                      </tr>
                      @empty
                      @endforelse
                      <tr>
                        <td colspan="5" style="height: 50px;"></td>
                      </tr>
                      
                      <tr>
                        <td>{{trans('label.Customer Signature')}} </td>
                        <td></td>
                        <td></td>
                        <td colspan="2" class="text-right">{{trans('label.Authorized signature')}}</td>
                      </tr>
                      <tr>
                        <td colspan="5"  style="height: 30px !important"></td>
                      </tr>
                      <tr>
                        <td colspan="5"></td>
                      </tr>
                    </table>
                  </div>
                  </div>
                </div>
                @else
                <div class="col-md-12 text-center">
                 {{trans('label.No transaction available')}}
                </div>
                @endif


                @endif

                </div>
            </div>
        </div>

    </div>
</div>

@endsection


@section('script')

<!--stickey kit -->
{{Html::script('assets/js/sticky-kit.min.js')}}
{{Html::script('assets/js/jquery.sparkline.min.js')}}
<!-- This is data table -->
{{Html::script('assets/js/jquery.dataTables.min.js')}}
<!-- start - This is for export functionality only -->
{{Html::script('assets/js/dataTables.buttons.min.js')}}
{{Html::script('assets/js/buttons.flash.min.js')}}
{{Html::script('assets/js/jszip.min.js')}}
{{Html::script('assets/js/pdfmake.min.js')}}
{{Html::script('assets/js/vfs_fonts.js')}}
{{Html::script('assets/js/buttons.html5.min.js')}}
{{Html::script('assets/js/buttons.print.min.js')}}
{{Html::script('assets/custom_js/crud.js')}}
{{Html::script('assets/custom_js/datatable.js')}}
{{Html::script('assets/custom_js/add_more.js')}}


<!-- end - This is for export functionality only -->
{{-- {{Html::script('assets/public_js/index.js')}} --}}
 <script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>

 @if(isset($_GET['end_date']))
      <input type="hidden" value="{{$_GET['end_date']}}" id="end_date_default">
 @else
  <input type="hidden" value="" id="end_date_default">
 @endif

 @if(isset($_GET['start_date']))
      <input type="hidden" value="{{$_GET['start_date']}}"  id="start_date_default">
 @else
  <input type="hidden" value="" id="start_date_default">
 @endif
  <script>
    $(document).ready(function($) {
      var default_s_date=$('#start_date_default').val();
      var default_e_date=$('#end_date_default').val();
    $( "#start_date" ).datepicker({
      changeMonth: true,
      changeYear: true,
      timeInput: true,
      dateFormat : 'yy-mm-dd'
    }).datepicker("setDate", new Date(default_s_date));
    $( "#end_date" ).datepicker({
      changeMonth: true,
      changeYear: true,
      timeInput: true,
      dateFormat : 'yy-mm-dd'
    }).datepicker("setDate", new Date(default_e_date));



    //customer auto search
   var customer = [];
  var customer_info_array = [];
  $( function(){
  var customer = [];
  var customer_info_array = [];
    //Customer display function for sales

     $("#addCustomer").on('keyup',function(){
          var url=$(this).attr('attr_url');
          var search_text = $(this).val();
          var common_id = 2;
          $.ajax({
          url: url,
          type: 'GET',
          data:{search_text,common_id},
          dataType: 'json',
        })
        .done(function(response) {
          console.log(response)
          customer.length = 0;
          var cus = response;
            for (var i = 0; i < cus.length; i++) {
            customer.push(cus[i].id+" <> " + cus[i].name +" <> "+cus[i].address);
            }
        });

    })



    $( "#addCustomer" ).autocomplete({
      source: customer,
      select: function (event, ui) {
        var customer_info = ui.item.value;
        var info_split = customer_info.split('<>');
        var customer_id = info_split[0].trim();
        var customer_name = info_split[1].trim();
        $(".id_for_history").val(customer_id);


      }
    });




  })

  });
  </script>

@endsection