@section('title','Report - POS')
@extends('layouts.master')
@section('style')
<link rel="stylesheet" href="//code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">

 {{Html::style('assets/css/jquery-ui.css')}}
  {{Html::style('assets/css/select2.min.css')}}

  <style>
  td form {
      display: inline-block;
  }
  body {
      counter-reset: serial-number;
  }
  table#example23 tr td:first-child:before {
      counter-increment: serial-number;
      content: counter(serial-number);
  }
  .card-body {
    -webkit-box-shadow: 0 1px 15px 0px #999;
    -moz-box-shadow: 0 1px 15px 0px #999;
    box-shadow: 0 1px 15px 0px #999;
  }

  /* customise select2 start */
  .select2-container--default .select2-selection--single {
      border: 1px solid #ccc;
      border-radius: 0;
  }
  .select2-container .select2-selection--single {
      height: 35px;
  }
  .select2-container--default .select2-selection--single .select2-selection__rendered {
      line-height: 34px;
  }
  .select2-container .select2-selection--single .select2-selection__rendered {
      padding-left: 15px;
  }
  .select2-container--default .select2-selection--single .select2-selection__arrow {
      height: 33px;
  }
  .select2-container--default .select2-selection--single .select2-selection__arrow b {
      border-color: #444 transparent transparent transparent;
  }
  /* customise select2 end */
  </style>
@endsection


@section('content')
<script>
function printContent(el){
  var restorepage = document.body.innerHTML;
  var printcontent = document.getElementById(el).innerHTML;
  document.body.innerHTML = printcontent;
  window.print();
  document.body.innerHTML = restorepage;
}
</script>


<div class="page-wrapper">

    <div class="container-fluid">
        <div class="row page-titles">
            <div class="col-md-5 align-self-center">
                <h4 class="text-themecolor title"><span id="heading_field"></span>{{trans('label.Accounts Transection History')}}</h4>
            </div>
            <div class="col-md-6" style="text-align: right;">
              <button onclick="goBack()" class="btn btn-transparent-border"><i class="fa fa-chevron-left" aria-hidden="true"></i> {{trans('label.Back')}}</button>
            </div>

        </div>

        <div class="row">
            <div class="col-12">
                <div class="card-body-wrapper">
                <div class="row">
                    <div class="col-12">
                        @if ($errors->any())
                            <div class="alert alert-danger">
                                <ul>
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif
                        <form class="form-group" method="get" action="" >
                            {{csrf_field()}}
                               @php
                               $accounts = ['Cash' => 'Cash', 'Bank' => 'Bank', 'Mobile_bank' => 'Mobile Bank', 'Customer' => 'Customer', 'Supplier' => 'Supplier', 'Loan' => 'Loan', 'Investment' => 'Investment', 'Capital' => 'Capital', 'Capital' => 'Capital', 'Expenses' => 'Expenses', 'Sales_inventory' => 'Sales  (Inventory Wise)', 'Purchase' => 'Purchase (Inventory Wise)'];
                               @endphp
                            <div class="row ">
                               <div class="col-md-3">
                                 <h5>{{trans('label.Account Category')}}<span class="text-danger">*</span></h5>
                               </div>
                                <div class="col-md-6">
                                        <div class="controls">
                                           <div class="col-sm-9">
                                             <select class="form-control account_category" name="account_category" required attr_url="{{url('find-account-for-report')}}">
                                             @foreach($accounts as  $key=>$value)
                                               <option value="{{$key}}">{{$value}}</option>
                                             @endforeach
                                             </select>
                                          </div>
                                        </div>
                                </div>
                            </div>
                            <div class="row ">
                               <div class="col-md-3">
                                 <h5>{{trans('label.Account Name')}}<span class="text-danger">*</span></h5>
                               </div>
                                <div class="col-md-6">
                                        <div class="controls">
                                           <div class="col-sm-9">
                                             <select class="form-control account_name" name="account_name" required>
                                                <option value="cash_book">{{trans('label.Cash Book')}}</option>
                                             </select>
                                          </div>
                                        </div>
                                </div>
                            </div>
                            <div class="row">
                              <div class="col-md-3">
                                  <h5> {{trans('label.Date Range')}} <span class="text-danger">*</span></h5>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">

                                        <div class="controls">
                                            <input type="text" name="start_date" id="start_date" class="form-control prventSubmit" @if(isset($_GET['start_date'])) value="{{$_GET['start_date']}}" @else value="{{ old('start_date') }}" @endif required="required" tabindex="1">
                                        </div>
                                    </div>
                                    <div class="form-group">

                                        <div class="controls">
                                            <input type="text" name="end_date" id="end_date" class="form-control prventSubmit" @if(isset($_GET['end_date'])) value="{{$_GET['end_date']}}" @else value="{{ old('end_date') }}" @endif required="required" tabindex="1">
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="text-xs-right" style="margin-top: 27px;">
                                        <button type="submit" id="submit_button" class="btn btn-success btnSubmit">{{trans('label.Search')}}</button>

                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                    </div>

                @if(isset($customerHistory))
                @if(count($customerHistory)>0)
                <div class="col-sm-12 text-right">
                  <span class="print_invoice" onclick="printContent('print-section')"><span class="fa fa-print btn btn-lg danger" style="color: red; margin-bottom: 10px;"></span></span>
                </div>


                <div class="col-md-12" id="print-section">
                  <div class="card shadow">
                      <div class="text-center mt-2">
                        @if($shopinfo->shop_name!=null)<h4>{{$shopinfo->shop_name}}</h4>
                        <p class="agging_report_p">{{$shopinfo->shop_address}}</p>
                        <p class="agging_report_p">{{$shopinfo->shop_email}} , {{$shopinfo->shop_phone}}</p>
                        @else
                        <h4 >Leftjoin</h4>
                        <p class="agging_report_p">Mirpur ,Dhaka</p>
                        <p class="agging_report_p">leftjoin@gmail.com , 01738088325</p>
                        @endif
                        <hr style="background-color:2px solid #000;">
                        <p class="agging_report_p">{{trans('label.Customer Ageing Report')}}</p>
                      </div>
                      <div>
                    <div class=" pull-left ml-2">@if(!empty($info))<p class="agging_report_p">{{trans('label.Customer information')}}:</p><p>{{trans('label.Name')}} :{{$info->name}} </p><p>{{trans('label.Contact Number')}} :{{$info->phone}} </p><p>{{trans('label.Address')}} :{{$info->address}} </p>
                    @endif
                    </div>
                    <div class="pull-right mr-2"><p class="agging_report_p">{{trans('label.Report Date')}} :</p>
                                                  <p> @if(isset($_GET['start_date'])) From : {{$_GET['start_date']}} to @endif @if(isset($_GET['end_date'])) {{$_GET['end_date']}} @endif</p>
                    </div>
                    <table class="table">
                      <tr>
                        <th>{{trans('label.Date')}}</th>
                        <th>{{trans('label.Description')}}</th>
                        <th>{{trans('label.Debit')}}</th>
                        <th>{{trans('label.Credit')}}</th>
                        <th>{{trans('label.Balance')}}</th>
                      </tr>
                      @forelse($customerHistory as $history)
                      <tr>
                        <td>{{$history->t_date}}</td>
                        <td>@if($loop->iteration==1 && $history->descriptions !='B/F') B/F @else {{$history->descriptions}} @endif</td>
                        <td>{{$history->debit}}</td>
                        <td>{{$history->credit}}</td>
                        <td>{{$history->cummulative}}</td>
                      </tr>
                      @empty
                      @endforelse
                      <tr>
                        <td>{{trans('label.Received Amount')}} </td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                      </tr>
                      <tr>
                        <td>{{trans('label.Due  Amount')}} </td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                      </tr>
                      <tr>
                        <td>{{trans('label.Customer Signature')}} </td>
                        <td></td>
                        <td></td>
                        <td colspan="2" class="text-right">{{trans('label.Authorized signature')}}</td>
                      </tr>
                      <tr>
                        <td colspan="5"  style="height: 30px !important"></td>
                      </tr>
                      <tr>
                        <td colspan="5"></td>
                      </tr>
                    </table>
                  </div>
                  </div>
                </div>
                @else
                <div class="col-md-12 text-center">
                 {{trans('label.No transaction available')}}
                </div>
                @endif


                @endif

                </div>
            </div>
        </div>

    </div>
</div>

@endsection


@section('script')

<!--stickey kit -->
{{Html::script('assets/js/sticky-kit.min.js')}}
{{Html::script('assets/js/jquery.sparkline.min.js')}}
<!-- This is data table -->
{{Html::script('assets/js/jquery.dataTables.min.js')}}
<!-- start - This is for export functionality only -->
{{Html::script('assets/js/dataTables.buttons.min.js')}}
{{Html::script('assets/js/buttons.flash.min.js')}}
{{Html::script('assets/js/jszip.min.js')}}
{{Html::script('assets/js/pdfmake.min.js')}}
{{Html::script('assets/js/vfs_fonts.js')}}
{{Html::script('assets/js/buttons.html5.min.js')}}
{{Html::script('assets/js/buttons.print.min.js')}}
{{Html::script('assets/custom_js/crud.js')}}
{{Html::script('assets/custom_js/datatable.js')}}
{{Html::script('assets/custom_js/add_more.js')}}


<!-- end - This is for export functionality only -->
{{-- {{Html::script('assets/public_js/index.js')}} --}}
 <script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
 {{Html::script('assets/js/select2.min.js')}}

 @if(isset($_GET['end_date']))
      <input type="hidden" value="{{$_GET['end_date']}}" id="end_date_default">
 @else
  <input type="hidden" value="" id="end_date_default">
 @endif

 @if(isset($_GET['start_date']))
      <input type="hidden" value="{{$_GET['start_date']}}"  id="start_date_default">
 @else
  <input type="hidden" value="" id="start_date_default">
 @endif
  <script>
    $(document).ready(function($) {
      var default_s_date=$('#start_date_default').val();
      var default_e_date=$('#end_date_default').val();
    $( "#start_date" ).datepicker({
      changeMonth: true,
      changeYear: true,
      timeInput: true,
      dateFormat : 'yy-mm-dd'
    }).datepicker("setDate", new Date(default_s_date));
    $( "#end_date" ).datepicker({
      changeMonth: true,
      changeYear: true,
      timeInput: true,
      dateFormat : 'yy-mm-dd'
    }).datepicker("setDate", new Date(default_e_date));
  });
$(".account_category").on('change',function(){
    var category = $(this).val();
    var url = $(this).attr('attr_url');
    $.ajax({
      url:url ,
      type: 'GET',
      dataType: 'html',
      data: {category: category},
    })
    .done(function(success) {
      if(success ==''){
        success = "<option name='no_account'>There Is No Account</option>";
      }
      $(".account_name").html(success);
    })


});
  </script>

@endsection