@section('title','CWBO - POS')
@extends('layouts.master')
@section('style')
{{-- {{Html::style('assets/public_css/index.css')}} --}}
<style>
td form {
    display: inline-block;
}
body {
    counter-reset: serial-number;
}
table#example23 tr td:first-child:before {
    counter-increment: serial-number;
    content: counter(serial-number);
}
.card-body {
  -webkit-box-shadow: 0 1px 15px 0px #999;
  -moz-box-shadow: 0 1px 15px 0px #999;
  box-shadow: 0 1px 15px 0px #999;
}
</style>
@endsection


@section('content')

<div class="page-wrapper">

    <div class="container-fluid">
        <div class="row page-titles">
            <div class="align-self-center">
                <h4 class="text-themecolor title"><span id="heading_field"></span>{{trans('label.Withdrow By Owner')}} </h4>
            </div>
        </div>

      <div class="row">
        <div class="col-md-8">
          <div class="card">
             @if (Session::has('message'))
                       <h6 style="background: #20c997; color: #fff; text-align: center; padding: 5px; border-radius: 5px;">{{ Session::get('message') }}</h6>
                    @endif
            <div class="card-body">
              <div class="container-fluid">
                <form action="{{url('withdrow')}}" method="post" >
                  {{csrf_field()}}
                  @if($errors->any())
                  <h4 class="alert alert-warning" >{{$errors->first()}}</h4>
                  @endif

                  <div class="form-group row">
                    <label for="receiveableAccount" class="col-sm-2 col-form-label">{{trans('label.Account No')}}</label>
                    <div class="col-sm-10">
                      <input type="text" name="receiveableAccount" id="receiveableAccount" class="form-control" placeholder="{{trans('label.Persone Name')}}" required="required" >

                    </div>

                  </div>

                  <div class="form-group row">
                    <label for="recevedAmount" class="col-sm-2 col-form-label">{{trans('label.Receved Amount')}}</label>
                    <div class="col-sm-10">
                      <input type="number" name="recevedAmount" id="recevedAmount" class="form-control" placeholder="{{trans('label.Amount')}}" autocomplete="off" required="required" >
                    </div>
                  </div>
                  <div class="form-group row">
                    <label for="note" class="col-sm-2 col-form-label">{{trans('label.Note')}}</label>
                    <div class="col-sm-10">
                      <input type="text" name="note" id="note" class="form-control" placeholder="{{trans('label.Note')}}" required="required" autocomplete="off">
                    </div>
                  </div>

                  <div class="row">
                    <div class="col-md-12">
                      <div class="pull-right">
                        <input type="submit" class="btn btn-success" value="{{trans('label.Received')}}" >
                      </div>
                    </div>
                  </div>
                  <input type="hidden" name="account_number" id="account_number" class="form-control"   required="required" style="width: 300px !important;" @if(isset($_GET['account']))value="{{$_GET['account']}}" @endif>
                </form>
              </div>
            </div>
          </div>
        </div>
        <div class="col-md-4">
          <div class="card">
            <div class="card-body">
                <h4 class="text-center">{{trans('label.Capital History')}}  </h4>
              <table class="table table-bordered table-sm">
                <thead>
                  <tr>
                    <th>{{trans('label.Capital')}} </th>
                    <th>{{trans('label.Withdrow')}} </th>
                  </tr>
                </thead>
                <tbody id="invoiceInfo">



                </tbody>
                <tfoot>
                  <tr>
                    <td>{{trans('label.Balance')}}</td>
                    <td id="balnce"></td>
                  </tr>
                </tfoot>
              </table>
            </div>
          </div>

        </div>
      </div>
</div>

@endsection


@section('script')

<!--stickey kit -->
{{Html::script('assets/js/sticky-kit.min.js')}}
{{Html::script('assets/js/jquery.sparkline.min.js')}}
<!-- This is data table -->
{{Html::script('assets/js/jquery.dataTables.min.js')}}
<!-- start - This is for export functionality only -->
{{Html::script('assets/js/dataTables.buttons.min.js')}}
{{Html::script('assets/js/buttons.flash.min.js')}}
{{Html::script('assets/js/jszip.min.js')}}
{{Html::script('assets/js/pdfmake.min.js')}}
{{Html::script('assets/js/vfs_fonts.js')}}
{{Html::script('assets/js/buttons.html5.min.js')}}
{{Html::script('assets/js/buttons.print.min.js')}}
{{Html::script('assets/custom_js/crud.js')}}
{{Html::script('assets/custom_js/datatable.js')}}

<!-- end - This is for export functionality only -->
{{-- {{Html::script('assets/public_js/index.js')}} --}}
<link rel="stylesheet" href="//code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">


<script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>

<script>
$( function() {
    var name = [];
    var orderNumber = [];
    $.ajax({
        url: 'fetch_owner',
        type: 'GET',
        dataType: 'json',
        success: function(result){
            var owner = result;
             for (var i = 0; i < owner.length; i++) {
            name.push("own- "+owner[i].id+" - " + owner[i].name );
            }

        }
    })

    $("#receiveableAccount").autocomplete({
            source:  name,
            select: function (event, ui) {
                var dataInfo = ui.item.value;
                var info =  dataInfo.split('-');
                var id =  $("#account_number").val(info[1]);
                var own =   $('#account_number').val();


                //customer wise due invoice number show

                if(own !== ''){
                      $.ajax({
                      url: 'ownerWiseHistory',
                      type: 'GET',
                      dataType: 'json',
                      data: {own: own},
                    })
                    .done(function(success) {
                        $("#invoiceInfo").html(success.capital);
                        $("#balnce").html(success.balance);

                    })
                }

          }
    });


});
</script>

@endsection