@section('title','Sales History')
@extends('layouts.master')
@section('style')
{{-- {{Html::style('assets/public_css/index.css')}} --}}
<style>
td form {
    display: inline-block;
}
</style>
@endsection


@section('content')
<div class="page-wrapper">
    <div class="container-fluid">
        <div class="row page-titles">

                    <div class="col-md-6">
                         <h4>@foreach($info as $key=> $detail)

                          @if($key ==0 )
                             {{  $detail->name }}
                          @endif
                           @endforeach  {{trans('label.Sales Statement')}}</h4>
                    </div>
                    <div class="col-md-6">
                        <div style="text-align: right;">
                             <a href="{{ url('sales-history') }}" class="btn btn-success ">{{trans('label.Back')}}</a>
                        </div>
                    </div>

        </div>
        <div id='table_position'>
            @if(isset($totalInfo))
            @foreach($totalInfo as $total)
            <div class="row " style="text-align: center;" >
                @foreach($totalInfo as $total)
                    <div class="col-md-4">
                        <div class="card bg-secondary">
                            <div class="card-body">
                                <img src="{{ asset('assets/images/icons/cash-received.png') }}" alt="cash received">
                                <h4 class="mt-2">{{trans('label.Sales Cash Received')}}  </h4>
                                <h5>{{number_format($total->debTotal,2) }}</h5>
                            </div>
                        </div>
                    </div>
                     <div class="col-md-4">
                        <div class="card bg-secondary">
                            <div class="card-body">
                                <img src="{{ asset('assets/images/icons/cash-received.png') }}" alt="payment" style="transform: rotate(180deg); ">
                                <h4 class="mt-2">{{trans('label.Sales Cash Return')}}</h4>
                                <h5>{{number_format($total->creTotal,2) }}</h5>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="card bg-secondary">
                            <div class="card-body">
                                <img src="{{ asset('assets/images/icons/balance.png') }}" alt="balance">
                                <h4 class="mt-2">{{trans('label.Balance')}}</h4>
                                <h5>{{number_format($total->debTotal - $total->creTotal,2) }}</h5>

                            </div>
                        </div>
                    </div>
            @endforeach

            </div>
            @endforeach
            @endif

            <div class="row">
                <div class="col-md-12">
                    <table class="table table-bordered table-striped">
                        <thead>
                            <tr>
                                <th class="text-center">{{trans('label.Invoice Number')}}</th>
                                <th class="text-center">{{trans('label.Description')}}</th>
                                <th class="text-center">{{trans('label.Debit')}}</th>
                                <th class="text-center">{{trans('label.Credit')}}</th>
                                <th class="text-center">{{trans('label.Date')}}</th>

                            </tr>
                        </thead>
                        <tbody>
                            <?php $i = 0;?>
                    @foreach($info as $key =>  $detail)
                    @if($detail->debit > $detail->credit)
                            <tr>
                                <td><a href="{{url('salesDetails',$detail->refeance_no)}}">{{$detail->refeance_no }}</a></td>
                                <td>
                                   <a href="{{url('salesDetails',$detail->refeance_no)}}">{{trans('label.Sales')}} </a>
                                </td>
                                <td class="text-right"><a href="{{url('salesDetails',$detail->refeance_no)}}">{{number_format($detail->debit,2) }}</a></td>
                                <td class="text-right"><a href="{{url('salesDetails',$detail->refeance_no)}}">{{ number_format($detail->credit,2)  }}</a></td>
                                <td class="text-right"><a href="{{url('salesDetails',$detail->refeance_no)}}">{{ $detail->transection_date  }}</a></td>
                            </tr>
                        @else
                        <tr>
                                <td><a href="{{url('return-invoices/'.$detail->refeance_no.'/1')}}">{{$detail->refeance_no }}</a></td>
                                <td>
                                   <a href="{{url('return-invoices/'.$detail->refeance_no.'/1')}}">{{trans('label.Sales Return')}}  </a>
                                </td>
                                <td class="text-right"><a href="{{url('return-invoices/'.$detail->refeance_no.'/1')}}">{{number_format($detail->debit,2) }}</a></td>
                                <td class="text-right"><a href="{{url('return-invoices/'.$detail->refeance_no.'/1')}}">{{ number_format($detail->credit,2)  }}</a></td>
                                <td class="text-right"><a href="{{url('return-invoices/'.$detail->refeance_no.'/1')}}">{{ $detail->transection_date  }}</a></td>
                            </tr>
                        @endif
                        @endforeach
                            <tfoot>
                                <tr>
                                    <td colspan="2" class="text-right"><h3>{{trans('label.Balance')}}</h3></td>
                                     @foreach($totalInfo as $total)
                                    <td colspan="3" class="text-right"><h3>{{ number_format($total->debTotal - $total->creTotal,2)  }}</h3></td>
                                    @endforeach
                                </tr>
                            </tfoot>
                        </tbody>
                    </table>
                </div>

            </div>
        </div>
    </div>
</div>

@endsection


@section('script')

<!--stickey kit -->
{{Html::script('assets/js/sticky-kit.min.js')}}
{{Html::script('assets/js/jquery.sparkline.min.js')}}
<!-- This is data table -->
{{Html::script('assets/js/jquery.dataTables.min.js')}}
<!-- start - This is for export functionality only -->
{{Html::script('assets/js/dataTables.buttons.min.js')}}
{{Html::script('assets/js/buttons.flash.min.js')}}
{{Html::script('assets/js/jszip.min.js')}}
{{Html::script('assets/js/pdfmake.min.js')}}
{{Html::script('assets/js/vfs_fonts.js')}}
{{Html::script('assets/js/buttons.html5.min.js')}}
{{Html::script('assets/js/buttons.print.min.js')}}
{{Html::script('assets/custom_js/crud.js')}}
{{Html::script('assets/custom_js/datatable.js')}}

<!-- end - This is for export functionality only -->
{{-- {{Html::script('assets/public_js/index.js')}} --}}
<script>
</script>

@endsection

