@section('title','CPTS - POS')
@extends('layouts.master')
@section('style')
{{-- {{Html::style('assets/public_css/index.css')}} --}}
<style>
td form {
    display: inline-block;
}
body {
    counter-reset: serial-number;
}
table#example23 tr td:first-child:before {
    counter-increment: serial-number;
    content: counter(serial-number);
}
</style>
@endsection


@section('content')

<div class="page-wrapper">

    <div class="container-fluid">
        <div class="row page-titles">
            <div class="align-self-center">
                <h4 class="text-themecolor title"><span id="heading_field"></span>{{trans('label.Cash Payment')}}</h4>
            </div>

        </div>

        <div class="row">
        <div class="col-md-8">
            <div class="card shadow">
               @if (Session::has('message'))
                       <h6 style="background: #20c997; color: red; text-align: center; padding: 5px; border-radius: 5px;">{{ Session::get('message') }}</h6>
                    @endif
                 @if (Session::has('error'))
                       <h6 style="background: orange; color: #fff; text-align: center; padding: 5px; border-radius: 5px;">{{ Session::get('error') }}</h6>
                    @endif
                <div class="card-body">
                    <form action="{{ url('cash_payment_done')}}" method="post" id="cash_received_form">
                      {{csrf_field()}}

                      <div class="form-group row mt-3">
                        <label for="receiveableAccount" class="col-sm-2 col-form-label">{{trans('label.Account No')}} </label>
                        <div class="col-sm-10">
                          <input type="text" name="receiveableAccount" id="receiveableAccount" class="form-control" placeholder="{{trans('label.Persone Name')}}" required="required">
                        </div>
                      </div>
                      <div class="form-group row">
                        <label for="ref_no" class="col-sm-2 col-form-label">{{trans('label.Ref No.')}}</label>
                        <div class="col-sm-10">
                          <input type="text" name="ref_no" id="ref_no" class="form-control" placeholder="{{trans('label.Ref No.')}}" required="required" autocomplete="off">
                        </div>
                      </div>
                      <div class="form-group row">
                        <label for="recevedAmount" class="col-sm-2 col-form-label">{{trans('label.Amount')}}</label>
                        <div class="col-sm-10">
                          <input type="number"  step="any" autocomplete="off" name="recevedAmount" id="recevedAmount" class="form-control" placeholder="{{trans('label.Amount')}}" required="required">
                        </div>
                      </div>
                      <div class="form-group row">
                        <label for="note" class="col-sm-2 col-form-label">{{trans('label.Note')}}</label>
                        <div class="col-sm-10">
                          <input type="text" name="note" id="note" class="form-control" placeholder="{{trans('label.Note')}}" required="required" autocomplete="off">
                        </div>
                      </div>

                      <div class="row">
                        <div class="col-md-12">
                          <div class="pull-right">
                            <input type="submit" class="btn btn-success form-control" value="{{trans('label.Payment')}}" >
                          </div>
                        </div>
                      </div>
                      <input type="hidden" name="account_number" id="account_number" class="form-control"   required="required" style="width: 300px !important;color: #fff !important">
                    </form>
                </div>
            </div>
        </div>
        <div class="col-md-4">
          <div class="card shadow">
            <div class="card-body">
                <h4>{{trans('label.Credit Invoice Information')}} </h4>
              <table class="table table-bordered table-sm">
                <thead>
                  <tr>
                    <th>{{trans('label.Invoice No')}} </th>
                    <th>{{trans('label.Due Amount')}}</th>
                  </tr>
                </thead>
                <tbody id="invoiceInfo">



                </tbody>
              </table>
            </div>
          </div>
        </div>
    </div>
    </div>
</div>

@endsection


@section('script')

<!--stickey kit -->
{{Html::script('assets/js/sticky-kit.min.js')}}
{{Html::script('assets/js/jquery.sparkline.min.js')}}
<!-- This is data table -->
{{Html::script('assets/js/jquery.dataTables.min.js')}}
<!-- start - This is for export functionality only -->
{{Html::script('assets/js/dataTables.buttons.min.js')}}
{{Html::script('assets/js/buttons.flash.min.js')}}
{{Html::script('assets/js/jszip.min.js')}}
{{Html::script('assets/js/pdfmake.min.js')}}
{{Html::script('assets/js/vfs_fonts.js')}}
{{Html::script('assets/js/buttons.html5.min.js')}}
{{Html::script('assets/js/buttons.print.min.js')}}
{{Html::script('assets/custom_js/crud.js')}}
{{Html::script('assets/custom_js/datatable.js')}}

<!-- end - This is for export functionality only -->
{{-- {{Html::script('assets/public_js/index.js')}} --}}
<link rel="stylesheet" href="//code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
<script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
<script>
$( function() {
    var name = [];
    $.ajax({
        url: 'fetch_account_number',
        type: 'GET',
        dataType: 'json',
        success: function(result){
            var suppliers = result.suppliers;
             for (var i = 0; i < suppliers.length; i++) {
            name.push("sup- "+suppliers[i].id+" - " + suppliers[i].name );
            }
        }
    })

    $("#receiveableAccount").autocomplete({
            source:  name,
            select: function (event, ui) {
                var dataInfo = ui.item.value;
                var info =  dataInfo.split('-');
                 var sup = info[1];
                $("#account_number").val(sup);

              if(sup !== ''){
                      $.ajax({
                      url: 'customerWiseDueInvoiceNumber',
                      type: 'GET',
                      dataType: 'json',
                      data: {sup: sup},
                    })
                    .done(function(success) {
                      var info = [];
                      var total_credit = success[1][0].total_credit;
                      var total_debit = success[1][0].total_debit;
                      var balance =  total_credit - total_debit;
                      if(balance != null &&  balance !=0 ){
                        info1 = "<tr><td>opening</td><td>"+balance.toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,') +"</td></tr>";
                         info.push(info1);
                      }
                      if(success[0] == '' &&  balance == '0' &&  balance ==null ){
                        info = "<tr><td colspan='2'>No Due Invoice Available</td></tr>";
                      }else{
                       for (var i = 0; i < success[0].length; i++) {
                         info1 = "<tr><td>"+success[0][i].id+"</td><td>"+(success[0][i].net_amount - success[0][i].payment_amount).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,')+"</td></tr>";
                         info.push(info1);
                       }
                      }
                        $("#invoiceInfo").html(info);
                        $()
                    })

                }



            }

        });
});
</script>

@endsection