@section('title','CRFC - POS')
@extends('layouts.master')
@section('style')
{{-- {{Html::style('assets/public_css/index.css')}} --}}
{{Html::style('assets/css/jquery-ui.css')}}
<style>
td form {
    display: inline-block;
}
body {
    counter-reset: serial-number;
}
table#example23 tr td:first-child:before {
    counter-increment: serial-number;
    content: counter(serial-number);
}
.card-body {
  -webkit-box-shadow: 0 1px 15px 0px #999;
  -moz-box-shadow: 0 1px 15px 0px #999;
  box-shadow: 0 1px 15px 0px #999;
}
</style>
@endsection


@section('content')

<div class="page-wrapper">

    <div class="container-fluid">
        <div class="row page-titles">
            <div class="align-self-center">
                <h4 class="text-themecolor title"><span id="heading_field"></span> {{trans('label.Cash Received From Customer')}}</h4>
            </div>
        </div>

      <div class="row">
        <div class="col-md-8">
          <div class="card">
             @if (Session::has('message'))
                       <h6 style="background: #20c997; color: #fff; text-align: center; padding: 5px; border-radius: 5px;">{{ Session::get('message') }}</h6>
                    @endif
            <div class="card-body">
              <div class="container-fluid">
                <form action="{{url('cash_received_done')}}" method="post" >
                  {{csrf_field()}}
                  @if($errors->any())
                  <h4 class="alert alert-warning" >{{$errors->first()}}</h4>
                  @endif

                  <div class="form-group row mt-3">
                    <label for="receiveableAccount" class="col-sm-3 col-form-label">{{trans('label.Account No')}}</label>
                    <div class="col-sm-9">
                      <input type="text" name="receiveableAccount" id="receiveableAccount" class="form-control" placeholder="{{trans('label.Persone Name')}}" required="required" @if(isset($_GET['account']) && isset($_GET['name'])) value="cus-{{$_GET['account']}}-{{$_GET['name']}}" @endif >
                    </div>

                  </div>
                  <div class="form-group row">
                    <label for="ref_no" class="col-sm-3 col-form-label">{{trans('label.Invoice Number')}}</label>
                    <div class="col-sm-9">
                      <input type="text" name="ref_no" id="ref_no" autocomplete="off" class="form-control " placeholder="{{trans('label.Invoice Number')}}" required="required" @if(isset($_GET['ref']))value="{{$_GET['ref']}}" @endif>
                    </div>
                  </div>
                  <div class="form-group row">
                    <label for="recevedAmount" class="col-sm-3 col-form-label">{{trans('label.Receved Amount')}}</label>
                    <div class="col-sm-9">
                      <input type="number" name="recevedAmount" id="recevedAmount" class="form-control" placeholder="{{trans('label.Amount')}}" autocomplete="off" required="required" @if(isset($_GET['due']))value="{{$_GET['due']}}" @endif>
                    </div>
                  </div>
                  <div class="form-group row">
                    <label for="note" class="col-sm-3 col-form-label">{{trans('label.Note')}}</label>
                    <div class="col-sm-9">
                      <input type="text" name="note" id="note" class="form-control" placeholder="{{trans('label.Note')}}" required="required" autocomplete="off">
                    </div>
                  </div>

                  <div class="row">
                    <div class="col-md-12">
                      <div class="pull-right">
                        <input type="submit" class="btn btn-success" value="{{trans('label.Received')}}" >
                      </div>
                    </div>
                  </div>
                  <input type="hidden" name="account_number" id="account_number" class="form-control"   required="required" style="width: 300px !important;" @if(isset($_GET['account']))value="{{$_GET['account']}}" @endif>
                </form>
              </div>
            </div>
          </div>
        </div>
        <div class="col-md-4">
          <div class="card">
            <div class="card-body">
                <h4>{{trans('label.Credit Invoice Information')}} </h4>
              <table class="table table-bordered table-sm">
                <thead>
                  <tr>
                    <th>{{trans('label.Invoice No')}} </th>
                    <th>{{trans('label.Due Amount')}}</th>
                  </tr>
                </thead>
                <tbody id="invoiceInfo">



                </tbody>
              </table>
            </div>
          </div>

        </div>
      </div>
</div>

@endsection


@section('script')

<!--stickey kit -->
{{Html::script('assets/js/sticky-kit.min.js')}}
{{Html::script('assets/js/jquery.sparkline.min.js')}}
<!-- This is data table -->
{{Html::script('assets/js/jquery.dataTables.min.js')}}
<!-- start - This is for export functionality only -->
{{Html::script('assets/js/dataTables.buttons.min.js')}}
{{Html::script('assets/js/buttons.flash.min.js')}}
{{Html::script('assets/js/jszip.min.js')}}
{{Html::script('assets/js/pdfmake.min.js')}}
{{Html::script('assets/js/vfs_fonts.js')}}
{{Html::script('assets/js/buttons.html5.min.js')}}
{{Html::script('assets/js/buttons.print.min.js')}}
{{Html::script('assets/custom_js/crud.js')}}
{{Html::script('assets/custom_js/datatable.js')}}
{{Html::script('assets/js/jquery-ui.js')}}

<!-- end - This is for export functionality only -->
{{-- {{Html::script('assets/public_js/index.js')}} --}}
<?php
if (isset($_GET['account'])) {?>
<script type="text/javascript">
  var cus = $("#account_number").val();
  $.ajax({
      url: 'customerWiseDueInvoiceNumber',
      type: 'GET',
      dataType: 'json',
      data: {id: cus},
    })
    .done(function(success) {
      var info =[];
      if(success == ''){
        info = "<tr><td colspan='2'>No Due Invoice Available</td></tr>";
      }else{

       for (var i = 0; i < success.length; i++) {
         info1 = "<tr><td>"+success[i].id+"</td><td>"+(success[i].due_amount).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,')+"</td></tr>";
         info.push(info1);

       }
      }

        $("#invoiceInfo").html(info);
        //console.log(info);
    })

</script>

<?php }?>
<script>

$( function() {
    var name = [];
     var orderNumber = [];

    $.ajax({
        url: 'fetch_account_number',
        type: 'GET',
        dataType: 'json',
        success: function(result){
            var customers = result.customers;
           // var suppliers = result.suppliers;
           // var employees = result.employees;

             for (var i = 0; i < customers.length; i++) {
            name.push("cus- "+customers[i].id+" - " + customers[i].name );
            }

        }
    })

    $("#receiveableAccount").autocomplete({
            source:  name,
            select: function (event, ui) {
                var dataInfo = ui.item.value;
                var info =  dataInfo.split('-');
                var id =  $("#account_number").val(info[1]);
                var cus =   $('#account_number').val();
                //customer wise due invoice number show
                if(cus !== ''){
                      $.ajax({
                      url: 'customerWiseDueInvoiceNumber',
                      type: 'GET',
                      dataType: 'json',
                      data: {id: cus},
                    })
                    .done(function(success) {
                      //console.log(success);
                      var info = [];
                      var total_credit = success[1][0].total_credit;
                      var total_debit = success[1][0].total_debit;
                      var balance = total_debit - total_credit ;
                      if(balance != null &&  balance !=0 ){
                        info1 = "<tr><td>opening</td><td>"+balance.toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,') +"</td></tr>";
                         info.push(info1);
                      }

                      if(success[0] == '' ){
                        info = "<tr><td colspan='2'>No Due Invoice Available</td></tr>";
                      }else{
                        /*var retrunId = [];

                        for (var j = 0; j < success[2].length; j++) {
                         var rId = success[2][j].id;
                         var return_return_amount = success[2][j].return_return_amount;
                         retrunId[rId]=return_return_amount;
                       }*/
                       //if_key_exists(search_array=array(),search_key)



                       for (var i = 0; i < success[0].length; i++) {

                          $("#invoiceInfo").html('');
                        if(success[0][i].return_gross_amount ===undefined){
                            info1 = "<tr><td>"+success[0][i].mainId+"</td><td>"+(success[0][i].due_amount).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,')+"</td></tr>";

                            info.push(info1);
                        }else{

                          if((success[0][i].due_amount-success[0][i].return_gross_amount) !==0){
                            info1 = "<tr><td>"+success[0][i].mainId+"</td><td>"+(success[0][i].due_amount).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,')+"</td></tr>";
                            info.push(info1);
                          }
                        }


                       }

                       if(success[2] !=''){
                        for (var i = 0; i < success[2].length; i++) {
                         info1 = "<tr><td>"+success[2][i].id+"</td><td>"+(success[2][i].due_amount).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,')+"</td></tr>";
                         info.push(info1);
                       }
                       }

                      }

                        $("#invoiceInfo").html(info);

                    })
                }

          }
    });


});
</script>

@endsection