@section('title','income-statement')
@extends('layouts.master')
@section('style')
{{Html::style('assets/css/daterangepicker.css')}}
<style>
td form {
    display: inline-block;
}
</style>
@endsection


@section('content')
<script>
function printContent(el){
  var restorepage = document.body.innerHTML;
  var printcontent = document.getElementById(el).innerHTML;
  document.body.innerHTML = printcontent;
  window.print();
  document.body.innerHTML = restorepage;
}
</script>
<div class="page-wrapper">
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12 text-right">
            <span onclick="printContent('income_statement')"><span class="fa fa-print btn btn-lg danger" style="color: red; margin-bottom: 10px;"></span></span>
            </div>
        </div>
            <div class="col-md-12 text-center" id="income_statement" >
                <div class="text-center">
                @if($shopinfo->shop_name!=null)<h4>{{$shopinfo->shop_name}}</h4>
                  <address>
                  <p>{{$shopinfo->shop_address}}</p>
                  <p>{{$shopinfo->shop_email}} , {{$shopinfo->shop_phone}}</p>
                  </address>
                  @else
                  <h4>Leftjoin</h4>
                   <address>
                  <p>Mirpur ,Dhaka</p>
                  <p>leftjoin@gmail.com , 01738088325</p>
                  </address>
                  @endif

                <h4>{{trans('label.Trial Balance')}} </h4>
                <h4>Date: {{date('d-m-Y',strtotime($start_date))}} To {{date('d-m-Y',strtotime($end_date))}}</h4>
                </div>
                <table id="" class="display nowrap table table-hover table-striped table-bordered" cellspacing="0" width="100%">
                    <thead>
                        <tr>
                            <th>{{trans('label.Account Name')}}</th>
                            <th>{{trans('label.Debit')}}</th>
                            <th>{{trans('label.Credit')}}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @php
							$debit = 0;
							$credit = 0;
						@endphp
						@foreach ($trials as $data)
				      		<tr>
			                    <td class="text-center">{{ $data->name }}</td>
			                    @if($data->total_debit >= $data->total_credit)
				                    <td class="text-right">{{(number_format($debit1 = $data->total_debit-$data->total_credit,2))}}</td>
				                    <td class="text-right"></td>
			                    	@php
										$debit += $debit1;
									@endphp
			                    @elseif($data->total_debit < $data->total_credit)
				                    <td class="text-right"></td>
				                    <td class="text-right">{{(number_format($credit1 = $data->total_credit-$data->total_debit,2))}}</td>
			                    	@php
										$credit += $credit1;
									@endphp
			                    @endif
				      		</tr>
				      	@endforeach
                    </tbody>

					<tfoot>
						<tr>
							<th class="text-right">{{__('label.Total')}}:</th>
							<th class="text-right">{{(number_format($debit,2))}}</th>
							<th class="text-right">{{(number_format($credit,2))}}</th>
						</tr>
					</tfoot>
                </table>
            </div>

    </div>
</div>

@endsection


@section('script')

<!--stickey kit -->
{{Html::script('assets/js/sticky-kit.min.js')}}
{{Html::script('assets/js/jquery.sparkline.min.js')}}
<!-- This is data table -->
{{Html::script('assets/js/jquery.dataTables.min.js')}}
<!-- start - This is for export functionality only -->
{{Html::script('assets/js/dataTables.buttons.min.js')}}
{{Html::script('assets/js/buttons.flash.min.js')}}
{{Html::script('assets/js/jszip.min.js')}}
{{Html::script('assets/js/pdfmake.min.js')}}
{{Html::script('assets/js/vfs_fonts.js')}}
{{Html::script('assets/js/buttons.html5.min.js')}}
{{Html::script('assets/js/buttons.print.min.js')}}
{{Html::script('assets/custom_js/crud.js')}}
{{Html::script('assets/custom_js/datatable.js')}}

{{Html::script('assets/js/moment.min.js')}}
{{Html::script('assets/js/daterangepicker.min.js')}}




@endsection