@section('title','Account Details')
@extends('layouts.master')
@section('style')

  
  {{Html::style('assets/css/jquery-ui.css')}}
  {{Html::style('assets/css/select2.min.css')}}
  {{Html::style('assets/css/custome_search.css')}}

  
@endsection


@section('content')

<div class="page-wrapper">
    <div class="container-fluid">
        <div class="row page-titles">

            <div class="col-md-5 align-self-center">
                <h4 class="text-themecolor title"><span id="heading_field"></span> {{trans('label.Ledger Report Form')}}</h4>
            </div>
        </div>

        <div class="row">
            <div class="col-12">
                @if (Session::has('message'))
                  <h6 style="background: #20c997; color: #fff; text-align: center; padding: 5px; border-radius: 5px;">{{ Session::get('message') }}</h6>
                  @endif
                <div class="card-body-wrapper">
                       

                    <div id='table_position'>
                        <div class="">
                            <form action="{{url('accout-ledger-report')}}" method="GET" target="_blank">
							     <div class="row">
							        <div class="col-md-1"></div>
							        <div class="col-md-2">
							            <div class="form-group">
							                <label for="ad_al4_id">{{trans('label.Account Category')}} </label>
							                <div class="controls">
							                    <select id="acc_id_1" name="ad_al4_id" class="form-control js-example-responsive">
							                        <option value="">Select Account Category</option>
							                        @forelse($account_heads as $value)
							                         <option value="{{ $value->id }}">{{ $value->ad_code ?? '' }} - {{ $value->name  }}</option>
							                        @empty
							                        @endforelse
							                    </select>

							                </div>
							            </div>
							        </div>
							        <div class="col-md-2">
							            <div class="form-group">
							                <label for="phone">{{trans('label.Date')}} </label>
							                <div class="controls">
							                    <input type="date" name="start_date" class="form-control">
							                </div>
							            </div>
							        </div>
							        <div class="col-md-2">
							            <div class="form-group">
							                <label for="ad_address">{{trans('label.To')}} </label>
							                <div class="controls">
							                    <input type="date" name="end_date" class="form-control">
							                </div>
							            </div>
							        </div>
							        <div class="col-md-1">
							            <div class="form-group">
							                <label for="ah_code"></label>
							                <div class="controls">
							                    <button class="form-control btn btn-warning" type="submit">Search</button>
							                   
							                </div>
							            </div>
							        </div>
							        
							        <div class="col-md-1"></div>
							    </div>
							</form>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>

@endsection


@section('script')

<!--stickey kit -->
{{Html::script('assets/js/sticky-kit.min.js')}}
{{Html::script('assets/js/jquery.sparkline.min.js')}}
<!-- This is data table -->
{{Html::script('assets/js/jquery.dataTables.min.js')}}
<!-- start - This is for export functionality only -->
{{Html::script('assets/js/dataTables.buttons.min.js')}}
{{Html::script('assets/js/buttons.flash.min.js')}}
{{Html::script('assets/js/jszip.min.js')}}
{{Html::script('assets/js/pdfmake.min.js')}}
{{Html::script('assets/js/vfs_fonts.js')}}
{{Html::script('assets/js/buttons.html5.min.js')}}
{{Html::script('assets/js/buttons.print.min.js')}}
{{Html::script('assets/custom_js/crud.js')}}
{{Html::script('assets/custom_js/datatable.js')}}
{{Html::script('assets/custom_js/add_more.js')}}



  {{Html::script('assets/js/select2.min.js')}}

  <script>
     $(document).ready(function($) {
      $(".js-example-responsive").select2({
        width: '100%'
      });

    });


     $(document).on('change','#acc_id_1', function(){
     		var id = $(this).val();
     		var op = '';
			$.ajax({
	            type:'get',
	            url:'{!!URL::to('get-change-account-two')!!}',
	            data:{'id':id},
	            success:function(data){
	            	 op+='<option value="0" selected disabled>Select Account Category</option>';
		                for(var i=0;i<data.length;i++){
		                op+='<option value="'+data[i].id+'">'+data[i].code+'-'+data[i].name+'</option>';
		               }

		               $('#acc_id_2').html(" ");
		               $('#acc_id_2').append(op);
	            },
	            error:function(){

	            }
	        });
     });

     $(document).on('change','#acc_id_2', function(){
     		var id = $(this).val();
     		var op = '';
			$.ajax({
	            type:'get',
	            url:'{!!URL::to('get-change-account-three')!!}',
	            data:{'id':id},
	            success:function(data){
	            	 op+='<option value="0" selected disabled>Select Account Category</option>';
		                for(var i=0;i<data.length;i++){
		                op+='<option value="'+data[i].id+'">'+data[i].code+'-'+data[i].name+'</option>';
		               }

		               $('#acc_id_3').html(" ");
		               $('#acc_id_3').append(op);
	            },
	            error:function(){

	            }
	        });
     });

     $(document).on('change','#acc_id_3', function(){
     		var id = $(this).val();
     		var op = '';
			$.ajax({
	            type:'get',
	            url:'{!!URL::to('get-change-account-four')!!}',
	            data:{'id':id},
	            success:function(data){
	            	console.log(data);
	            	 op+='<option value="0" selected disabled>Select Account</option>';
		                for(var i=0;i<data.length;i++){
		                op+='<option value="'+data[i].id+'">'+data[i].ad_code+'-'+data[i].name+'</option>';
		               }

		               $('#acc_id_4').html(" ");
		               $('#acc_id_4').append(op);
	            },
	            error:function(){

	            }
	        });
     });

  </script>

@endsection