@section('title','income-statement')
@extends('layouts.master')
@section('style')
{{Html::style('assets/css/daterangepicker.css')}}
<style>
td form {
    display: inline-block;
}
</style>
@endsection


@section('content')
<script>
function printContent(el){
  var restorepage = document.body.innerHTML;
  var printcontent = document.getElementById(el).innerHTML;
  document.body.innerHTML = printcontent;
  window.print();
  document.body.innerHTML = restorepage;
}
</script>
<div class="page-wrapper">
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12 text-right">
            <span onclick="printContent('income_statement')"><span class="fa fa-print btn btn-lg danger" style="color: red; margin-bottom: 10px;"></span></span>
            </div>
        </div>
            <div class="col-md-12 text-center" id="income_statement" >
                <div class="text-center">
                @if($shopinfo->shop_name!=null)<h4>{{$shopinfo->shop_name}}</h4>
                  <address>
                  <p>{{$shopinfo->shop_address}}</p>
                  <p>{{$shopinfo->shop_email}} , {{$shopinfo->shop_phone}}</p>
                  </address>
                  @else
                  <h4>Leftjoin</h4>
                   <address>
                  <p>Mirpur ,Dhaka</p>
                  <p>leftjoin@gmail.com , 01738088325</p>
                  </address>
                  @endif

                <h4>{{trans('label.Ledger')}} </h4>
                </div>
                <table id="example23" class="display nowrap table table-hover table-striped table-bordered" cellspacing="0" width="100%">
                    <thead>
                        <tr>
                            <th colspan="3">{{trans('label.Account Name')}} <span class="">:</span> {{$acc_name->name}}</th>
                            <th colspan="3">{{__('label.date')}} <span class="">:</span>{{date('d-m-Y',strtotime($start_date))}} To {{date('d-m-Y',strtotime($end_date))}}</th>
                        </tr>
                        <tr>
                            <th>{{trans('label.Date')}}</th>
                            <th>{{trans('label.Voucher No.')}}</th>
                            <th>{{trans('label.Particuler')}}</th>
                            <th>{{trans('label.Debit')}}</th>
                            <th>{{trans('label.Credit')}}</th>
                            <th>{{trans('label.Balance')}}</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>{{date('d-m-Y',strtotime($start_date))}}</td>
                            <td colspan="4">{{trans('label.balance')}}</td>
                            <td class="text-right">
                            {{ number_format($lg_d = $balance->total_debit-$balance->total_credit,2)}}
                            </td>
                        </tr>
                        @php
                        $bal = $lg_d;
                        @endphp
                        @forelse($ledgers as $value)
                        <tr>
                            <td>{{date('d-m-Y',strtotime($value->lg_voucher_date))}}</td>
                            <td>{{$value->lg_voucher_no}}</td>
                            <td>{{$value->lg_particulars}}</td>
                            <td class="text-right">{{$value->lg_dr_amt}}</td>
                            <td class="text-right">{{$value->lg_cr_amt}}</td>
                            @if($value->lg_dr_amt > 0)
                            <td class="text-right">{{ $bal = $value->lg_dr_amt+$bal}}</td>
                            @elseif($value->lg_cr_amt > 0)
                            <td class="text-right">{{$bal = -$value->lg_cr_amt+$bal}}</td>
                            @endif
                        </tr>
                        @empty
                        @endforelse
                    </tbody>
                </table>
            </div>

    </div>
</div>

@endsection


@section('script')

<!--stickey kit -->
{{Html::script('assets/js/sticky-kit.min.js')}}
{{Html::script('assets/js/jquery.sparkline.min.js')}}
<!-- This is data table -->
{{Html::script('assets/js/jquery.dataTables.min.js')}}
<!-- start - This is for export functionality only -->
{{Html::script('assets/js/dataTables.buttons.min.js')}}
{{Html::script('assets/js/buttons.flash.min.js')}}
{{Html::script('assets/js/jszip.min.js')}}
{{Html::script('assets/js/pdfmake.min.js')}}
{{Html::script('assets/js/vfs_fonts.js')}}
{{Html::script('assets/js/buttons.html5.min.js')}}
{{Html::script('assets/js/buttons.print.min.js')}}
{{Html::script('assets/custom_js/crud.js')}}
{{Html::script('assets/custom_js/datatable.js')}}

{{Html::script('assets/js/moment.min.js')}}
{{Html::script('assets/js/daterangepicker.min.js')}}




@endsection