@section('title','Chart of account')
@extends('layouts.master')
@section('style')
<style>
td form {
    display: inline-block;
}
body {
    counter-reset: serial-number;
}
table#example23 tr td:first-child:before {
    counter-increment: serial-number;
    content: counter(serial-number);
}
</style>
@endsection


@section('content')

<div class="page-wrapper">
    <div class="container-fluid">
        <div class="row page-titles">

            <div class="col-md-5 align-self-center">
                <h4 class="text-themecolor title"><span id="heading_field"></span> {{trans('label.Chart of Account')}}</h4>
            </div>
            <div class="col-md-7 align-self-center text-right">
               
            </div>
        </div>

        <div class="row">
            <div class="col-12">
                
                  
                <div class="card-body-wrapper">
                    
                       

                    <div id='table_position'>
                        <div class="table-responsive">
                            <table id="example23" class="display nowrap table table-hover table-striped table-bordered" cellspacing="0" width="100%">
                                <thead>
                                    <tr>
                                        <th>{{trans('label.ID')}}</th>
                                        <th>{{trans('label.Account Head')}}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($info as $key=>$in_value)
                                    <tr>

                                        <td class="text-right"></td>
                                        <td>
                                            <div id="accordion">
                                                  <div class="card">
                                                    <div class="card-header" id="headingOne">
                                                      <h5 class="mb-0">
                                                        <button class="btn btn-link" data-toggle="collapse" data-target="#collapse{{$key}}" aria-expanded="false" aria-controls="collapse{{$key}}">
                                                          {{$in_value->ah_name ?? ''}}
                                                        </button>
                                                      </h5>
                                                    </div>

                                                    <div id="collapse{{$key}}" class="collapse hide" aria-labelledby="headingOne" data-parent="#accordion">
                                                      <div class="card-body">
                                                        <table class="table">
                                                            <thead>
                                                                <tr>
                                                                    <th>{{trans('label.ID')}}</th>
                                                                    <th>{{trans('label.Account Head')}}</th>
                                                                    <th>{{trans('label.Account Name')}}</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                                @forelse($in_value->chart_detail as $cd=>$second_level)
                                                                <tr>
                                                                    <td>{{($cd+1)}}</td>
                                                                    <td>{{ $second_level->code ?? '' }}</td>
                                                                    <td>{{ $second_level->name ?? ''  }}</td>
                                                                    
                                                                </tr>
                                                                @empty
                                                                <tr>
                                                                    <td colspan="4"></td>
                                                                </tr>
                                                                @endforelse
                                                                
                                                            </tbody>
                                                        </table>
                                                      </div>
                                                    </div>
                                                  </div>
                                                 
                                                </div>
                                        </td>
                                        
                                    </tr>
                                @empty
                                @endforelse
                                </tbody>
                            </table>
                            </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>

@endsection


@section('script')

<!--stickey kit -->
{{Html::script('assets/js/sticky-kit.min.js')}}
{{Html::script('assets/js/jquery.sparkline.min.js')}}
<!-- This is data table -->
{{Html::script('assets/js/jquery.dataTables.min.js')}}
<!-- start - This is for export functionality only -->
{{Html::script('assets/js/dataTables.buttons.min.js')}}
{{Html::script('assets/js/buttons.flash.min.js')}}
{{Html::script('assets/js/jszip.min.js')}}
{{Html::script('assets/js/pdfmake.min.js')}}
{{Html::script('assets/js/vfs_fonts.js')}}
{{Html::script('assets/js/buttons.html5.min.js')}}
{{Html::script('assets/js/buttons.print.min.js')}}
{{Html::script('assets/custom_js/crud.js')}}
{{Html::script('assets/custom_js/datatable.js')}}
{{Html::script('assets/custom_js/add_more.js')}}

<script>
</script>

@endsection