@section('title','income-statement')
@extends('layouts.master')
@section('style')
{{Html::style('assets/css/daterangepicker.css')}}
<style>
td form {
    display: inline-block;
}
</style>
@endsection


@section('content')
<script>
function printContent(el){
  var restorepage = document.body.innerHTML;
  var printcontent = document.getElementById(el).innerHTML;
  document.body.innerHTML = printcontent;
  window.print();
  document.body.innerHTML = restorepage;
}
</script>
<div class="page-wrapper">
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12 text-right">
            <span onclick="printContent('income_statement')"><span class="fa fa-print btn btn-lg danger" style="color: red; margin-bottom: 10px;"></span></span>
            </div>
        </div>
            <div class="col-md-12 text-center" id="income_statement" >
                <div class="text-center">
                @if($shopinfo->shop_name!=null)<h4>{{$shopinfo->shop_name}}</h4>
                  <address>
                  <p>{{$shopinfo->shop_address}}</p>
                  <p>{{$shopinfo->shop_email}} , {{$shopinfo->shop_phone}}</p>
                  </address>
                  @else
                  <h4>Leftjoin</h4>
                   <address>
                  <p>Mirpur ,Dhaka</p>
                  <p>leftjoin@gmail.com , 01738088325</p>
                  </address>
                  @endif

                <h4>{{trans('label.Balance Sheet')}} </h4>
                </div>
                <table id="example23" class="display nowrap table table-hover table-striped table-bordered" cellspacing="0" width="100%">
                    <thead>
                        <tr>
                            <th>{{trans('label.Head')}}</th>
                            <th>{{trans('label.Account Category')}}</th>
                            <th>{{trans('label.Amount')}}</th>
                        </tr>
                    </thead>
                    	<tr>
                    		<th class="text-left" colspan="3">{{trans('label.Liabilities')}}</th>
                    	</tr>
                    	<tr>
                    		<td></td>
                    		<td class="text-left">Opening Balance</td>
                    		<td class="text-right">{{$lib_balance->total_credit - $lib_balance->total_debit}}</td>
                    	</tr>
                    	@php
                    	$t_lib = 0;
                    	@endphp
                    	@forelse($libilities as $data)
                    	@php
                    	$t_lib += $data->total_credit - $data->total_debit;
                    	@endphp
                    	<tr>
                    		<td></td>
                    		<td class="text-left">{{$data->name}}</td>
                    		<td class="text-right">{{$data->total_credit - $data->total_debit}}</td>
                    	</tr>
                    	@empty
                    	@endforelse
                    	<tr>
                    		<th></th>
                    		<th class="text-right">Total</th>
                    		<th class="text-right">{{$t_lib}}</th>
                    	</tr>
                    	<tr>
                    		<th class="text-left" colspan="3">{{trans('label.Capital')}}</th>
                    	</tr>
                    	<tr>
                    		<td></td>
                    		<td class="text-left">Opening Balance</td>
                    		<td class="text-right">{{$cap_balance->total_credit - $cap_balance->total_debit}}</td>
                    	</tr>
                    	@php
                    	$t_cap =0;
                    	@endphp
                    	@forelse($capitals as $data)
                    	@php
                    	$t_cap += $data->total_credit - $data->total_debit;
                    	@endphp
                    	<tr>
                    		<td></td>
                    		<td class="text-left">{{$data->name}}</td>
                    		<td class="text-right">{{$data->total_credit - $data->total_debit}}</td>
                    	</tr>
                    	@empty
                    	@endforelse
                    	<tr>
                    		@if($t_incomes > $t_expanses)
                    		<th></th>
                    		<th class="text-right">Net Profit</th>
                    		<th class="text-right">{{$lp = $t_incomes-$t_expanses}}</th>
                    		@elseif($t_incomes < $t_expanses)
                    		<th></th>
                    		<th class="text-right">Net Loss</th>
                    		<th class="text-right">{{$lp = $t_incomes-$t_expanses}}</th>
                    		@elseif($t_incomes == $t_expanses)
                    		<th></th>
                    		<th class="text-right">No Loss/Profit</th>
                    		<th class="text-right">{{$lp = $t_expanses-$t_incomes}}</th>
                    		@endif
                    	</tr>
                    	<tr>
                    		<th></th>
                    		<th class="text-right">Total</th>
                    		<th class="text-right">{{$t_cap+$lp+$t_lib}}</th>
                    	</tr>
                    	<tr>
                    		<th class="text-left" colspan="3">{{trans('label.Assets')}}</th>
                    	</tr>

                    	<tr>
                    		<td></td>
                    		<td class="text-left">Opening Balance</td>
                    		<td class="text-right">{{$ass_balance->total_debit - $ass_balance->total_credit}}</td>
                    	</tr>
                    	@php
                    	$t_ass =0;
                    	@endphp
                    	@forelse($assets as $data)
                    	@php
                    	$t_ass += $data->total_debit - $data->total_credit;
                    	@endphp
                    	<tr>
                    		<td></td>
                    		<td class="text-left">{{$data->name}}</td>
                    		<td class="text-right">{{$data->total_debit - $data->total_credit}}</td>
                    	</tr>
                    	@empty
                    	@endforelse
                    	<tr>
                    		<th></th>
                    		<th class="text-right">Total</th>
                    		<th class="text-right">{{$t_ass}}</th>
                    	</tr>
                    <tbody>
                </table>
            </div>

    </div>
</div>

@endsection


@section('script')

<!--stickey kit -->
{{Html::script('assets/js/sticky-kit.min.js')}}
{{Html::script('assets/js/jquery.sparkline.min.js')}}
<!-- This is data table -->
{{Html::script('assets/js/jquery.dataTables.min.js')}}
<!-- start - This is for export functionality only -->
{{Html::script('assets/js/dataTables.buttons.min.js')}}
{{Html::script('assets/js/buttons.flash.min.js')}}
{{Html::script('assets/js/jszip.min.js')}}
{{Html::script('assets/js/pdfmake.min.js')}}
{{Html::script('assets/js/vfs_fonts.js')}}
{{Html::script('assets/js/buttons.html5.min.js')}}
{{Html::script('assets/js/buttons.print.min.js')}}
{{Html::script('assets/custom_js/crud.js')}}
{{Html::script('assets/custom_js/datatable.js')}}

{{Html::script('assets/js/moment.min.js')}}
{{Html::script('assets/js/daterangepicker.min.js')}}




@endsection