@section('title','Account Sub-Category')
@extends('layouts.master')
@section('style')
    {{Html::style('assets/css/jquery-ui.css')}}
    {{Html::style('assets/css/select2.min.css')}}
    {{Html::style('assets/css/custom_search.css')}} //for select 2 css
@endsection



@section('content')

<div class="page-wrapper">
    <div class="container-fluid">
        <div class="row page-titles">

            <div class="col-md-5 align-self-center">
                <h4 class="text-themecolor title"><span id="heading_field"></span> {{trans('label.Account Sub-cateogry')}}</h4>
            </div>
            <div class="col-md-7 align-self-center text-right">
                @if(Auth::user()->position_id ==1)
                <div class="d-flex justify-content-end align-items-center">
                    <div class="add_form_btn" style="text-align: right"><button class="btn btn-primary add"><i class="fa fa-plus-circle" aria-hidden="true"></i>{{trans('label.Create New')}} </button><button class="btn btn-danger remove" style="display: none;"><i class="fa fa-times" aria-hidden="true"></i> {{trans('label.Back')}}</button></div>
                </div>
                @endif
            </div>
        </div>

        <div class="row">
            <div class="col-12">
                @if (Session::has('message'))
                  <h6 style="background: #20c997; color: #fff; text-align: center; padding: 5px; border-radius: 5px;">{{ Session::get('message') }}</h6>
                  @endif
                  <div id="add_form" style="display: none;">
                      
                        @include('account-two.create')
                        
                    </div>
                <div class="card-body-wrapper">
                    
                     <div id="search_form">
                       
                            @include('account-two.search')
                        
                    </div>
                       

                    <div id='table_position'>
                        <div class="table-responsive">
                            <table id="example23" class="display nowrap table table-hover table-striped table-bordered" cellspacing="0" width="100%">
                                <thead>
                                    <tr>
                                        <th>{{trans('label.ID')}}</th>
                                        <th>{{trans('label.Account Category')}}</th>
                                        <th>{{trans('label.ID')}}</th>
                                        <th>{{trans('label.Account Code')}}</th>
                                        <th>{{trans('label.Name')}}</th>
                                        <th>{{trans('label.Action')}}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($info as $key=>$in_value)
                                    <tr>

                                        <td class="text-right"></td>
                                        <td>{{ $in_value->account_category->name ?? '' }}</td>
                                        <td>{{ $in_value->id ?? '' }}</td>
                                        <td>{{ $in_value->code ?? '' }}</td>
                                        <td>
                                           {{ $in_value->name ?? '' }}
                                        </td>
                                        
                                        <td>
                                            @if(Auth::user()->position_id ==1)
                                            <a href="{{url('account-level-two',$in_value->id)}}"  title="edit" class="btn btn-light btn-sm"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></a>
                                            @endif
                                            @if(Auth::user()->position_id ==1)
                                            <a onclick="return confirm('Are You sure ?')" href="{{url('account-level-two-delete',$in_value->id)}}"  title="edit" class="btn btn-light btn-sm"><i class="fa fa-trash" aria-hidden="true"></i></a>
                                            @endif
                                        </td>
                                    </tr>
                                @empty
                                @endforelse
                                </tbody>
                            </table>
                            </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>

@endsection


@section('script')

<!--stickey kit -->
{{Html::script('assets/js/sticky-kit.min.js')}}
{{Html::script('assets/js/jquery.sparkline.min.js')}}
<!-- This is data table -->
{{Html::script('assets/js/jquery.dataTables.min.js')}}
<!-- start - This is for export functionality only -->
{{Html::script('assets/js/dataTables.buttons.min.js')}}
{{Html::script('assets/js/buttons.flash.min.js')}}
{{Html::script('assets/js/jszip.min.js')}}
{{Html::script('assets/js/pdfmake.min.js')}}
{{Html::script('assets/js/vfs_fonts.js')}}
{{Html::script('assets/js/buttons.html5.min.js')}}
{{Html::script('assets/js/buttons.print.min.js')}}
{{Html::script('assets/custom_js/crud.js')}}
{{Html::script('assets/custom_js/datatable.js')}}
{{Html::script('assets/custom_js/add_more.js')}}



{{Html::script('assets/js/select2.min.js')}} //for select 2 plugin
<script>
     $(document).ready(function($) {
      $(".js-example-responsive").select2({
        width: '100%'
      });
    });
  </script>

@endsection