@section('title','Account Head Edit')
@extends('layouts.master')
@section('style')
<style>
td form {
    display: inline-block;
}
body {
    counter-reset: serial-number;
}
table#example23 tr td:first-child:before {
    counter-increment: serial-number;
    content: counter(serial-number);
}
</style>
@endsection


@section('content')

<div class="page-wrapper">

    <div class="container-fluid">
        <div class="row page-titles">
            <div class="col-md-5 align-self-center">
                <h4 class="text-themecolor title"><span id="heading_field"></span>{{trans('label.Update')}}</h4>
            </div>
            <div class="col-md-7 align-self-center text-right">
                <div class="d-flex justify-content-end align-items-center">
                    <button class="btn btn-primary add" style="text-align: right"><a href="{{url('account-level-two')}}" style="color: #fff"><i class="fa fa-chevron-circle-left" aria-hidden="true"></i> {{trans('label.Back')}}</a></button>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div>
                            @if(!empty($info))
                                    <form class=""  method="post" action="{{url('account-level-two-update')}}"  >
                                    {{csrf_field()}}
                                    <div class="row">
                                         <div class="col-md-2">
                                            <div class="form-group">
                                                <label for="al1_id">{{trans('label.Account head')}} </label>
                                                <div class="controls">
                                                    <select name="al1_id" class="form-control js-example-responsive">
                                                        <option value="">Select Account Head</option>
                                                        @forelse($account_heads as $value)
                                                         <option @if(isset($info->al1_id)) @if($info->al1_id==$value->id) selected @endif  @endif value="{{ $value->id }}">{{ $value->name ?? '' }}</option>
                                                        @empty
                                                        @endforelse
                                                    </select>

                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label for="code">{{trans('label.Account Category Code')}} <span class="text-danger">*</span></label>
                                                <div class="controls">
                                                    <input type="text" name="code" id="code" class="form-control"  value="{{ $info->code ?? '' }}" required="required">
                                                    <input type="hidden" name="id" id="id" class="form-control"  value="{{ $info->id ?? ''}}" required="required">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label for="name">{{trans('label.Account Category Name ')}}<span class="text-danger">*</span></label>
                                                <div class="controls">
                                                    <input type="text" name="name" id="name" class="form-control"  value="{{ $info->name ?? ''}}" required="required" autocomplete="off">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-2">
                                            <div class="form-group">
                                                <label for="name">{{trans('label.Status')}}<span class="text-danger">*</span></label>
                                                <div class="controls">
                                                    <select name="status" class="form-control">
                                                        <option value="1" @if($info->status==1) selected @endif >Active</option>
                                                        <option value="0" @if($info->status==0) selected @endif>In-Active</option>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <div class="col-md-3">
                                            <div class="text-xs-right w-100" style="margin-top:25px">
                                            <button type="submit" class="btn btn-success w-48">{{trans('label.Submit')}}</button>
                                            <button type="reset" class="btn btn-inverse reset_button w-48">{{trans('label.Cancel')}}</button>
                                            </div>
                                        </div>

                                    </div>

                                    </form>

                                    @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>

@endsection


@section('script')

<!--stickey kit -->
{{Html::script('assets/js/sticky-kit.min.js')}}
{{Html::script('assets/js/jquery.sparkline.min.js')}}
<!-- This is data table -->
{{Html::script('assets/js/jquery.dataTables.min.js')}}
<!-- start - This is for export functionality only -->
{{Html::script('assets/js/dataTables.buttons.min.js')}}
{{Html::script('assets/js/buttons.flash.min.js')}}
{{Html::script('assets/js/jszip.min.js')}}
{{Html::script('assets/js/pdfmake.min.js')}}
{{Html::script('assets/js/vfs_fonts.js')}}
{{Html::script('assets/js/buttons.html5.min.js')}}
{{Html::script('assets/js/buttons.print.min.js')}}
{{Html::script('assets/custom_js/crud.js')}}
{{Html::script('assets/custom_js/datatable.js')}}

<!-- end - This is for export functionality only -->
{{-- {{Html::script('assets/public_js/index.js')}} --}}
<script>
</script>

@endsection