<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\VendorProfile;
use App\CustomerProfile;
use App\SupplierProfile;
use DB;
use Carbon\Carbon;
use Auth;

class VendorProfilesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index() {

        $library = new \App\Library\Library;
        if ($library->check_user_access('supplier_view')) {
            $crud = new \App\Library\Crud;
            $customer_category = $crud->Getvalue('CustomerCategory');
            $TransactionTerm = $crud->Getvalue('TransactionTerm');
            $info = DB::select(" SELECT t.id as id,t.name as name,t.address as address,t.catname,t.phone as phone,t.receive,t.payment
FROM (
    SELECT vf.id as id,vf.name as name,vf.address as address,vf.phone as phone,cc.name as catname,(SUM(IFNULL(ca.debit,0))-SUM(IFNULL(ca.credit,0))- SUM(IFNULL(sa.credit,0))-SUM(IFNULL(sa.debit,0)))  as receive,
    (SUM(IFNULL(sa.credit,0))-SUM(IFNULL(sa.debit,0))-SUM(IFNULL(ca.debit,0))-SUM(IFNULL(ca.credit,0))) as payment FROM `vendor_profiles` as vf
LEFT JOIN customer_categories as cc ON cc.id=vf.category_id
LEFT JOIN customer_profiles as cp ON cp.common_id=vf.id
LEFT JOIN supplier_profiles as sp ON sp.common_id=vf.id
LEFT JOIN customer_accounts as ca ON ca.account_no = cp.id
LEFT JOIN supplier_accounts as sa ON sa.account_no=sp.id
WHERE 1
GROUP BY vf.id
ORDER BY vf.id DESC) as t ");


            return view('customer_suppliers.index', compact('info', 'customer_category', 'TransactionTerm'));
        } else {
            return "Sorry you don't have access to this action";
        }

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //return $request->all();
        $date = Carbon::today();
        $VendorProfile = new VendorProfile();
        $VendorProfile->name = $request->name ?? '';
        $VendorProfile->transection_term_id = $request->transection_term_id ?? '';
        $VendorProfile->category_id = $request->category_id ?? '';
        $VendorProfile->phone = $request->phone ?? '';
        $VendorProfile->address = $request->address ?? '';
        $VendorProfile->save();

         $common_id = $VendorProfile->id;

        $CustomerProfile = new CustomerProfile();
        $CustomerProfile->name = $request->name ?? '';
        $CustomerProfile->transection_term_id = $request->transection_term_id ?? '';
        $CustomerProfile->category_id = $request->category_id ?? '';
        $CustomerProfile->phone = $request->phone ?? '';
        $CustomerProfile->address = $request->address ?? '';
        $CustomerProfile->common_id = $common_id ?? '';
        $CustomerProfile->save();

        $SupplierProfile = new SupplierProfile();
        $SupplierProfile->name = $request->name ?? '';
        $SupplierProfile->transection_term_id = $request->transection_term_id ?? '';
        $SupplierProfile->category_id = $request->category_id ?? '';
        $SupplierProfile->phone = $request->phone ?? '';
        $SupplierProfile->address = $request->address ?? '';
        $SupplierProfile->common_id = $common_id ?? '';
        $SupplierProfile->save();
       $crud = new \App\Library\Crud;
        $library = new \App\Library\Library;
        
        if ($request->debit != 0 && $request->debit != '') {
            $collection = $library->add_element($request->all(), ['account_no' => $common_id, 'transection_no' => 'opening', 'transection_date' => $date, 'created_by' => Auth::user()->id]);
            $crud->InsertValue('CustomerAccounts', $collection);
        }
        if ($request->credit != 0 && $request->credit != '') {
            $collection = $library->add_element($request->all(), ['account_no' => $common_id, 'transection_no' => 'opening', 'transection_date' => $date, 'created_by' => Auth::user()->id]);
            $crud->InsertValue('SupplierAccount', $collection);
        }
      
        return "";                   
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
   public function edit($id) {
        $library = new \App\Library\Library();
        if ($library->check_user_access('customer_edit')) {
            $crud = new \App\Library\Crud;
            $customer_category = $crud->Getvalue('CustomerCategory');
            $TransactionTerm = $crud->Getvalue('TransactionTerm');
            $info = $crud->GetValueWhereSingle('VendorProfile', ['id', $id]);
            return view('customer_suppliers.edit', compact('info',  'customer_category', 'TransactionTerm'));
        } else {
            return "Sorry you don't have access to this action";
        }

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {

        //return $request->all();
        $VendorProfile = VendorProfile::where('id',$request->id)->first();
        $VendorProfile->name = $request->name ?? '';
        $VendorProfile->transection_term_id = $request->transection_term_id ?? '';
        $VendorProfile->category_id = $request->category_id ?? '';
        $VendorProfile->phone = $request->phone ?? '';
        $VendorProfile->address = $request->address ?? '';
        $VendorProfile->save();

        $common_id = $VendorProfile->id;

        $CustomerProfile = CustomerProfile::where('common_id',$common_id )->first();
       // dd($CustomerProfile);

        $CustomerProfile->name = $request->name ?? '';
        $CustomerProfile->transection_term_id = $request->transection_term_id ?? '';
        $CustomerProfile->category_id = $request->category_id ?? '';
        $CustomerProfile->phone = $request->phone ?? '';
        $CustomerProfile->address = $request->address ?? '';
        $CustomerProfile->common_id = $common_id ?? '';
        $CustomerProfile->save();

        $SupplierProfile =  SupplierProfile::where('common_id',$common_id )->first();
        $SupplierProfile->name = $request->name ?? '';
        $SupplierProfile->transection_term_id = $request->transection_term_id ?? '';
        $SupplierProfile->category_id = $request->category_id ?? '';
        $SupplierProfile->phone = $request->phone ?? '';
        $SupplierProfile->address = $request->address ?? '';
        $SupplierProfile->common_id = $common_id ?? '';
        $SupplierProfile->save();
        return redirect('customer')->with('message', 'Updated Successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
